/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.ai;

import com.alibaba.nacos.ai.form.mcp.McpDetailForm;
import com.alibaba.nacos.ai.form.mcp.McpForm;
import com.alibaba.nacos.ai.form.mcp.McpListForm;
import com.alibaba.nacos.ai.param.McpHttpParamExtractor;
import com.alibaba.nacos.ai.utils.McpRequestUtil;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.console.proxy.ai.McpProxy;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/ai/mcp"})
@ExtractorManager.Extractor(httpExtractor=McpHttpParamExtractor.class)
public class ConsoleMcpController {
    private final McpProxy mcpProxy;

    public ConsoleMcpController(McpProxy mcpProxy) {
        this.mcpProxy = mcpProxy;
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<Page<McpServerBasicInfo>> listMcpServers(McpListForm mcpListForm, PageForm pageForm) throws NacosException {
        mcpListForm.validate();
        pageForm.validate();
        return Result.success(this.mcpProxy.listMcpServers(mcpListForm.getNamespaceId(), mcpListForm.getMcpName(), mcpListForm.getSearch(), pageForm.getPageNo(), pageForm.getPageSize()));
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<McpServerDetailInfo> getMcpServer(McpForm mcpForm) throws NacosException {
        mcpForm.validate();
        return Result.success((Object)this.mcpProxy.getMcpServer(mcpForm.getNamespaceId(), mcpForm.getMcpName()));
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> createMcpServer(McpDetailForm mcpForm) throws NacosException {
        mcpForm.validate();
        McpServerBasicInfo basicInfo = McpRequestUtil.parseMcpServerBasicInfo((McpDetailForm)mcpForm);
        McpToolSpecification mcpTools = McpRequestUtil.parseMcpTools((McpDetailForm)mcpForm);
        McpEndpointSpec endpointSpec = McpRequestUtil.parseMcpEndpointSpec((McpServerBasicInfo)basicInfo, (McpDetailForm)mcpForm);
        this.mcpProxy.createMcpServer(mcpForm.getNamespaceId(), mcpForm.getMcpName(), basicInfo, mcpTools, endpointSpec);
        return Result.success((Object)"ok");
    }

    @PutMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> updateMcpServer(McpDetailForm mcpForm) throws NacosException {
        mcpForm.validate();
        McpServerBasicInfo basicInfo = McpRequestUtil.parseMcpServerBasicInfo((McpDetailForm)mcpForm);
        McpToolSpecification mcpTools = McpRequestUtil.parseMcpTools((McpDetailForm)mcpForm);
        McpEndpointSpec endpointSpec = McpRequestUtil.parseMcpEndpointSpec((McpServerBasicInfo)basicInfo, (McpDetailForm)mcpForm);
        this.mcpProxy.updateMcpServer(mcpForm.getNamespaceId(), mcpForm.getMcpName(), basicInfo, mcpTools, endpointSpec);
        return Result.success((Object)"ok");
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> deleteMcpServer(McpForm mcpForm) throws NacosException {
        mcpForm.validate();
        this.mcpProxy.deleteMcpServer(mcpForm.getNamespaceId(), mcpForm.getMcpName());
        return Result.success((Object)"ok");
    }
}

