/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.config;

import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.console.config.NacosConsoleAuthConfig;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import com.alibaba.nacos.sys.module.AbstractConsoleModuleStateBuilder;
import com.alibaba.nacos.sys.module.ModuleState;
import java.util.Optional;

public class ConsoleAuthModuleStateBuilder
extends AbstractConsoleModuleStateBuilder {
    public static final String AUTH_MODULE = "console_auth";
    public static final String AUTH_ENABLED = "auth_enabled";
    public static final String LOGIN_PAGE_ENABLED = "login_page_enabled";
    public static final String AUTH_SYSTEM_TYPE = "auth_system_type";
    private boolean cacheable;

    public ModuleState build() {
        ModuleState result = new ModuleState(AUTH_MODULE);
        NacosAuthConfig authConfig = NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosConsoleAuthConfig.NACOS_CONSOLE_AUTH_SCOPE);
        result.newState(AUTH_ENABLED, (Object)authConfig.isAuthEnabled());
        result.newState(LOGIN_PAGE_ENABLED, (Object)this.isLoginPageEnabled(authConfig));
        result.newState(AUTH_SYSTEM_TYPE, (Object)authConfig.getNacosAuthSystemType());
        return result;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    private Boolean isLoginPageEnabled(NacosAuthConfig authConfigs) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(authConfigs.getNacosAuthSystemType());
        return authPluginService.map(AuthPluginService::isLoginEnabled).orElse(false);
    }
}

