/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.sql;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDumpEvent;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EmbeddedStorageContextUtils {
    public static void onModifyConfigInfo(ConfigInfo configInfo, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(false).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).encryptedDataKey(configInfo.getEncryptedDataKey()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onModifyConfigBetaInfo(ConfigInfo configInfo, String betaIps, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(true).betaIps(betaIps).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).encryptedDataKey(configInfo.getEncryptedDataKey()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onModifyConfigTagInfo(ConfigInfo configInfo, String tag, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(false).tag(tag).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onModifyConfigGrayInfo(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(false).namespaceId(configInfo.getTenant()).dataId(configInfo.getDataId()).group(configInfo.getGroup()).isBeta(false).grayName(grayName).grayRule(grayRule).content(configInfo.getContent()).type(configInfo.getType()).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigInfo(String namespaceId, String group, String dataId, String srcIp, Timestamp time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(group).dataId(dataId).isBeta(false).handleIp(srcIp).lastModifiedTs(time.getTime()).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onBatchDeleteConfigInfo(List<ConfigAllInfo> configInfos) {
        if (!EnvUtil.getStandaloneMode()) {
            ArrayList<ConfigDumpEvent> events = new ArrayList<ConfigDumpEvent>();
            for (ConfigAllInfo configInfo : configInfos) {
                String namespaceId = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
                ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(configInfo.getGroup()).dataId(configInfo.getDataId()).isBeta(false).build();
                events.add(event);
            }
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFOS_CONFIG_DUMP_EVENT, JacksonUtils.toJson(events));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigBetaInfo(String namespaceId, String group, String dataId, long time) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).dataId(dataId).group(group).isBeta(true).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigTagInfo(String namespaceId, String group, String dataId, String tag, String srcIp) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(group).dataId(dataId).isBeta(true).tag(tag).handleIp(srcIp).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }

    public static void onDeleteConfigGrayInfo(String namespaceId, String group, String dataId, String grayName, String srcIp) {
        if (!EnvUtil.getStandaloneMode()) {
            ConfigDumpEvent event = ConfigDumpEvent.builder().remove(true).namespaceId(namespaceId).group(group).dataId(dataId).isBeta(true).grayName(grayName).handleIp(srcIp).build();
            HashMap<String, String> extendInfo = new HashMap<String, String>(2);
            extendInfo.put(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT, JacksonUtils.toJson((Object)((Object)event)));
            EmbeddedStorageContextHolder.putAllExtendInfo(extendInfo);
        }
    }
}

