/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.query;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.service.query.ConfigQueryHandlerChain;
import com.alibaba.nacos.config.server.service.query.ConfigQueryHandlerChainBuilder;
import com.alibaba.nacos.config.server.service.query.enums.ResponseCode;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigQueryChainService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigQueryChainService.class);
    private final ConfigQueryHandlerChain chain;

    public ConfigQueryChainService() {
        String curChain = EnvUtil.getProperty((String)"nacos.config.query.chain.builder", (String)"nacos");
        Optional<ConfigQueryHandlerChainBuilder> optionalBuilder = NacosServiceLoader.load(ConfigQueryHandlerChainBuilder.class).stream().filter(builder -> builder.getName().equals(curChain)).findFirst();
        if (!optionalBuilder.isPresent()) {
            String errorMessage = "No suitable ConfigQueryHandlerChainBuilder found for name: " + curChain;
            LOGGER.error(errorMessage);
            throw new NacosConfigException(errorMessage);
        }
        this.chain = optionalBuilder.get().build();
        LOGGER.info("ConfigQueryHandlerChain has been initialized successfully with chain: {}", (Object)curChain);
    }

    public ConfigQueryChainResponse handle(ConfigQueryChainRequest request) {
        try {
            return this.chain.handle(request);
        }
        catch (Exception e) {
            LOGGER.error("[Error] Fail to handle ConfigQueryChainRequest", (Throwable)e);
            return ConfigQueryChainResponse.buildFailResponse(ResponseCode.FAIL.getCode(), e.getMessage());
        }
    }
}

