/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.listener;

import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.remote.ConfigChangeListenContext;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.listener.ConfigListenerStateService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class LocalConfigListenerStateServiceImpl
implements ConfigListenerStateService {
    private final LongPollingService longPollingService;
    private final ConfigChangeListenContext configChangeListenContext;
    private final ConnectionManager connectionManager;

    public LocalConfigListenerStateServiceImpl(LongPollingService longPollingService, ConfigChangeListenContext configChangeListenContext, ConnectionManager connectionManager) {
        this.longPollingService = longPollingService;
        this.configChangeListenContext = configChangeListenContext;
        this.connectionManager = connectionManager;
    }

    @Override
    public ConfigListenerInfo getListenerState(String dataId, String groupName, String namespaceId) {
        SampleResult result = this.longPollingService.getCollectSubscribleInfo(dataId, groupName, namespaceId);
        String groupKey = GroupKey2.getKey(dataId, groupName, namespaceId);
        Set<String> listenersClients = this.configChangeListenContext.getListeners(groupKey);
        if (CollectionUtils.isEmpty(listenersClients)) {
            return this.buildActualResult(result, "config");
        }
        HashMap<String, String> listenersGroupkeyStatus = new HashMap<String, String>(listenersClients.size(), 1.0f);
        for (String connectionId : listenersClients) {
            String md5;
            Connection client = this.connectionManager.getConnection(connectionId);
            if (client == null || (md5 = this.configChangeListenContext.getListenKeyMd5(connectionId, groupKey)) == null) continue;
            listenersGroupkeyStatus.put(client.getMetaInfo().getClientIp(), md5);
        }
        result.getLisentersGroupkeyStatus().putAll(listenersGroupkeyStatus);
        return this.buildActualResult(result, "config");
    }

    @Override
    public ConfigListenerInfo getListenerStateByIp(String ip) {
        SampleResult result = this.longPollingService.getCollectSubscribleInfoByIp(ip);
        List connectionsByIp = this.connectionManager.getConnectionByIp(ip);
        for (Connection connectionByIp : connectionsByIp) {
            Map<String, String> listenKeys = this.configChangeListenContext.getListenKeys(connectionByIp.getMetaInfo().getConnectionId());
            if (listenKeys == null) continue;
            result.getLisentersGroupkeyStatus().putAll(listenKeys);
        }
        return this.buildActualResult(result, "ip");
    }

    private ConfigListenerInfo buildActualResult(SampleResult sampleResult, String type) {
        ConfigListenerInfo result = new ConfigListenerInfo();
        result.setQueryType(type);
        result.setListenersStatus(sampleResult.getLisentersGroupkeyStatus());
        return result;
    }
}

