/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.processor;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllGrayTask;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;

public class DumpAllGrayProcessor
implements NacosTaskProcessor {
    static final int PAGE_SIZE = PropertyUtil.getAllDumpPageSize();
    final ConfigInfoGrayPersistService configInfoGrayPersistService;

    public DumpAllGrayProcessor(ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    public boolean process(NacosTask task) {
        if (!(task instanceof DumpAllGrayTask)) {
            LogUtil.DEFAULT_LOG.error("[all-dump-gray-error] ,invalid task type {},DumpAllGrayProcessor should process DumpAllGrayTask type.", (Object)task.getClass().getSimpleName());
            return false;
        }
        int rowCount = this.configInfoGrayPersistService.configInfoGrayCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)PAGE_SIZE);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<ConfigInfoGrayWrapper> page = this.configInfoGrayPersistService.findAllConfigInfoGrayForDumpAll(pageNo, PAGE_SIZE);
            if (page == null) continue;
            for (ConfigInfoGrayWrapper cf : page.getPageItems()) {
                if (StringUtils.isBlank((CharSequence)cf.getTenant())) continue;
                boolean result = ConfigCacheService.dumpGray(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getGrayName(), cf.getGrayRule(), cf.getContent(), cf.getLastModified(), cf.getEncryptedDataKey());
                LogUtil.DUMP_LOG.info("[dump-all-gray-ok] result={}, {}, {}, length={}, md5={}, grayName={}", new Object[]{result, GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), cf.getContent().length(), cf.getMd5(), cf.getGrayName()});
            }
            LogUtil.DEFAULT_LOG.info("[all-dump-gray] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }
}

