/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigFuzzyWatchResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.config.server.model.event.ConfigFuzzyWatchEvent;
import com.alibaba.nacos.config.server.service.ConfigFuzzyWatchContextService;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigFuzzyWatchRequestParamsExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.StringPool;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ConfigFuzzyWatchRequestHandler
extends RequestHandler<ConfigFuzzyWatchRequest, ConfigFuzzyWatchResponse> {
    private ConfigFuzzyWatchContextService configFuzzyWatchContextService;

    public ConfigFuzzyWatchRequestHandler(ConfigFuzzyWatchContextService configFuzzyWatchContextService) {
        this.configFuzzyWatchContextService = configFuzzyWatchContextService;
    }

    @NamespaceValidation
    @TpsControl(pointName="ConfigFuzzyWatch")
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigFuzzyWatchRequestParamsExtractor.class)
    public ConfigFuzzyWatchResponse handle(ConfigFuzzyWatchRequest request, RequestMeta meta) throws NacosException {
        String connectionId = StringPool.get((String)meta.getConnectionId());
        String groupKeyPattern = request.getGroupKeyPattern();
        if ("WATCH".equals(request.getWatchType())) {
            try {
                this.configFuzzyWatchContextService.addFuzzyWatch(groupKeyPattern, connectionId);
                Set clientExistingGroupKeys = request.getReceivedGroupKeys();
                NotifyCenter.publishEvent((Event)new ConfigFuzzyWatchEvent(connectionId, clientExistingGroupKeys, groupKeyPattern, request.isInitializing()));
            }
            catch (NacosException nacosException) {
                ConfigFuzzyWatchResponse configFuzzyWatchResponse = new ConfigFuzzyWatchResponse();
                configFuzzyWatchResponse.setErrorInfo(nacosException.getErrCode(), nacosException.getErrMsg());
                return configFuzzyWatchResponse;
            }
            boolean reachToUpLimit = this.configFuzzyWatchContextService.reachToUpLimit(groupKeyPattern);
            if (reachToUpLimit) {
                ConfigFuzzyWatchResponse configFuzzyWatchResponse = new ConfigFuzzyWatchResponse();
                configFuzzyWatchResponse.setErrorInfo(ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getCode().intValue(), ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getMsg());
                return configFuzzyWatchResponse;
            }
        } else if ("CANCEL_WATCH".equals(request.getWatchType())) {
            this.configFuzzyWatchContextService.removeFuzzyListen(groupKeyPattern, connectionId);
        }
        return new ConfigFuzzyWatchResponse();
    }
}

