/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchChangeNotifyRequest;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.config.server.configuration.ConfigCommonConfig;
import com.alibaba.nacos.config.server.model.event.LocalDataChangeEvent;
import com.alibaba.nacos.config.server.remote.FuzzyWatchChangeNotifyTask;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.ConfigFuzzyWatchContextService;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RpcPushService;
import com.alibaba.nacos.core.utils.Loggers;
import org.springframework.stereotype.Component;

@Component
public class ConfigFuzzyWatchChangeNotifier
extends Subscriber<LocalDataChangeEvent> {
    private final ConnectionManager connectionManager;
    private RpcPushService rpcPushService;
    private final ConfigFuzzyWatchContextService configFuzzyWatchContextService;

    public ConfigFuzzyWatchChangeNotifier(ConnectionManager connectionManager, RpcPushService rpcPushService, ConfigFuzzyWatchContextService configFuzzyWatchContextService) {
        this.rpcPushService = rpcPushService;
        this.connectionManager = connectionManager;
        this.configFuzzyWatchContextService = configFuzzyWatchContextService;
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void onEvent(LocalDataChangeEvent event) {
        boolean exists = ConfigCacheService.getContentCache(event.groupKey) != null;
        String changedType = exists ? "CONFIG_CHANGED" : "DELETE_CONFIG";
        boolean needNotify = this.configFuzzyWatchContextService.syncGroupKeyContext(event.groupKey, changedType);
        if (needNotify) {
            for (String clientId : this.configFuzzyWatchContextService.getMatchedClients(event.groupKey)) {
                Connection connection = this.connectionManager.getConnection(clientId);
                if (null == connection) {
                    Loggers.REMOTE_PUSH.warn("clientId not found, Config change notification not sent. clientId={},keyGroupPattern={}", (Object)clientId, (Object)event.groupKey);
                    continue;
                }
                ConfigFuzzyWatchChangeNotifyRequest request = new ConfigFuzzyWatchChangeNotifyRequest(event.groupKey, changedType);
                int maxPushRetryTimes = ConfigCommonConfig.getInstance().getMaxPushRetryTimes();
                FuzzyWatchChangeNotifyTask fuzzyWatchChangeNotifyTask = new FuzzyWatchChangeNotifyTask(this.connectionManager, this.rpcPushService, request, maxPushRetryTimes, clientId);
                fuzzyWatchChangeNotifyTask.scheduleSelf();
            }
        }
    }

    public Class<? extends Event> subscribeType() {
        return LocalDataChangeEvent.class;
    }
}

