/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.remote.request.ClientConfigMetricRequest;
import com.alibaba.nacos.api.config.remote.response.ClientConfigMetricResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.auth.util.AuthHeaderUtil;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.auth.NacosServerAuthConfig;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/cs/metrics"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class MetricsControllerV3 {
    private final ServerMemberManager serverMemberManager;
    private final ConnectionManager connectionManager;

    public MetricsControllerV3(ServerMemberManager serverMemberManager, ConnectionManager connectionManager) {
        this.serverMemberManager = serverMemberManager;
        this.connectionManager = connectionManager;
    }

    @GetMapping(value={"/cluster"})
    @Secured(resource="/v3/admin/cs/metrics", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Map<String, Object>> metric(@RequestParam(value="ip") String ip, @RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="groupName", required=false) String groupName, @RequestParam(value="namespaceId", required=false) String namespaceId) throws NacosException {
        ParamUtils.checkTenant(namespaceId);
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        ParamUtils.checkParam(dataId, groupName, "default", "default");
        Loggers.CORE.info("Get cluster config metrics received, ip={},dataId={},groupName={},namespaceId={}", new Object[]{ip, dataId, groupName, namespaceId});
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        Collection members = this.serverMemberManager.allMembers();
        NacosAsyncRestTemplate nacosAsyncRestTemplate = HttpClientBeanHolder.getNacosAsyncRestTemplate((Logger)Loggers.CLUSTER);
        CountDownLatch latch = new CountDownLatch(members.size());
        for (Member member : members) {
            String url = HttpUtils.buildUrl((boolean)false, (String)member.getAddress(), (String[])new String[]{EnvUtil.getContextPath(), "/v3/admin/cs/metrics", "ip"});
            Query query = Query.newInstance().addParam("ip", (Object)ip).addParam("dataId", (Object)dataId).addParam("groupName", (Object)groupName).addParam("namespaceId", (Object)namespaceId);
            Header header = Header.newInstance();
            AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
            nacosAsyncRestTemplate.get(url, header, query, new GenericType<Map>(){}.getType(), (Callback)new ClusterMetricsCallBack(responseMap, latch, dataId, groupName, namespaceId, ip, member));
        }
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Result.success(responseMap);
    }

    @GetMapping(value={"/ip"})
    @Secured(resource="/v3/admin/cs/metrics", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Map<String, Object>> getClientMetrics(@RequestParam(value="ip") String ip, @RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="groupName", required=false) String groupName, @RequestParam(value="namespaceId", required=false) String namespaceId) throws NacosException {
        ParamUtils.checkTenant(namespaceId);
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        ParamUtils.checkParam(dataId, groupName, "default", "default");
        HashMap metrics = new HashMap(16);
        List connectionsByIp = this.connectionManager.getConnectionByIp(ip);
        for (Connection connectionByIp : connectionsByIp) {
            try {
                ClientConfigMetricRequest clientMetrics = new ClientConfigMetricRequest();
                if (StringUtils.isNotBlank((String)dataId)) {
                    clientMetrics.getMetricsKeys().add(ClientConfigMetricRequest.MetricsKey.build((String)"cacheData", (String)GroupKey2.getKey(dataId, groupName, namespaceId)));
                    clientMetrics.getMetricsKeys().add(ClientConfigMetricRequest.MetricsKey.build((String)"snapshotData", (String)GroupKey2.getKey(dataId, groupName, namespaceId)));
                }
                ClientConfigMetricResponse request1 = (ClientConfigMetricResponse)connectionByIp.request((Request)clientMetrics, 1000L);
                metrics.putAll(request1.getMetrics());
            }
            catch (Exception e) {
                Loggers.CORE.error("Get config metrics error from client ip={},dataId={},groupName={},namespaceId={},error={}", new Object[]{ip, dataId, groupName, namespaceId, e});
                throw new NacosException(500, (Throwable)e);
            }
        }
        return Result.success(metrics);
    }

    static class ClusterMetricsCallBack
    implements Callback<Map> {
        Map<String, Object> responseMap;
        CountDownLatch latch;
        String dataId;
        String group;
        String namespaceId;
        String ip;
        Member member;

        public ClusterMetricsCallBack(Map<String, Object> responseMap, CountDownLatch latch, String dataId, String group, String namespaceId, String ip, Member member) {
            this.responseMap = responseMap;
            this.latch = latch;
            this.dataId = dataId;
            this.group = group;
            this.namespaceId = namespaceId;
            this.member = member;
            this.ip = ip;
        }

        public void onReceive(RestResult<Map> result) {
            if (result.ok()) {
                this.responseMap.putAll((Map)result.getData());
            }
            this.latch.countDown();
        }

        public void onError(Throwable throwable) {
            Loggers.CORE.error("Get config metrics error from member address={}, ip={},dataId={},group={},namespaceId={},error={}", new Object[]{this.member.getAddress(), this.ip, this.dataId, this.group, this.namespaceId, throwable});
            this.latch.countDown();
        }

        public void onCancel() {
            this.latch.countDown();
        }
    }
}

