/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.enums.ApiVersionEnum;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.model.ConfigListenState;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.query.ConfigChainRequestExtractorService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.enums.ResponseCode;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.Protocol;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigServletInner {
    private static final int TRY_GET_LOCK_TIMES = 9;
    private static final int START_LONG_POLLING_VERSION_NUM = 204;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServletInner.class);
    private final LongPollingService longPollingService;
    private final ConfigQueryChainService configQueryChainService;

    public ConfigServletInner(LongPollingService longPollingService, ConfigQueryChainService configQueryChainService) {
        this.longPollingService = longPollingService;
        this.configQueryChainService = configQueryChainService;
    }

    private static String getDecryptContent(ConfigQueryChainResponse chainResponse, String dataId) {
        Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)chainResponse.getEncryptedDataKey(), (String)chainResponse.getContent());
        return (String)pair.getSecond();
    }

    public String doPollingConfig(HttpServletRequest request, HttpServletResponse response, Map<String, ConfigListenState> clientMd5Map, int probeRequestSize) throws IOException {
        int versionNum;
        if (LongPollingService.isSupportLongPolling(request)) {
            this.longPollingService.addLongPollingClient(request, response, clientMd5Map, probeRequestSize);
            return "200";
        }
        Map<String, ConfigListenState> changedGroups = MD5Util.compareMd5(request, response, clientMd5Map);
        String oldResult = MD5Util.compareMd5OldResult(changedGroups);
        String newResult = MD5Util.compareMd5ResultString(changedGroups);
        String version = request.getHeader("Client-Version");
        if (version == null) {
            version = "2.0.0";
        }
        if ((versionNum = Protocol.getVersionNumber(version)) < 204) {
            response.addHeader("Probe-Modify-Response", oldResult);
            response.addHeader("Probe-Modify-Response-New", newResult);
        } else {
            request.setAttribute("content", (Object)newResult);
        }
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache,no-store");
        response.setStatus(200);
        return "200";
    }

    public String doGetConfig(HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String tag, String isNotify, String clientIp, ApiVersionEnum apiVersion) throws IOException {
        boolean notify = StringUtils.isNotBlank((String)isNotify) && Boolean.parseBoolean(isNotify);
        String requestIpApp = RequestUtil.getAppName(request);
        ConfigQueryChainRequest chainRequest = ConfigChainRequestExtractorService.getExtractor().extract(request);
        chainRequest.setTenant(NamespaceUtil.processNamespaceParameter((String)chainRequest.getTenant()));
        ConfigQueryChainResponse chainResponse = this.configQueryChainService.handle(chainRequest);
        if (ResponseCode.FAIL.getCode() == chainResponse.getResultCode()) {
            throw new NacosConfigException(chainResponse.getMessage());
        }
        this.logPullEvent(dataId, group, tenant, requestIpApp, chainResponse, clientIp, notify, tag);
        switch (chainResponse.getStatus()) {
            case CONFIG_NOT_FOUND: 
            case SPECIAL_TAG_CONFIG_NOT_FOUND: {
                return this.handlerConfigNotFound(response, apiVersion);
            }
            case CONFIG_QUERY_CONFLICT: {
                return this.handlerConfigConflict(response, apiVersion);
            }
        }
        return this.handleResponse(response, chainResponse, dataId, group, apiVersion);
    }

    private String handlerConfigNotFound(HttpServletResponse response, ApiVersionEnum apiVersion) throws IOException {
        response.setStatus(404);
        if (apiVersion == ApiVersionEnum.V1) {
            return this.writeResponseForV1(response, (Result<String>)Result.failure((ErrorCode)ErrorCode.RESOURCE_NOT_FOUND, (Object)"config data not exist"));
        }
        return this.writeResponseForV2(response, (Result<String>)Result.failure((ErrorCode)ErrorCode.RESOURCE_NOT_FOUND, (Object)"config data not exist"));
    }

    private String handlerConfigConflict(HttpServletResponse response, ApiVersionEnum apiVersion) throws IOException {
        response.setStatus(409);
        if (apiVersion == ApiVersionEnum.V1) {
            return this.writeResponseForV1(response, (Result<String>)Result.failure((ErrorCode)ErrorCode.RESOURCE_CONFLICT, (Object)"requested file is being modified, please try later."));
        }
        return this.writeResponseForV2(response, (Result<String>)Result.failure((ErrorCode)ErrorCode.RESOURCE_CONFLICT, (Object)"requested file is being modified, please try later."));
    }

    private String handleResponse(HttpServletResponse response, ConfigQueryChainResponse chainResponse, String dataId, String group, ApiVersionEnum apiVersion) throws IOException {
        if (apiVersion == ApiVersionEnum.V1) {
            return this.handleResponseForV1(response, chainResponse, dataId, group);
        }
        return this.handleResponseForV2(response, chainResponse, dataId, group);
    }

    private String handleResponseForV1(HttpServletResponse response, ConfigQueryChainResponse chainResponse, String dataId, String tag) throws IOException {
        if (chainResponse.getContent() == null) {
            return this.handlerConfigNotFound(response, ApiVersionEnum.V1);
        }
        this.setCommonResponseHead(response, chainResponse, tag);
        this.setResponseHeadForV1(response, chainResponse);
        this.writeContentForV1(response, chainResponse, dataId);
        return "200";
    }

    private String handleResponseForV2(HttpServletResponse response, ConfigQueryChainResponse chainResponse, String dataId, String tag) throws IOException {
        if (chainResponse.getContent() == null) {
            return this.handlerConfigNotFound(response, ApiVersionEnum.V2);
        }
        this.setCommonResponseHead(response, chainResponse, tag);
        this.setResponseHeadForV2(response);
        this.writeContentForV2(response, chainResponse, dataId);
        return "200";
    }

    private void setResponseHeadForV1(HttpServletResponse response, ConfigQueryChainResponse chainResponse) {
        String contentType = chainResponse.getContentType();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = FileTypeEnum.TEXT.getContentType();
        }
        response.setHeader("Content-Type", contentType);
    }

    private void setResponseHeadForV2(HttpServletResponse response) {
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentForV1(HttpServletResponse response, ConfigQueryChainResponse chainResponse, String dataId) throws IOException {
        PrintWriter out = response.getWriter();
        try {
            String decryptContent = ConfigServletInner.getDecryptContent(chainResponse, dataId);
            out.print(decryptContent);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentForV2(HttpServletResponse response, ConfigQueryChainResponse chainResponse, String dataId) throws IOException {
        PrintWriter out = response.getWriter();
        try {
            String decryptContent = ConfigServletInner.getDecryptContent(chainResponse, dataId);
            out.print(JacksonUtils.toJson((Object)Result.success((Object)decryptContent)));
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private String writeResponseForV1(HttpServletResponse response, Result<String> result) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println((String)result.getData());
        return "" + response.getStatus();
    }

    private String writeResponseForV2(HttpServletResponse response, Result<String> result) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(JacksonUtils.toJson(result));
        return "" + response.getStatus();
    }

    private String resolvePullEvent(ConfigQueryChainResponse chainResponse, String tag) {
        switch (chainResponse.getStatus()) {
            case CONFIG_FOUND_GRAY: {
                ConfigCacheGray matchedGray = chainResponse.getMatchedGray();
                if (matchedGray != null) {
                    return "pull-" + matchedGray.getGrayName();
                }
                return "pull";
            }
            case SPECIAL_TAG_CONFIG_NOT_FOUND: {
                return "pull-tag-" + tag;
            }
        }
        return "pull";
    }

    private void logPullEvent(String dataId, String group, String tenant, String requestIpApp, ConfigQueryChainResponse chainResponse, String clientIp, boolean notify, String tag) {
        String pullEvent = this.resolvePullEvent(chainResponse, tag);
        ConfigQueryChainResponse.ConfigQueryStatus status = chainResponse.getStatus();
        if (status == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_QUERY_CONFLICT) {
            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, pullEvent, "conflict", -1L, clientIp, notify, "http");
        } else if (status == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND || chainResponse.getContent() == null) {
            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, pullEvent, "not-found", -1L, clientIp, notify, "http");
        } else {
            long delayed = System.currentTimeMillis() - chainResponse.getLastModified();
            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, chainResponse.getLastModified(), pullEvent, "ok", delayed, clientIp, notify, "http");
        }
    }

    private void setCommonResponseHead(HttpServletResponse response, ConfigQueryChainResponse chainResponse, String tag) {
        String configType = chainResponse.getConfigType() != null ? chainResponse.getConfigType() : FileTypeEnum.TEXT.getFileType();
        response.setHeader("Config-Type", configType);
        response.setHeader("Content-MD5", chainResponse.getMd5());
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache,no-store");
        response.setDateHeader("Last-Modified", chainResponse.getLastModified());
        if (chainResponse.getEncryptedDataKey() != null) {
            response.setHeader("Encrypted-Data-Key", chainResponse.getEncryptedDataKey());
        }
        if (ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_GRAY == chainResponse.getStatus()) {
            if ("beta".equals(chainResponse.getMatchedGray().getGrayRule().getType())) {
                response.setHeader("isBeta", "true");
            } else if ("tag".equals(chainResponse.getMatchedGray().getGrayRule().getType())) {
                try {
                    response.setHeader("tag", URLEncoder.encode(chainResponse.getMatchedGray().getGrayRule().getRawGrayRuleExp(), StandardCharsets.UTF_8.displayName()));
                }
                catch (Exception e) {
                    LOGGER.error("Error encoding tag", (Throwable)e);
                }
            }
        }
        if (ConfigQueryChainResponse.ConfigQueryStatus.SPECIAL_TAG_CONFIG_NOT_FOUND == chainResponse.getStatus()) {
            try {
                response.setHeader("Vipserver-Tag", URLEncoder.encode(tag, StandardCharsets.UTF_8.displayName()));
            }
            catch (Exception e) {
                LOGGER.error("Error encoding tag", (Throwable)e);
            }
        }
    }
}

