/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.api.config.remote.request.ConfigBatchListenRequest;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequestLogAspect {
    private static final String PUBLISH_CONFIG = "execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.publishConfig(..))";
    private static final String GET_CONFIG = "execution(* com.alibaba.nacos.config.server.service.query.ConfigQueryChainService.handle(..))";
    private static final String DELETE_CONFIG = "execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.deleteConfig(..))";
    private static final String CONFIG_CHANGE_LISTEN_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigChangeBatchListenRequestHandler) && args(request,meta)";

    @Around(value="execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.publishConfig(..))")
    public Object interfacePublishConfig(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        ConfigForm configForm = (ConfigForm)args[0];
        ConfigRequestInfo configRequestInfo = (ConfigRequestInfo)args[1];
        String dataId = configForm.getDataId();
        String group = configForm.getGroup();
        String namespaceId = configForm.getNamespaceId();
        String content = configForm.getContent();
        String requestIp = configRequestInfo.getSrcIp();
        String md5 = content == null ? null : MD5Utils.md5Hex((String)content, (String)"UTF-8");
        MetricsMonitor.getPublishMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequest("publish", pjp, dataId, group, namespaceId, requestIp, md5, rtHolder);
        MetricsMonitor.getWriteConfigRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.service.query.ConfigQueryChainService.handle(..))")
    public Object interfaceGetConfig(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        ConfigQueryChainRequest chainRequest = (ConfigQueryChainRequest)args[0];
        String dataId = chainRequest.getDataId();
        String group = chainRequest.getGroup();
        String tenant = chainRequest.getTenant();
        String requestIp = null;
        if (chainRequest.getAppLabels() != null) {
            requestIp = chainRequest.getAppLabels().getOrDefault("ClientIp", null);
        }
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String md5 = ConfigCacheService.getContentMd5(groupKey);
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequest("get", pjp, dataId, group, tenant, requestIp, md5, rtHolder);
        MetricsMonitor.getReadConfigRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.deleteConfig(..))")
    public Object interfaceRemoveConfig(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        String dataId = (String)args[0];
        String group = (String)args[1];
        String tenant = (String)args[2];
        String clientIp = (String)args[4];
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String md5 = ConfigCacheService.getContentMd5(groupKey);
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequest("delete", pjp, dataId, group, tenant, clientIp, md5, rtHolder);
        MetricsMonitor.getReadConfigRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    private Object logClientRequest(String requestType, ProceedingJoinPoint pjp, String dataId, String group, String tenant, String requestIp, String md5, AtomicLong rtHolder) throws Throwable {
        long startTime = System.currentTimeMillis();
        try {
            Object retVal = pjp.proceed();
            long rt = System.currentTimeMillis() - startTime;
            if (rtHolder != null) {
                rtHolder.set(rt);
            }
            LogUtil.CLIENT_LOG.info("opType: {} | rt: {}ms | status: success | requestIp: {} | dataId: {} | group: {} | tenant: {} | md5: {}", new Object[]{requestType, rt, requestIp, dataId, group, tenant, md5});
            return retVal;
        }
        catch (Throwable e) {
            long rt = System.currentTimeMillis() - startTime;
            if (rtHolder != null) {
                rtHolder.set(rt);
            }
            LogUtil.CLIENT_LOG.error("opType: {} | rt: {}ms | status: failure | requestIp: {} | dataId: {} | group: {} | tenant: {} | md5: {}", new Object[]{requestType, rt, requestIp, dataId, group, tenant, md5});
            throw e;
        }
    }

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigChangeBatchListenRequestHandler) && args(request,meta)", argNames="request,meta")
    public Object interfaceListenConfigRpc(ProceedingJoinPoint pjp, ConfigBatchListenRequest request, RequestMeta meta) throws Throwable {
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        String requestIp = meta.getClientIp();
        String appName = request.getHeader("Client-AppName");
        long st = System.currentTimeMillis();
        Response retVal = (Response)pjp.proceed();
        long rt = System.currentTimeMillis() - st;
        LogUtil.CLIENT_LOG.info("opType: {} | rt: {}ms | status: {} | requestIp: {} | listenSize: {} | listenOrCancel: {} | appName: {}", new Object[]{"listen", rt, retVal.isSuccess() ? retVal.getResultCode() : retVal.getErrorCode(), requestIp, request.getConfigListenContexts().size(), request.isListen(), appName});
        return retVal;
    }
}

