/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.disk;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.common.pathencoder.PathEncoderManager;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class ConfigRawDiskService
implements ConfigDiskService {
    private static final String BASE_DIR = File.separator + "data" + File.separator + "config-data";
    private static final String TENANT_BASE_DIR = File.separator + "data" + File.separator + "tenant-config-data";
    private static final String GRAY_DIR = File.separator + "data" + File.separator + "gray-data";
    private static final String TENANT_GRAY_DIR = File.separator + "data" + File.separator + "tenant-gray-data";

    @Override
    public void saveToDisk(String dataId, String group, String tenant, String content) throws IOException {
        File targetFile = ConfigRawDiskService.targetFile(dataId, group, tenant);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    static File targetFile(String dataId, String group, String tenant) {
        try {
            ParamUtils.checkParam(dataId, group, tenant);
        }
        catch (Exception e) {
            throw new NacosRuntimeException(-400, "parameter is invalid.");
        }
        dataId = PathEncoderManager.getInstance().encode(dataId);
        group = PathEncoderManager.getInstance().encode(group);
        tenant = PathEncoderManager.getInstance().encode(tenant);
        File file = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), BASE_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_BASE_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        return file;
    }

    private static File targetGrayFile(String dataId, String group, String tenant, String grayName) {
        try {
            ParamUtils.checkParam(grayName);
            ParamUtils.checkParam(dataId, group, tenant);
        }
        catch (Exception e) {
            throw new NacosRuntimeException(-400, "parameter is invalid.");
        }
        dataId = PathEncoderManager.getInstance().encode(dataId);
        group = PathEncoderManager.getInstance().encode(group);
        tenant = PathEncoderManager.getInstance().encode(tenant);
        File file = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), GRAY_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_GRAY_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        file = new File(file, grayName);
        return file;
    }

    private static File targetGrayContentFile(String dataId, String group, String tenant, String grayName) {
        return ConfigRawDiskService.targetGrayFile(dataId, group, tenant, grayName);
    }

    @Override
    public void saveGrayToDisk(String dataId, String group, String tenant, String grayName, String content) throws IOException {
        File targetGrayContentFile = ConfigRawDiskService.targetGrayContentFile(dataId, group, tenant, grayName);
        FileUtils.writeStringToFile((File)targetGrayContentFile, (String)content, (String)"UTF-8");
    }

    @Override
    public void removeConfigInfo(String dataId, String group, String tenant) {
        FileUtils.deleteQuietly((File)ConfigRawDiskService.targetFile(dataId, group, tenant));
    }

    @Override
    public void removeConfigInfo4Gray(String dataId, String group, String tenant, String grayName) {
        FileUtils.deleteQuietly((File)ConfigRawDiskService.targetGrayContentFile(dataId, group, tenant, grayName));
    }

    private static String file2String(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    @Override
    public String getGrayContent(String dataId, String group, String tenant, String grayName) throws IOException {
        return ConfigRawDiskService.file2String(ConfigRawDiskService.targetGrayContentFile(dataId, group, tenant, grayName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContent(String dataId, String group, String tenant) throws IOException {
        File file = ConfigRawDiskService.targetFile(dataId, group, tenant);
        if (file.exists()) {
            String string;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                string = IoUtils.toString((InputStream)fis, (String)"UTF-8");
            }
            catch (FileNotFoundException e) {
                String string2;
                try {
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fis);
                    throw throwable;
                }
                IoUtils.closeQuietly((Closeable)fis);
                return string2;
            }
            IoUtils.closeQuietly((Closeable)fis);
            return string;
        }
        return null;
    }

    @Override
    public void clearAll() {
        File file = new File(EnvUtil.getNacosHome(), BASE_DIR);
        if (!file.exists() || FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_BASE_DIR);
        if (!fileTenant.exists() || FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tenant failed.");
        }
    }

    @Override
    public void clearAllGray() {
        File file = new File(EnvUtil.getNacosHome(), GRAY_DIR);
        if (!file.exists() || FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-gray success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-gray failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_GRAY_DIR);
        if (!fileTenant.exists() || FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-gray-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-gray-tenant failed.");
        }
    }
}

