/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.springframework.stereotype.Component;

@Component
public class ConfigRemoveRequestHandler
extends RequestHandler<ConfigRemoveRequest, ConfigRemoveResponse> {
    private final ConfigInfoPersistService configInfoPersistService;
    private final ConfigInfoGrayPersistService configInfoGrayPersistService;
    private final ConfigOperationService configOperationService;

    public ConfigRemoveRequestHandler(ConfigInfoPersistService configInfoPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService, ConfigOperationService configOperationService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.configOperationService = configOperationService;
    }

    @TpsControl(pointName="ConfigRemove")
    @Secured(action=ActionTypes.WRITE, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigRemoveResponse handle(ConfigRemoveRequest configRemoveRequest, RequestMeta meta) throws NacosException {
        String tenant = configRemoveRequest.getTenant();
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        String dataId = configRemoveRequest.getDataId();
        String group = configRemoveRequest.getGroup();
        String tag = configRemoveRequest.getTag();
        try {
            ParamUtils.checkTenant(tenant);
            ParamUtils.checkParam(dataId, group, "datumId", "rm");
            ParamUtils.checkParam(tag);
            String clientIp = meta.getClientIp();
            this.configOperationService.deleteConfig(dataId, group, tenant, tag, clientIp, null, "rpc");
            return ConfigRemoveResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("remove config error,error msg is {}", (Object)e.getMessage(), (Object)e);
            return ConfigRemoveResponse.buildFailResponse((String)e.getMessage());
        }
    }
}

