/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.cluster.ConfigChangeClusterSyncRequest;
import com.alibaba.nacos.api.config.remote.response.cluster.ConfigChangeClusterSyncResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.config.server.configuration.ConfigCompatibleConfig;
import com.alibaba.nacos.config.server.service.ConfigMigrateService;
import com.alibaba.nacos.config.server.service.dump.DumpRequest;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.grpc.InvokeSource;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import org.springframework.stereotype.Component;

@Component
@InvokeSource(source={"cluster"})
public class ConfigChangeClusterSyncRequestHandler
extends RequestHandler<ConfigChangeClusterSyncRequest, ConfigChangeClusterSyncResponse> {
    private final DumpService dumpService;
    private ConfigMigrateService configMigrateService;

    public ConfigChangeClusterSyncRequestHandler(DumpService dumpService, ConfigMigrateService configMigrateService) {
        this.dumpService = dumpService;
        this.configMigrateService = configMigrateService;
    }

    @TpsControl(pointName="ClusterConfigChangeNotify")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    @Secured(signType="config", apiType=ApiType.INNER_API)
    public ConfigChangeClusterSyncResponse handle(ConfigChangeClusterSyncRequest configChangeSyncRequest, RequestMeta meta) throws NacosException {
        this.checkCompatity(configChangeSyncRequest, meta);
        ParamUtils.checkParam(configChangeSyncRequest.getTag());
        DumpRequest dumpRequest = DumpRequest.create(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant(), configChangeSyncRequest.getLastModified(), meta.getClientIp());
        dumpRequest.setGrayName(configChangeSyncRequest.getGrayName());
        this.dumpService.dump(dumpRequest);
        return new ConfigChangeClusterSyncResponse();
    }

    private void checkCompatity(ConfigChangeClusterSyncRequest configChangeSyncRequest, RequestMeta meta) {
        if (PropertyUtil.isGrayCompatibleModel() && StringUtils.isBlank((CharSequence)configChangeSyncRequest.getGrayName()) && (configChangeSyncRequest.isBeta() || StringUtils.isNotBlank((String)configChangeSyncRequest.getTag()))) {
            Object grayName = null;
            if (configChangeSyncRequest.isBeta()) {
                this.configMigrateService.checkMigrateBeta(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant());
                grayName = "beta";
            } else {
                this.configMigrateService.checkMigrateTag(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant(), configChangeSyncRequest.getTag());
                grayName = "tag_" + configChangeSyncRequest.getTag();
            }
            configChangeSyncRequest.setGrayName((String)grayName);
        }
        if (!this.checkNamespaceCompatible(configChangeSyncRequest, meta)) {
            return;
        }
        if (StringUtils.isNotBlank((String)configChangeSyncRequest.getGrayName())) {
            this.configMigrateService.namespaceMigrateGray(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant(), configChangeSyncRequest.getGrayName());
        } else {
            this.configMigrateService.namespaceMigrate(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant());
        }
        configChangeSyncRequest.setTenant("public");
    }

    public boolean checkNamespaceCompatible(ConfigChangeClusterSyncRequest configSyncRequest, RequestMeta meta) {
        if (!ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return false;
        }
        String ignoreCheckVersion = "3.0.0";
        String clusterVersionPrefixNew = "Nacos-Server:v";
        String clusterVersionPrefixOld = "Nacos-Java-Client:v";
        try {
            String version = null;
            version = meta.getClientVersion().split("Nacos-Server:v").length > 1 ? meta.getClientVersion().split("Nacos-Server:v")[1] : meta.getClientVersion().split("Nacos-Java-Client:v")[1];
            if (VersionUtils.compareVersion((String)version, (String)"3.0.0") >= 0) {
                return false;
            }
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("checkCompatity error", (Throwable)e);
        }
        return StringUtils.equals((String)configSyncRequest.getTenant(), (String)"public") || StringUtils.isBlank((CharSequence)configSyncRequest.getTenant());
    }
}

