/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigListenState;
import com.alibaba.nacos.config.server.utils.Md5Comparator;
import com.alibaba.nacos.config.server.utils.NacosMd5Comparator;
import com.alibaba.nacos.sys.env.EnvUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5ComparatorDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(Md5ComparatorDelegate.class);
    private static final Md5ComparatorDelegate INSTANCE = new Md5ComparatorDelegate();
    private String md5ComparatorType = EnvUtil.getProperty((String)"nacos.config.cache.type", (String)"nacos");
    private Md5Comparator md5Comparator;

    private Md5ComparatorDelegate() {
        Collection md5Comparators = NacosServiceLoader.load(Md5Comparator.class);
        for (Md5Comparator each : md5Comparators) {
            if (StringUtils.isEmpty((String)each.getName())) {
                LOGGER.warn("[Md5ComparatorDelegate] Load Md5Comparator({}) Md5ComparatorName(null/empty) fail. Please add Md5ComparatorName to resolve", (Object)each.getClass().getName());
                continue;
            }
            LOGGER.info("[Md5ComparatorDelegate] Load Md5Comparator({}) Md5ComparatorName({}) successfully.", (Object)each.getClass().getName(), (Object)each.getName());
            if (!StringUtils.equals((String)this.md5ComparatorType, (String)each.getName())) continue;
            LOGGER.info("[Md5ComparatorDelegate] Matched Md5Comparator found,set md5Comparator={}", (Object)each.getClass().getName());
            this.md5Comparator = each;
        }
        if (this.md5Comparator == null) {
            LOGGER.info("[Md5ComparatorDelegate] Matched Md5Comparator not found, load Default NacosMd5Comparator successfully");
            this.md5Comparator = new NacosMd5Comparator();
        }
    }

    public static Md5ComparatorDelegate getInstance() {
        return INSTANCE;
    }

    public Map<String, ConfigListenState> compareMd5(HttpServletRequest request, HttpServletResponse response, Map<String, ConfigListenState> clientMd5Map) {
        return this.md5Comparator.compareMd5(request, response, clientMd5Map);
    }
}

