/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.ConfigListenState;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.Md5ComparatorDelegate;
import com.alibaba.nacos.core.utils.StringPool;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MD5Util {
    static final char WORD_SEPARATOR_CHAR = '\u0002';
    static final char LINE_SEPARATOR_CHAR = '\u0001';

    public static Map<String, ConfigListenState> compareMd5(HttpServletRequest request, HttpServletResponse response, Map<String, ConfigListenState> clientMd5Map) {
        return Md5ComparatorDelegate.getInstance().compareMd5(request, response, clientMd5Map);
    }

    public static String compareMd5OldResult(Map<String, ConfigListenState> changedGroupKeys) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ConfigListenState> entry : changedGroupKeys.entrySet()) {
            String groupKey = entry.getKey();
            String[] dataIdGroupId = GroupKey2.parseKey(groupKey);
            sb.append(dataIdGroupId[0]);
            sb.append(':');
            sb.append(dataIdGroupId[1]);
            sb.append(';');
        }
        return sb.toString();
    }

    public static String compareMd5ResultString(Map<String, ConfigListenState> changedGroupKeys) throws IOException {
        if (null == changedGroupKeys) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ConfigListenState> entry : changedGroupKeys.entrySet()) {
            String groupKey = entry.getKey();
            String[] dataIdGroupId = GroupKey2.parseKey(groupKey);
            sb.append(dataIdGroupId[0]);
            sb.append(Constants.WORD_SEPARATOR);
            sb.append(dataIdGroupId[1]);
            if (dataIdGroupId.length == 3 && StringUtils.isNotBlank((String)dataIdGroupId[2]) && !entry.getValue().isNamespaceTransfer()) {
                sb.append(Constants.WORD_SEPARATOR);
                sb.append(dataIdGroupId[2]);
            }
            sb.append(Constants.LINE_SEPARATOR);
        }
        return URLEncoder.encode(sb.toString(), "UTF-8");
    }

    public static Map<String, ConfigListenState> getClientMd5Map(String configKeysString) {
        HashMap<String, ConfigListenState> md5Map = new HashMap<String, ConfigListenState>(5);
        if (null == configKeysString || "".equals(configKeysString)) {
            return md5Map;
        }
        int start = 0;
        ArrayList<String> tmpList = new ArrayList<String>(3);
        for (int i = start; i < configKeysString.length(); ++i) {
            boolean ifNamespaceTransfer;
            String md5;
            String tenant;
            char c = configKeysString.charAt(i);
            if (c == '\u0002') {
                tmpList.add(configKeysString.substring(start, i));
                start = i + 1;
                if (tmpList.size() <= 3) continue;
                throw new IllegalArgumentException("invalid protocol,too much key");
            }
            if (c != '\u0001') continue;
            String endValue = "";
            if (start + 1 <= i) {
                endValue = configKeysString.substring(start, i);
            }
            start = i + 1;
            if (tmpList.size() == 2) {
                tenant = "";
                md5 = endValue;
                ifNamespaceTransfer = NamespaceUtil.isNeedTransferNamespace((String)tenant);
                tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
            } else {
                tenant = endValue;
                md5 = (String)tmpList.get(2);
                ifNamespaceTransfer = false;
            }
            ConfigListenState configListenState = new ConfigListenState(md5);
            configListenState.setNamespaceTransfer(ifNamespaceTransfer);
            String groupKey = GroupKey2.getKey((String)tmpList.get(0), (String)tmpList.get(1), tenant);
            groupKey = StringPool.get((String)groupKey);
            md5Map.put(groupKey, configListenState);
            tmpList.clear();
            if (md5Map.size() <= 10000) continue;
            throw new IllegalArgumentException("invalid protocol, too much listener");
        }
        return md5Map;
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return null == encoding ? MD5Util.toString(new InputStreamReader(input, "UTF-8")) : MD5Util.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        MD5Util.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[1024];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

