/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigMigratePersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoGrayMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigMigrateMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigMigratePersistServiceImpl")
public class ExternalConfigMigratePersistServiceImpl
implements ConfigMigratePersistService {
    protected JdbcTemplate jt;
    protected TransactionTemplate tjt;
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    private MapperManager mapperManager;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoGrayPersistService configInfoGrayPersistService;

    public ExternalConfigMigratePersistServiceImpl(@Qualifier(value="externalConfigInfoPersistServiceImpl") ConfigInfoPersistService configInfoPersistService, @Qualifier(value="externalConfigInfoGrayPersistServiceImpl") ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.jt = this.dataSourceService.getJdbcTemplate();
        this.tjt = this.dataSourceService.getTransactionTemplate();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public Integer configInfoConflictCount(String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        MapperResult mapperResult = configMigrateMapper.getConfigConflictCount(context);
        Integer result = (Integer)this.jt.queryForObject(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoConflictCount error");
        }
        return result;
    }

    @Override
    public Integer configInfoGrayConflictCount(String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        MapperResult mapperResult = configMigrateMapper.getConfigGrayConflictCount(context);
        Integer result = (Integer)this.jt.queryForObject(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoGrayConflictCount error");
        }
        return result;
    }

    @Override
    public List<Long> getMigrateConfigInsertIdList(long startId, int pageSize) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)startId);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configMigrateMapper.findConfigIdNeedInsertMigrate(context);
        return this.jt.queryForList(mapperResult.getSql(), mapperResult.getParamList().toArray(), Long.class);
    }

    @Override
    public List<Long> getMigrateConfigGrayInsertIdList(long startId, int pageSize) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)startId);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configMigrateMapper.findConfigGrayIdNeedInsertMigrate(context);
        return this.jt.queryForList(mapperResult.getSql(), mapperResult.getParamList().toArray(), Long.class);
    }

    @Override
    public List<ConfigInfo> getMigrateConfigUpdateList(long startId, int pageSize, String srcTenant, String targetTenant, String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        context.putWhereParameter("id", (Object)startId);
        context.putWhereParameter("srcTenant", (Object)srcTenant);
        context.putWhereParameter("targetTenant", (Object)targetTenant);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configMigrateMapper.findConfigNeedUpdateMigrate(context);
        return this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoGrayWrapper> getMigrateConfigGrayUpdateList(long startId, int pageSize, String srcTenant, String targetTenant, String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("srcUser", (Object)srcUser);
        context.putWhereParameter("id", (Object)startId);
        context.putWhereParameter("srcTenant", (Object)srcTenant);
        context.putWhereParameter("targetTenant", (Object)targetTenant);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configMigrateMapper.findConfigGrayNeedUpdateMigrate(context);
        return this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
    }

    @Override
    public void migrateConfigInsertByIds(List<Long> ids, String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("ids", ids);
        context.putWhereParameter("srcUser", (Object)srcUser);
        MapperResult mapperResult = configMigrateMapper.migrateConfigInsertByIds(context);
        try {
            this.jt.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] migrateConfigInsertByIds" + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void migrateConfigGrayInsertByIds(List<Long> ids, String srcUser) {
        ConfigMigrateMapper configMigrateMapper = (ConfigMigrateMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "migrate_config");
        MapperContext context = new MapperContext();
        context.putWhereParameter("ids", ids);
        context.putWhereParameter("srcUser", (Object)srcUser);
        MapperResult mapperResult = configMigrateMapper.migrateConfigGrayInsertByIds(context);
        try {
            this.jt.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] migrateConfigGrayInsertByIds" + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void syncConfigGray(String dataId, String group, String tenant, String grayName, String targetTenant, String srcUser) {
        this.tjt.execute(status -> {
            try {
                ConfigInfoGrayWrapper sourceConfigInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, grayName);
                ConfigInfoGrayWrapper targetConfigInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, targetTenant, grayName);
                if (sourceConfigInfoGrayWrapper == null) {
                    this.removeConfigInfoGrayWithoutHistory(dataId, group, targetTenant, grayName, null, srcUser);
                    ConfigInfoGrayWrapper configInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, grayName);
                    if (configInfoGrayWrapper != null) {
                        throw new Exception("sourceConfigInfoGray has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant + ",grayName=" + grayName);
                    }
                } else if (targetConfigInfoGrayWrapper == null) {
                    sourceConfigInfoGrayWrapper.setTenant(targetTenant);
                    this.configInfoGrayPersistService.addConfigInfoGrayAtomic(-1L, sourceConfigInfoGrayWrapper, sourceConfigInfoGrayWrapper.getGrayName(), sourceConfigInfoGrayWrapper.getGrayRule(), null, srcUser);
                    ConfigInfoGrayWrapper configInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, grayName);
                    if (!StringUtils.equals((String)configInfoGrayWrapper.getMd5(), (String)sourceConfigInfoGrayWrapper.getMd5()) || !StringUtils.equals((String)configInfoGrayWrapper.getGrayRule(), (String)sourceConfigInfoGrayWrapper.getGrayRule())) {
                        throw new Exception("sourceConfigInfoGray has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant + ",grayName=" + grayName);
                    }
                } else if (sourceConfigInfoGrayWrapper.getLastModified() > targetConfigInfoGrayWrapper.getLastModified()) {
                    sourceConfigInfoGrayWrapper.setTenant(targetTenant);
                    this.updateConfigInfo4GrayWithoutHistory(sourceConfigInfoGrayWrapper, sourceConfigInfoGrayWrapper.getGrayName(), sourceConfigInfoGrayWrapper.getGrayRule(), null, srcUser);
                    ConfigInfoGrayWrapper configInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, grayName);
                    if (!StringUtils.equals((String)configInfoGrayWrapper.getMd5(), (String)sourceConfigInfoGrayWrapper.getMd5()) || !StringUtils.equals((String)configInfoGrayWrapper.getGrayRule(), (String)sourceConfigInfoGrayWrapper.getGrayRule())) {
                        throw new Exception("sourceConfigInfoGray has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant + ",grayName=" + grayName);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.FATAL_LOG.error("[db-error] syncConfigGray" + String.valueOf(e), (Throwable)e);
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public void removeConfigInfoGrayWithoutHistory(String dataId, String group, String tenant, String grayName, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName;
        try {
            ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            this.jt.update(configInfoGrayMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "gray_name")), new Object[]{dataId, group, tenantTmp, grayNameTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    public void updateConfigInfo4GrayWithoutHistory(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            this.jt.update(configInfoGrayMapper.update(Arrays.asList("content", "encrypted_data_key", "md5", "src_ip", "src_user", "gmt_modified@NOW()", "app_name", "gray_rule"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name")), new Object[]{configInfo.getContent(), configInfo.getEncryptedDataKey(), md5, srcIp, srcUser, appNameTmp, grayRuleTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void syncConfig(String dataId, String group, String tenant, String targetTenant, String srcUser) {
        this.tjt.execute(status -> {
            try {
                ConfigInfoWrapper sourceConfigInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
                ConfigInfoWrapper targetConfigInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, targetTenant);
                if (sourceConfigInfoWrapper == null) {
                    this.configInfoPersistService.removeConfigInfoAtomic(dataId, group, targetTenant, null, srcUser);
                    ConfigInfoWrapper configInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
                    if (configInfoWrapper != null) {
                        LogUtil.FATAL_LOG.error("syncConfig failed, sourceConfigInfo has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                        throw new Exception("syncConfig failed,sourceConfigInfo has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                    }
                } else if (targetConfigInfoWrapper == null) {
                    sourceConfigInfoWrapper.setTenant(targetTenant);
                    this.configInfoPersistService.addConfigInfoAtomic(-1L, null, srcUser, sourceConfigInfoWrapper, null);
                    ConfigInfoWrapper configInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
                    if (!StringUtils.equals((String)configInfoWrapper.getMd5(), (String)sourceConfigInfoWrapper.getMd5())) {
                        LogUtil.FATAL_LOG.error("syncConfig failed, sourceConfigInfo has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                        throw new Exception("syncConfig failed, sourceConfigInfo has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                    }
                } else if (sourceConfigInfoWrapper.getLastModified() > targetConfigInfoWrapper.getLastModified()) {
                    sourceConfigInfoWrapper.setTenant(targetTenant);
                    this.configInfoPersistService.updateConfigInfoAtomic(sourceConfigInfoWrapper, null, srcUser, null);
                    ConfigInfoWrapper configInfoWrapper = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
                    if (!StringUtils.equals((String)configInfoWrapper.getMd5(), (String)sourceConfigInfoWrapper.getMd5())) {
                        LogUtil.FATAL_LOG.error("syncConfig failed, sourceConfigInfo has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                        throw new Exception("syncConfig failed, sourceConfigInfo has been updated,dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.FATAL_LOG.error("[db-error] syncConfig" + String.valueOf(e), (Throwable)e);
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

