/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.sql.ExternalStorageUtils;
import com.alibaba.nacos.config.server.utils.ConfigExtInfoUtil;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigTagsRelationMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoPersistServiceImpl")
public class ExternalConfigInfoPersistServiceImpl
implements ConfigInfoPersistService {
    public static final String SPOT = ".";
    protected JdbcTemplate jt;
    protected TransactionTemplate tjt;
    MapperManager mapperManager;
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    private HistoryConfigInfoPersistService historyConfigInfoPersistService;

    public ExternalConfigInfoPersistServiceImpl(@Qualifier(value="externalHistoryConfigInfoPersistServiceImpl") HistoryConfigInfoPersistService historyConfigInfoPersistService) {
        this.jt = this.dataSourceService.getJdbcTemplate();
        this.tjt = this.dataSourceService.getTransactionTemplate();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public ConfigOperateResult addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        return (ConfigOperateResult)this.tjt.execute(status -> {
            try {
                ConfigInfoStateWrapper configInfoCurrent;
                long configId = this.addConfigInfoAtomic(-1L, srcIp, srcUser, configInfo, configAdvanceInfo);
                String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                this.addConfigTagsRelation(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                if (!PropertyUtil.CONFIG_MIGRATE_FLAG.get().booleanValue()) {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(0L, configInfo, srcIp, srcUser, now, "I", "formal", null, ConfigExtInfoUtil.getExtraInfoFromAdvanceInfoMap(configAdvanceInfo, srcUser));
                }
                if ((configInfoCurrent = this.findConfigInfoState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant())) == null) {
                    return new ConfigOperateResult(false);
                }
                return new ConfigOperateResult(configInfoCurrent.getId(), configInfoCurrent.getLastModified());
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
                throw e;
            }
        });
    }

    @Override
    public ConfigOperateResult insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        try {
            ConfigInfoStateWrapper configInfoState = this.findConfigInfoState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            if (configInfoState == null) {
                return this.addConfigInfo(srcIp, srcUser, configInfo, configAdvanceInfo);
            }
            return this.updateConfigInfo(configInfo, srcIp, srcUser, configAdvanceInfo);
        }
        catch (Exception exception) {
            LogUtil.FATAL_LOG.error("[db-error] try to update or add config failed, {}", (Object)exception.getMessage(), (Object)exception);
            throw exception;
        }
    }

    @Override
    public ConfigOperateResult insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        try {
            ConfigInfoStateWrapper configInfoState = this.findConfigInfoState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            if (configInfoState == null) {
                return this.addConfigInfo(srcIp, srcUser, configInfo, configAdvanceInfo);
            }
            return this.updateConfigInfoCas(configInfo, srcIp, srcUser, configAdvanceInfo);
        }
        catch (Exception exception) {
            LogUtil.FATAL_LOG.error("[db-error] try to update or add config failed, {}", (Object)exception.getMessage(), (Object)exception);
            throw exception;
        }
    }

    @Override
    public long addConfigInfoAtomic(long configId, String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        KeyHolder keyHolder = ExternalStorageUtils.createKeyHolder();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        try {
            this.jt.update(connection -> this.createPsForInsertConfigInfo(srcIp, srcUser, configInfo, configAdvanceInfo, connection, configInfoMapper), keyHolder);
            Number nu = keyHolder.getKey();
            if (nu == null) {
                throw new IllegalArgumentException("insert config_info fail");
            }
            return nu.longValue();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    PreparedStatement createPsForInsertConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo, Connection connection, ConfigInfoMapper configInfoMapper) throws SQLException {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String insertSql = configInfoMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_create@NOW()", "gmt_modified@NOW()", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"));
        PreparedStatement ps = connection.prepareStatement(insertSql, configInfoMapper.getPrimaryKeyGeneratedKeys());
        ps.setString(1, configInfo.getDataId());
        ps.setString(2, configInfo.getGroup());
        ps.setString(3, tenantTmp);
        ps.setString(4, appNameTmp);
        ps.setString(5, configInfo.getContent());
        ps.setString(6, md5Tmp);
        ps.setString(7, srcIp);
        ps.setString(8, srcUser);
        ps.setString(9, desc);
        ps.setString(10, use);
        ps.setString(11, effect);
        ps.setString(12, type);
        ps.setString(13, schema);
        ps.setString(14, encryptedDataKey);
        return ps;
    }

    @Override
    public void addConfigTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        try {
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            this.jt.update(configTagsRelationMapper.insert(Arrays.asList("id", "tag_name", "tag_type", "data_id", "group_id", "tenant_id")), new Object[]{configId, tagName, "", dataId, group, tenant});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addConfigTagsRelation(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                this.addConfigTagRelationAtomic(configId, tagArr[i], dataId, group, tenant);
            }
        }
    }

    @Override
    public Map<String, Object> batchInsertOrUpdate(List<ConfigAllInfo> configInfoList, String srcUser, String srcIp, Map<String, Object> configAdvanceInfo, SameConfigPolicy policy) throws NacosException {
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = null;
        ArrayList skipData = null;
        for (int i = 0; i < configInfoList.size(); ++i) {
            boolean success;
            ConfigAllInfo configInfo = configInfoList.get(i);
            try {
                ParamUtils.checkParam(configInfo.getDataId(), configInfo.getGroup(), "datumId", configInfo.getContent());
            }
            catch (NacosException e) {
                LogUtil.DEFAULT_LOG.error("data verification failed", (Throwable)e);
                throw e;
            }
            ConfigInfo configInfo2Save = new ConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), configInfo.getAppName(), configInfo.getContent());
            configInfo2Save.setEncryptedDataKey(configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey());
            String type = this.determineConfigType(configInfo);
            if (configAdvanceInfo == null) {
                configAdvanceInfo = new HashMap<String, Object>(16);
            }
            configAdvanceInfo.put("type", type);
            configAdvanceInfo.put("desc", configInfo.getDesc());
            try {
                ConfigOperateResult configOperateResult = this.addConfigInfo(srcIp, srcUser, configInfo2Save, configAdvanceInfo);
                success = configOperateResult.isSuccess();
            }
            catch (DataIntegrityViolationException ive) {
                success = false;
            }
            if (success) {
                ++succCount;
                continue;
            }
            if (SameConfigPolicy.ABORT.equals((Object)policy)) {
                failData = new ArrayList();
                skipData = new ArrayList();
                HashMap<String, String> failedItem = new HashMap<String, String>(2);
                failedItem.put("dataId", configInfo2Save.getDataId());
                failedItem.put("group", configInfo2Save.getGroup());
                failData.add(failedItem);
                for (int j = i + 1; j < configInfoList.size(); ++j) {
                    ConfigInfo skipConfigInfo = configInfoList.get(j);
                    HashMap<String, String> skipItem = new HashMap<String, String>(2);
                    skipItem.put("dataId", skipConfigInfo.getDataId());
                    skipItem.put("group", skipConfigInfo.getGroup());
                    skipData.add(skipItem);
                    ++skipCount;
                }
                break;
            }
            if (SameConfigPolicy.SKIP.equals((Object)policy)) {
                ++skipCount;
                if (skipData == null) {
                    skipData = new ArrayList();
                }
                HashMap<String, String> skipItem = new HashMap<String, String>(2);
                skipItem.put("dataId", configInfo2Save.getDataId());
                skipItem.put("group", configInfo2Save.getGroup());
                skipData.add(skipItem);
                continue;
            }
            if (!SameConfigPolicy.OVERWRITE.equals((Object)policy)) continue;
            ++succCount;
            this.updateConfigInfo(configInfo2Save, srcIp, srcUser, configAdvanceInfo);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("succCount", succCount);
        result.put("skipCount", skipCount);
        if (failData != null && !failData.isEmpty()) {
            result.put("failData", failData);
        }
        if (skipData != null && !skipData.isEmpty()) {
            result.put("skipData", skipData);
        }
        return result;
    }

    private String determineConfigType(ConfigAllInfo configInfo) {
        String type = configInfo.getType();
        if (StringUtils.isBlank((CharSequence)type)) {
            if (configInfo.getDataId().contains(SPOT)) {
                String extName = configInfo.getDataId().substring(configInfo.getDataId().lastIndexOf(SPOT) + 1);
                FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(extName);
                type = fileTypeEnum.getFileType();
            } else {
                type = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(null).getFileType();
            }
        }
        return type;
    }

    @Override
    public void removeConfigInfo(final String dataId, final String group, final String tenant, final String srcIp, final String srcUser) {
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    ConfigAllInfo oldConfigAllInfo = ExternalConfigInfoPersistServiceImpl.this.findConfigAllInfo(dataId, group, tenant);
                    if (oldConfigAllInfo != null) {
                        ExternalConfigInfoPersistServiceImpl.this.removeConfigInfoAtomic(dataId, group, tenant, srcIp, srcUser);
                        ExternalConfigInfoPersistServiceImpl.this.removeTagByIdAtomic(oldConfigAllInfo.getId());
                        if (!PropertyUtil.CONFIG_MIGRATE_FLAG.get().booleanValue()) {
                            ExternalConfigInfoPersistServiceImpl.this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo.getId(), oldConfigAllInfo, srcIp, srcUser, this.time, "D", "formal", null, ConfigExtInfoUtil.getExtInfoFromAllInfo(oldConfigAllInfo));
                        }
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public List<ConfigAllInfo> removeConfigInfoByIds(final List<Long> ids, final String srcIp, final String srcUser) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.removeAll(Collections.singleton(null));
        return (List)this.tjt.execute((TransactionCallback)new TransactionCallback<List<ConfigAllInfo>>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public List<ConfigAllInfo> doInTransaction(TransactionStatus status) {
                try {
                    String idsStr = StringUtils.join((Collection)ids, (String)",");
                    List<ConfigAllInfo> oldConfigAllInfoList = ExternalConfigInfoPersistServiceImpl.this.findAllConfigInfo4Export(null, null, null, null, ids);
                    if (!CollectionUtils.isEmpty(oldConfigAllInfoList)) {
                        ExternalConfigInfoPersistServiceImpl.this.removeConfigInfoByIdsAtomic(idsStr);
                        for (ConfigAllInfo configAllInfo : oldConfigAllInfoList) {
                            ExternalConfigInfoPersistServiceImpl.this.removeTagByIdAtomic(configAllInfo.getId());
                            ExternalConfigInfoPersistServiceImpl.this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configAllInfo.getId(), configAllInfo, srcIp, srcUser, this.time, "D", "formal", null, ConfigExtInfoUtil.getExtInfoFromAllInfo(configAllInfo));
                        }
                    }
                    return oldConfigAllInfoList;
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    @Override
    public void removeTagByIdAtomic(long id) {
        try {
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            this.jt.update(configTagsRelationMapper.delete(Collections.singletonList("id")), new Object[]{id});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            this.jt.update(configInfoMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoByIdsAtomic(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            paramList.add(Long.parseLong(idArr[i]));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("ids", paramList);
        MapperResult result = configInfoMapper.removeConfigInfoByIdsAtomic(context);
        try {
            this.jt.update(result.getSql(), result.getParamList().toArray());
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigOperateResult updateConfigInfo(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        return (ConfigOperateResult)this.tjt.execute(status -> {
            try {
                String configTags;
                ConfigAllInfo oldConfigAllInfo = this.findConfigAllInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                if (oldConfigAllInfo == null) {
                    if (LogUtil.FATAL_LOG.isErrorEnabled()) {
                        LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()});
                    }
                    return new ConfigOperateResult(false);
                }
                String appNameTmp = oldConfigAllInfo.getAppName();
                if (configInfo.getAppName() == null) {
                    configInfo.setAppName(appNameTmp);
                }
                this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, configAdvanceInfo);
                String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                if (configTags != null) {
                    this.removeTagByIdAtomic(oldConfigAllInfo.getId());
                    this.addConfigTagsRelation(oldConfigAllInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                }
                if (!PropertyUtil.CONFIG_MIGRATE_FLAG.get().booleanValue()) {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo.getId(), oldConfigAllInfo, srcIp, srcUser, now, "U", "formal", null, ConfigExtInfoUtil.getExtInfoFromAllInfo(oldConfigAllInfo));
                }
                return this.getConfigInfoOperateResult(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
                throw e;
            }
        });
    }

    private ConfigOperateResult getConfigInfoOperateResult(String dataId, String group, String tenant) {
        ConfigInfoStateWrapper configInfoLast = this.findConfigInfoState(dataId, group, tenant);
        if (configInfoLast == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfoLast.getId(), configInfoLast.getLastModified());
    }

    @Override
    public ConfigOperateResult updateConfigInfoCas(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        return (ConfigOperateResult)this.tjt.execute(status -> {
            try {
                ConfigInfoStateWrapper configInfoLast;
                String configTags;
                int rows;
                ConfigAllInfo oldAllConfigInfo = this.findConfigAllInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                if (oldAllConfigInfo == null) {
                    if (LogUtil.FATAL_LOG.isErrorEnabled()) {
                        LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()});
                    }
                    return new ConfigOperateResult(false);
                }
                String appNameTmp = oldAllConfigInfo.getAppName();
                if (configInfo.getAppName() == null) {
                    configInfo.setAppName(appNameTmp);
                }
                if ((rows = this.updateConfigInfoAtomicCas(configInfo, srcIp, srcUser, configAdvanceInfo)) < 1) {
                    return new ConfigOperateResult(false);
                }
                String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                if (configTags != null) {
                    this.removeTagByIdAtomic(oldAllConfigInfo.getId());
                    this.addConfigTagsRelation(oldAllConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                }
                if (!PropertyUtil.CONFIG_MIGRATE_FLAG.get().booleanValue()) {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldAllConfigInfo.getId(), oldAllConfigInfo, srcIp, srcUser, now, "U", "formal", null, ConfigExtInfoUtil.getExtInfoFromAllInfo(oldAllConfigInfo));
                }
                if ((configInfoLast = this.findConfigInfoState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant())) == null) {
                    return new ConfigOperateResult(false);
                }
                return new ConfigOperateResult(configInfoLast.getId(), configInfoLast.getLastModified());
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
                throw e;
            }
        });
    }

    private int updateConfigInfoAtomicCas(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)Constants.PERSIST_ENCODE);
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            MapperContext context = new MapperContext();
            context.putUpdateParameter("content", (Object)configInfo.getContent());
            context.putUpdateParameter("md5", (Object)md5Tmp);
            context.putUpdateParameter("srcIp", (Object)srcIp);
            context.putUpdateParameter("srcUser", (Object)srcUser);
            context.putUpdateParameter("app_name", (Object)appNameTmp);
            context.putUpdateParameter("cDesc", (Object)desc);
            context.putUpdateParameter("cUse", (Object)use);
            context.putUpdateParameter("effect", (Object)effect);
            context.putUpdateParameter("type", (Object)type);
            context.putUpdateParameter("cSchema", (Object)schema);
            context.putUpdateParameter("encrypted_data_key", (Object)encryptedDataKey);
            context.putWhereParameter("dataId", (Object)configInfo.getDataId());
            context.putWhereParameter("groupId", (Object)configInfo.getGroup());
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            context.putWhereParameter("md5", (Object)configInfo.getMd5());
            MapperResult mapperResult = configInfoMapper.updateConfigInfoAtomicCas(context);
            return this.jt.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            this.jt.update(configInfoMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified@NOW()", "app_name", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, appNameTmp, desc, use, effect, type, schema, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public long findConfigMaxId() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperResult mapperResult = configInfoMapper.findConfigMaxId(null);
        try {
            return (Long)this.jt.queryForObject(mapperResult.getSql(), Long.class);
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    @Override
    public ConfigInfo findConfigInfo(long id) {
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfo)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content"), Collections.singletonList("id")), new Object[]{id}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoWrapper findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfoWrapper)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "type", "encrypted_data_key", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp}, ConfigRowMapperInjector.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        MapperResult sql;
        MapperResult sqlCount;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper helper = this.createPaginationHelper();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("content");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        MapperContext context = new MapperContext();
        context.putWhereParameter("tenantId", (Object)tenantTmp);
        if (StringUtils.isNotBlank((String)dataId)) {
            context.putWhereParameter("dataId", (Object)dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            context.putWhereParameter("groupId", (Object)group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            context.putWhereParameter("app_name", (Object)appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            context.putWhereParameter("content", (Object)content);
        }
        context.setStartRow((pageNo - 1) * pageSize);
        context.setPageSize(pageSize);
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            context.putWhereParameter("tagARR", (Object)tagArr);
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCount = configTagsRelationMapper.findConfigInfo4PageCountRows(context);
            sql = configTagsRelationMapper.findConfigInfo4PageFetchRows(context);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCount = configInfoMapper.findConfigInfo4PageCountRows(context);
            sql = configInfoMapper.findConfigInfo4PageFetchRows(context);
        }
        try {
            Page page = helper.fetchPageLimit(sqlCount, sql, pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
            for (ConfigInfo configInfo : page.getPageItems()) {
                Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
                configInfo.setContent((String)pair.getSecond());
            }
            return page;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoCount() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoCount(String tenant) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("tenantId", (Object)tenant);
        MapperResult mapperResult = configInfoMapper.configInfoLikeTenantCount(context);
        Integer result = (Integer)this.jt.queryForObject(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public List<String> getTenantIdList(int page, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        MapperResult mapperResult = configInfoMapper.getTenantIdList(new MapperContext(from, pageSize));
        return this.jt.queryForList(mapperResult.getSql(), mapperResult.getParamList().toArray(), String.class);
    }

    @Override
    public List<String> getGroupIdList(int page, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        MapperResult mapperResult = configInfoMapper.getGroupIdList(new MapperContext(from, pageSize));
        return this.jt.queryForList(mapperResult.getSql(), mapperResult.getParamList().toArray(), String.class);
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize, boolean needContent) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext(0, pageSize);
        context.putContextParameter("needContent", String.valueOf(needContent));
        context.putWhereParameter("id", (Object)lastMaxId);
        MapperResult select = configInfoMapper.findAllConfigInfoFragment(context);
        PaginationHelper helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(select.getSql(), select.getParamList().toArray(), 1, pageSize, ConfigRowMapperInjector.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        MapperResult sqlFetchRows;
        MapperResult sqlCountRows;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("content");
        String types = Optional.ofNullable(configAdvanceInfo).map(e -> (String)e.get("types")).orElse(null);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        PaginationHelper helper = this.createPaginationHelper();
        MapperContext context = new MapperContext((pageNo - 1) * pageSize, pageSize);
        context.putWhereParameter("tenantId", (Object)this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            context.putWhereParameter("dataId", (Object)this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            context.putWhereParameter("groupId", (Object)this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            context.putWhereParameter("app_name", (Object)appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            context.putWhereParameter("content", (Object)this.generateLikeArgument(content));
        }
        if (StringUtils.isNotBlank((String)types)) {
            String[] typesArr = types.split(",");
            context.putWhereParameter("type", (Object)typesArr);
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            context.putWhereParameter("tagARR", (Object)tagArr);
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCountRows = configTagsRelationMapper.findConfigInfoLike4PageCountRows(context);
            sqlFetchRows = configTagsRelationMapper.findConfigInfoLike4PageFetchRows(context);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCountRows = configInfoMapper.findConfigInfoLike4PageCountRows(context);
            sqlFetchRows = configInfoMapper.findConfigInfoLike4PageFetchRows(context);
        }
        try {
            Page page = helper.fetchPageLimit(sqlCountRows, sqlFetchRows, pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
            for (ConfigInfo configInfo : page.getPageItems()) {
                Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
                configInfo.setContent((String)pair.getSecond());
            }
            return page;
        }
        catch (CannotGetJdbcConnectionException e2) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e2), (Throwable)e2);
            throw e2;
        }
    }

    @Override
    public List<ConfigInfoStateWrapper> findChangeConfig(Timestamp startTime, long lastMaxId, int pageSize) {
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            MapperContext context = new MapperContext();
            context.putWhereParameter("startTime", (Object)startTime);
            context.putWhereParameter("pageSize", (Object)pageSize);
            context.putWhereParameter("lastMaxId", (Object)lastMaxId);
            MapperResult mapperResult = configInfoMapper.findChangeConfig(context);
            return this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.select(Collections.singletonList("tag_name"), Arrays.asList("data_id", "group_id", "tenant_id"));
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, group, tenant}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> findConfigInfosByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return null;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            paramList.add(Long.parseLong(idArr[i]));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("ids", paramList);
        MapperResult mapperResult = configInfoMapper.findConfigInfosByIds(context);
        try {
            return this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            ConfigAdvanceInfo configAdvance = (ConfigAdvanceInfo)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_ADVANCE_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(',').append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            ConfigAllInfo configAdvance = (ConfigAllInfo)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_ALL_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(',').append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfoState(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfoStateWrapper)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigAllInfo> findAllConfigInfo4Export(String dataId, String group, String tenant, String appName, List<Long> ids) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        if (!CollectionUtils.isEmpty(ids)) {
            context.putWhereParameter("ids", ids);
        } else {
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                context.putWhereParameter("dataId", (Object)this.generateLikeArgument(dataId));
            }
            if (StringUtils.isNotBlank((String)group)) {
                context.putWhereParameter("groupId", (Object)group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                context.putWhereParameter("app_name", (Object)appName);
            }
        }
        MapperResult mapperResult = configInfoMapper.findAllConfigInfo4Export(context);
        try {
            List configAllInfos = this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_ALL_INFO_ROW_MAPPER);
            if (CollectionUtils.isEmpty((Collection)configAllInfos)) {
                return configAllInfos;
            }
            for (ConfigAllInfo configAllInfo : configAllInfos) {
                List<String> configTagList = this.selectTagByConfig(configAllInfo.getDataId(), configAllInfo.getGroup(), configAllInfo.getTenant());
                if (!CollectionUtils.isNotEmpty(configTagList)) continue;
                StringBuilder configTags = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTags.length() == 0) {
                        configTags.append(configTag);
                        continue;
                    }
                    configTags.append(',').append(configTag);
                }
                configAllInfo.setConfigTags(configTags.toString());
            }
            return configAllInfos;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoWrapper> queryConfigInfoByNamespace(String tenant) {
        if (Objects.isNull(tenant)) {
            throw new IllegalArgumentException("tenantId can not be null");
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return this.jt.query(configInfoMapper.select(Arrays.asList("data_id", "group_id", "tenant_id", "app_name", "type"), Collections.singletonList("tenant_id")), new Object[]{tenantTmp}, ConfigRowMapperInjector.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.EMPTY_LIST;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }
}

