/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.config.server.utils.ConfigExtInfoUtil;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoGrayMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoGrayPersistServiceImpl")
public class EmbeddedConfigInfoGrayPersistServiceImpl
implements ConfigInfoGrayPersistService {
    private static final String RESOURCE_CONFIG_HISTORY_ID = "config-history-id";
    private static final String RESOURCE_CONFIG_HISTORY_GRAY_ID = "config-history-gray-id";
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;
    private final IdGeneratorManager idGeneratorManager;
    private final HistoryConfigInfoPersistService historyConfigInfoPersistService;

    public EmbeddedConfigInfoGrayPersistServiceImpl(DatabaseOperate databaseOperate, IdGeneratorManager idGeneratorManager, @Qualifier(value="embeddedHistoryConfigInfoPersistServiceImpl") HistoryConfigInfoPersistService historyConfigInfoPersistService) {
        this.databaseOperate = databaseOperate;
        this.idGeneratorManager = idGeneratorManager;
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        idGeneratorManager.register(new String[]{RESOURCE_CONFIG_HISTORY_GRAY_ID, RESOURCE_CONFIG_HISTORY_ID});
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfo4GrayState(String dataId, String group, String tenant, String grayName) {
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String sql = configInfoGrayMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name"));
        return (ConfigInfoStateWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp, grayNameTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
    }

    private ConfigOperateResult getGrayOperateResult(String dataId, String group, String tenant, String grayName) {
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)tenant);
        ConfigInfoStateWrapper configInfo4Gray = this.findConfigInfo4GrayState(dataId, group, tenantTmp, grayName);
        if (configInfo4Gray == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4Gray.getId(), configInfo4Gray.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult addConfigInfo4Gray(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
        configInfo.setTenant(tenantTmp);
        try {
            long configGrayId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_GRAY_ID);
            long hisId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_ID);
            this.addConfigInfoGrayAtomic(configGrayId, configInfo, grayNameTmp, grayRuleTmp, srcIp, srcUser);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (!PropertyUtil.GRAY_MIGRATE_FLAG.get().booleanValue()) {
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(hisId, configInfo, srcIp, srcUser, now, "I", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(grayNameTmp, grayRuleTmp, srcUser));
            }
            EmbeddedStorageContextUtils.onModifyConfigGrayInfo(configInfo, grayNameTmp, grayRuleTmp, srcIp, now);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getGrayOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public void addConfigInfoGrayAtomic(long configGrayId, ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.insert(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gray_name", "gray_rule", "app_name", "content", "md5", "src_ip", "src_user", "gmt_create", "gmt_modified"));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Object[] args = new Object[]{configGrayId, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp, grayRuleTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public ConfigOperateResult insertOrUpdateGray(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        if (this.findConfigInfo4GrayState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), grayName) == null) {
            return this.addConfigInfo4Gray(configInfo, grayName, grayRule, srcIp, srcUser);
        }
        return this.updateConfigInfo4Gray(configInfo, grayName, grayRule, srcIp, srcUser);
    }

    @Override
    public ConfigOperateResult insertOrUpdateGrayCas(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        if (this.findConfigInfo4GrayState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), grayName) == null) {
            return this.addConfigInfo4Gray(configInfo, grayName, grayRule, srcIp, srcUser);
        }
        return this.updateConfigInfo4GrayCas(configInfo, grayName, grayRule, srcIp, srcUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfoGray(String dataId, String group, String tenant, String grayName, String srcIp, String srcUser) {
        String grayNameTmp;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoGrayWrapper oldConfigAllInfo4Gray = this.findConfigInfo4Gray(dataId, group, tenantTmp, grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName);
        if (oldConfigAllInfo4Gray == null && LogUtil.FATAL_LOG.isErrorEnabled()) {
            LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{dataId, group, tenant});
        }
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "gray_name"));
        Object[] args = new Object[]{dataId, group, tenantTmp, grayNameTmp};
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (!PropertyUtil.GRAY_MIGRATE_FLAG.get().booleanValue()) {
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo4Gray.getId(), oldConfigAllInfo4Gray, srcIp, srcUser, now, "D", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(oldConfigAllInfo4Gray.getGrayName(), oldConfigAllInfo4Gray.getGrayRule(), oldConfigAllInfo4Gray.getSrcUser()));
        }
        EmbeddedStorageContextUtils.onDeleteConfigGrayInfo(tenantTmp, group, dataId, grayNameTmp, srcIp);
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo4Gray(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
        configInfo.setTenant(tenantTmp);
        try {
            ConfigInfoGrayWrapper oldConfigAllInfo4Gray = this.findConfigInfo4Gray(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
            if (oldConfigAllInfo4Gray == null && LogUtil.FATAL_LOG.isErrorEnabled()) {
                LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()});
            }
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String sql = configInfoGrayMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified", "app_name", "gray_rule"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name"));
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, grayRuleTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp};
            if (!PropertyUtil.GRAY_MIGRATE_FLAG.get().booleanValue()) {
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo4Gray.getId(), oldConfigAllInfo4Gray, srcIp, srcUser, time, "U", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(oldConfigAllInfo4Gray.getGrayName(), oldConfigAllInfo4Gray.getGrayRule(), oldConfigAllInfo4Gray.getSrcUser()));
            }
            EmbeddedStorageContextUtils.onModifyConfigGrayInfo(configInfo, grayNameTmp, grayRuleTmp, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getGrayOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo4GrayCas(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
        configInfo.setTenant(tenantTmp);
        try {
            ConfigInfoGrayWrapper oldConfigAllInfo4Gray = this.findConfigInfo4Gray(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
            if (oldConfigAllInfo4Gray == null && LogUtil.FATAL_LOG.isErrorEnabled()) {
                LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()});
            }
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            MapperContext context = new MapperContext();
            context.putUpdateParameter("content", (Object)configInfo.getContent());
            context.putUpdateParameter("md5", (Object)md5);
            context.putUpdateParameter("srcIp", (Object)srcIp);
            context.putUpdateParameter("srcUser", (Object)srcUser);
            context.putUpdateParameter("gmtModified", (Object)time);
            context.putUpdateParameter("app_name", (Object)appNameTmp);
            context.putWhereParameter("dataId", (Object)configInfo.getDataId());
            context.putWhereParameter("groupId", (Object)configInfo.getGroup());
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            context.putWhereParameter("grayName", (Object)grayNameTmp);
            context.putWhereParameter("grayRule", (Object)grayRuleTmp);
            context.putWhereParameter("md5", (Object)configInfo.getMd5());
            MapperResult mapperResult = configInfoGrayMapper.updateConfigInfo4GrayCas(context);
            if (!PropertyUtil.GRAY_MIGRATE_FLAG.get().booleanValue()) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo4Gray.getId(), oldConfigAllInfo4Gray, srcIp, srcUser, now, "U", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(oldConfigAllInfo4Gray.getGrayName(), oldConfigAllInfo4Gray.getGrayRule(), oldConfigAllInfo4Gray.getSrcUser()));
            }
            EmbeddedStorageContextUtils.onModifyConfigGrayInfo(configInfo, grayNameTmp, grayRuleTmp, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)mapperResult.getSql(), (Object[])mapperResult.getParamList().toArray());
            Boolean success = this.databaseOperate.blockUpdate();
            if (success.booleanValue()) {
                ConfigOperateResult configOperateResult = this.getGrayOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
                return configOperateResult;
            }
            ConfigOperateResult configOperateResult = new ConfigOperateResult(false);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public ConfigInfoGrayWrapper findConfigInfo4Gray(String dataId, String group, String tenant, String grayName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gray_name", "gray_rule", "app_name", "content", "md5", "gmt_modified", "src_user", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name"));
        return (ConfigInfoGrayWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp, grayNameTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
    }

    @Override
    public int configInfoGrayCount() {
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.count(null);
        Integer result = (Integer)this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoGrayWrapper> findAllConfigInfoGrayForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sqlCountRows = configInfoGrayMapper.count(null);
        MapperResult sqlFetchRows = configInfoGrayMapper.findAllConfigInfoGrayForDumpAllFetchRows(new MapperContext(startRow, pageSize));
        PaginationHelper helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<String> findConfigInfoGrays(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.select(Collections.singletonList("gray_name"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenantTmp}, String.class);
    }

    @Override
    public List<ConfigInfoGrayWrapper> findChangeConfig(Timestamp startTime, long lastMaxId, int pageSize) {
        try {
            ConfigInfoGrayMapper configInfoMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            MapperContext context = new MapperContext();
            context.putWhereParameter("startTime", (Object)startTime);
            context.putWhereParameter("pageSize", (Object)pageSize);
            context.putWhereParameter("lastMaxId", (Object)lastMaxId);
            MapperResult mapperResult = configInfoMapper.findChangeConfig(context);
            return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }
}

