/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.query.handler;

import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.service.query.handler.AbstractConfigQueryHandler;
import com.alibaba.nacos.config.server.service.query.handler.ConfigChainEntryHandler;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import java.io.IOException;

public class GrayRuleMatchHandler
extends AbstractConfigQueryHandler {
    private static final String GRAY_RULE_MATCH_HANDLER = "grayRuleMatchHandler";

    @Override
    public String getName() {
        return GRAY_RULE_MATCH_HANDLER;
    }

    @Override
    public ConfigQueryChainResponse handle(ConfigQueryChainRequest request) throws IOException {
        CacheItem cacheItem = ConfigChainEntryHandler.getThreadLocalCacheItem();
        ConfigCache matchedGray = null;
        if (cacheItem.getSortConfigGrays() != null && !cacheItem.getSortConfigGrays().isEmpty()) {
            for (ConfigCacheGray configCacheGray : cacheItem.getSortConfigGrays()) {
                if (!configCacheGray.match(request.getAppLabels())) continue;
                matchedGray = configCacheGray;
                break;
            }
        }
        if (matchedGray != null) {
            ConfigQueryChainResponse response = new ConfigQueryChainResponse();
            long lastModified = matchedGray.getLastModifiedTs();
            String md5 = matchedGray.getMd5();
            String encryptedDataKey = matchedGray.getEncryptedDataKey();
            String content = ConfigDiskServiceFactory.getInstance().getGrayContent(request.getDataId(), request.getGroup(), request.getTenant(), ((ConfigCacheGray)matchedGray).getGrayName());
            response.setContent(content);
            response.setMd5(md5);
            response.setLastModified(lastModified);
            response.setEncryptedDataKey(encryptedDataKey);
            response.setMatchedGray((ConfigCacheGray)matchedGray);
            response.setConfigType(cacheItem.getType());
            response.setStatus(ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_GRAY);
            return response;
        }
        return this.nextHandler.handle(request);
    }
}

