/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.common.http.AbstractHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientManager.class);
    private static final int TIMEOUT = 500;
    private static final NacosRestTemplate NACOS_REST_TEMPLATE = HttpClientBeanHolder.getNacosRestTemplate((HttpClientFactory)new ConfigHttpClientFactory(500, 500));
    private static final NacosAsyncRestTemplate NACOS_ASYNC_REST_TEMPLATE = HttpClientBeanHolder.getNacosAsyncRestTemplate((HttpClientFactory)new ConfigHttpClientFactory(PropertyUtil.getNotifyConnectTimeout(), PropertyUtil.getNotifySocketTimeout()));

    public static NacosRestTemplate getNacosRestTemplate() {
        return NACOS_REST_TEMPLATE;
    }

    public static NacosAsyncRestTemplate getNacosAsyncRestTemplate() {
        return NACOS_ASYNC_REST_TEMPLATE;
    }

    private static void shutdown() {
        LOGGER.info("[ConfigServer-HttpClientManager] Start destroying NacosRestTemplate");
        try {
            String httpClientFactoryBeanName = ConfigHttpClientFactory.class.getName();
            HttpClientBeanHolder.shutdownNacosSyncRest((String)httpClientFactoryBeanName);
            HttpClientBeanHolder.shutdownNacosAsyncRest((String)httpClientFactoryBeanName);
        }
        catch (Exception ex) {
            LOGGER.error("[ConfigServer-HttpClientManager] An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace((Throwable)ex));
        }
        LOGGER.info("[ConfigServer-HttpClientManager] Completed destruction of NacosRestTemplate");
    }

    static {
        ThreadUtils.addShutdownHook(HttpClientManager::shutdown);
    }

    private static class ConfigHttpClientFactory
    extends AbstractHttpClientFactory {
        private final int conTimeOutMillis;
        private final int readTimeOutMillis;

        public ConfigHttpClientFactory(int conTimeOutMillis, int readTimeOutMillis) {
            this.conTimeOutMillis = conTimeOutMillis;
            this.readTimeOutMillis = readTimeOutMillis;
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConTimeOutMillis(this.conTimeOutMillis).setReadTimeOutMillis(this.readTimeOutMillis).build();
        }

        protected Logger assignLogger() {
            return LOGGER;
        }
    }
}

