/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchSyncRequest;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.task.BatchTaskCounter;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import com.alibaba.nacos.config.server.configuration.ConfigCommonConfig;
import com.alibaba.nacos.config.server.model.event.ConfigFuzzyWatchEvent;
import com.alibaba.nacos.config.server.remote.FuzzyWatchSyncNotifyTask;
import com.alibaba.nacos.config.server.service.ConfigFuzzyWatchContextService;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RpcPushService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="configFuzzyWatchSyncNotifier")
public class ConfigFuzzyWatchSyncNotifier
extends SmartSubscriber {
    private final ConnectionManager connectionManager;
    private final RpcPushService rpcPushService;
    private final ConfigFuzzyWatchContextService configFuzzyWatchContextService;

    public ConfigFuzzyWatchSyncNotifier(ConnectionManager connectionManager, RpcPushService rpcPushService, ConfigFuzzyWatchContextService configFuzzyWatchContextService) {
        this.connectionManager = connectionManager;
        this.rpcPushService = rpcPushService;
        this.configFuzzyWatchContextService = configFuzzyWatchContextService;
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void handleFuzzyWatchEvent(ConfigFuzzyWatchEvent event) {
        Set<String> clientExistingGroupKeys;
        Set<String> matchGroupKeys = this.configFuzzyWatchContextService.matchGroupKeys(event.getGroupKeyPattern());
        List configStates = FuzzyGroupKeyPattern.diffGroupKeys(matchGroupKeys, clientExistingGroupKeys = event.getClientExistingGroupKeys());
        if (CollectionUtils.isEmpty((Collection)configStates)) {
            int maxPushRetryTimes = ConfigCommonConfig.getInstance().getMaxPushRetryTimes();
            if (event.isInitializing()) {
                ConfigFuzzyWatchSyncRequest request = ConfigFuzzyWatchSyncRequest.buildInitFinishRequest((String)event.getGroupKeyPattern());
                FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask = new FuzzyWatchSyncNotifyTask(this.connectionManager, this.rpcPushService, request, null, maxPushRetryTimes, event.getConnectionId());
                fuzzyWatchSyncNotifyTask.scheduleSelf();
            }
        } else {
            if (this.configFuzzyWatchContextService.reachToUpLimit(event.getGroupKeyPattern())) {
                configStates.removeIf(item -> !item.isExist());
            }
            String syncType = event.isInitializing() ? "FUZZY_WATCH_INIT_NOTIFY" : "FUZZY_WATCH_DIFF_SYNC_NOTIFY";
            int batchSize = ConfigCommonConfig.getInstance().getBatchSize();
            List divideConfigStatesIntoBatches = this.divideConfigStatesIntoBatches(configStates, batchSize);
            int totalBatch = divideConfigStatesIntoBatches.size();
            BatchTaskCounter batchTaskCounter = new BatchTaskCounter(divideConfigStatesIntoBatches.size());
            int currentBatch = 1;
            for (List configStateList : divideConfigStatesIntoBatches) {
                Set contexts = configStateList.stream().map(state -> {
                    String changeType = state.isExist() ? "ADD_CONFIG" : "DELETE_CONFIG";
                    return ConfigFuzzyWatchSyncRequest.Context.build((String)state.getGroupKey(), (String)changeType);
                }).collect(Collectors.toSet());
                ConfigFuzzyWatchSyncRequest request = ConfigFuzzyWatchSyncRequest.buildSyncRequest((String)syncType, contexts, (String)event.getGroupKeyPattern(), (int)totalBatch, (int)currentBatch);
                int maxPushRetryTimes = ConfigCommonConfig.getInstance().getMaxPushRetryTimes();
                FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask = new FuzzyWatchSyncNotifyTask(this.connectionManager, this.rpcPushService, request, batchTaskCounter, maxPushRetryTimes, event.getConnectionId());
                fuzzyWatchSyncNotifyTask.scheduleSelf();
                ++currentBatch;
            }
        }
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ConfigFuzzyWatchEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (event instanceof ConfigFuzzyWatchEvent) {
            this.handleFuzzyWatchEvent((ConfigFuzzyWatchEvent)event);
        }
    }

    private <T> List<List<T>> divideConfigStatesIntoBatches(Collection<T> configStates, int batchSize) {
        AtomicInteger index = new AtomicInteger();
        return new ArrayList<List<T>>(configStates.stream().collect(Collectors.groupingBy(e -> index.getAndIncrement() / batchSize)).values());
    }
}

