/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.listener.ConfigListenerStateDelegate;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.core.model.form.AggregationForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/cs/listener"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ListenerControllerV3 {
    private final ConfigListenerStateDelegate configListenerStateDelegate;

    public ListenerControllerV3(ConfigListenerStateDelegate configListenerStateDelegate) {
        this.configListenerStateDelegate = configListenerStateDelegate;
    }

    @GetMapping
    @Secured(resource="/v3/admin/cs/listener", signType="config", apiType=ApiType.ADMIN_API)
    public Result<ConfigListenerInfo> getAllSubClientConfigByIp(@RequestParam(value="ip") String ip, @RequestParam(value="all", required=false) boolean all, @RequestParam(value="namespaceId", required=false) String namespaceId, AggregationForm aggregationForm) {
        ConfigListenerInfo result = this.configListenerStateDelegate.getListenerStateByIp(ip, aggregationForm.isAggregation());
        result.setQueryType("ip");
        HashMap<String, String> configMd5Status = new HashMap<String, String>(100);
        if (result.getListenersStatus() == null || result.getListenersStatus().isEmpty()) {
            return Result.success((Object)result);
        }
        Map status = result.getListenersStatus();
        for (Map.Entry config : status.entrySet()) {
            if (!StringUtils.isBlank((CharSequence)namespaceId) && ((String)config.getKey()).contains(namespaceId)) {
                configMd5Status.put((String)config.getKey(), (String)config.getValue());
                continue;
            }
            if (all) {
                configMd5Status.put((String)config.getKey(), (String)config.getValue());
                continue;
            }
            String[] configKeys = GroupKey2.parseKey((String)config.getKey());
            if (!StringUtils.isBlank((CharSequence)configKeys[2])) continue;
            configMd5Status.put((String)config.getKey(), (String)config.getValue());
        }
        result.setListenersStatus(configMd5Status);
        return Result.success((Object)result);
    }
}

