/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigCloneInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.DateFormatUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigMetadata;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.paramcheck.ConfigBlurSearchHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.ConfigMigrateService;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.listener.ConfigListenerStateDelegate;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.ResponseUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.config.server.utils.YamlParserUtil;
import com.alibaba.nacos.config.server.utils.ZipUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.model.form.AggregationForm;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.utils.InetUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/cs/config"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConfigControllerV3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigControllerV3.class);
    private static final String EXPORT_CONFIG_FILE_NAME = "nacos_config_export_";
    private static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";
    private static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyyMMddHHmmss";
    private final ConfigOperationService configOperationService;
    private final ConfigInfoPersistService configInfoPersistService;
    private final ConfigDetailService configDetailService;
    private final ConfigInfoGrayPersistService configInfoGrayPersistService;
    private final ConfigInfoBetaPersistService configInfoBetaPersistService;
    private final NamespacePersistService namespacePersistService;
    private final ConfigListenerStateDelegate configListenerStateDelegate;
    private final ConfigMigrateService configMigrateService;

    public ConfigControllerV3(ConfigOperationService configOperationService, ConfigInfoPersistService configInfoPersistService, ConfigDetailService configDetailService, ConfigInfoGrayPersistService configInfoGrayPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, NamespacePersistService namespacePersistService, ConfigListenerStateDelegate configListenerStateDelegate, ConfigMigrateService configMigrateService) {
        this.configOperationService = configOperationService;
        this.configInfoPersistService = configInfoPersistService;
        this.configDetailService = configDetailService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.namespacePersistService = namespacePersistService;
        this.configListenerStateDelegate = configListenerStateDelegate;
        this.configMigrateService = configMigrateService;
    }

    @GetMapping
    @TpsControl(pointName="ConfigQuery")
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    public Result<ConfigDetailInfo> getConfig(ConfigFormV3 configForm) throws NacosException {
        configForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        ConfigAllInfo configAllInfo = this.configInfoPersistService.findConfigAllInfo(dataId, groupName, namespaceId);
        if (Objects.isNull(configAllInfo)) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, "Config not exist, please publish Config first.");
        }
        String encryptedDataKey = configAllInfo.getEncryptedDataKey();
        Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)configAllInfo.getContent());
        configAllInfo.setContent((String)pair.getSecond());
        ConfigDetailInfo result = ResponseUtil.transferToConfigDetailInfo(configAllInfo);
        return Result.success((Object)result);
    }

    @PostMapping
    @TpsControl(pointName="ConfigPublish")
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Boolean> publishConfig(HttpServletRequest request, ConfigFormV3 configForm) throws NacosException {
        String encryptedDataKeyFinal;
        configForm.validateWithContent();
        boolean namespaceTransferred = NamespaceUtil.isNeedTransferNamespace((String)configForm.getNamespaceId());
        configForm.setNamespaceId(NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId()));
        ParamUtils.checkParam(configForm.getDataId(), configForm.getGroup(), "datumId", configForm.getContent());
        ParamUtils.checkParamV2(configForm.getTag());
        if (StringUtils.isBlank((CharSequence)configForm.getSrcUser())) {
            configForm.setSrcUser(RequestUtil.getSrcUserName(request));
        }
        if (!ConfigType.isValidType((String)configForm.getType()).booleanValue()) {
            configForm.setType(ConfigType.getDefaultType().getType());
        }
        if (StringUtils.isBlank((CharSequence)(encryptedDataKeyFinal = configForm.getEncryptedDataKey()))) {
            Pair pair = EncryptionHandler.encryptHandler((String)configForm.getDataId(), (String)configForm.getContent());
            configForm.setContent((String)pair.getSecond());
            encryptedDataKeyFinal = (String)pair.getFirst();
        }
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp(request));
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName(request));
        configRequestInfo.setBetaIps(request.getHeader("betaIps"));
        configRequestInfo.setCasMd5(request.getHeader("casMd5"));
        configRequestInfo.setNamespaceTransferred(namespaceTransferred);
        return Result.success((Object)this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKeyFinal));
    }

    @DeleteMapping
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Boolean> deleteConfig(HttpServletRequest request, ConfigFormV3 configForm) throws NacosException {
        configForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String tag = configForm.getTag();
        ParamUtils.checkParamV2(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        return Result.success((Object)this.configOperationService.deleteConfig(configForm.getDataId(), configForm.getGroupName(), namespaceId, tag, clientIp, srcUser, "http"));
    }

    @DeleteMapping(value={"/batch"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Boolean> deleteConfigs(HttpServletRequest request, @RequestParam(value="ids") List<Long> ids) {
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        try {
            for (Long id : ids) {
                ConfigInfo configInfo = this.configInfoPersistService.findConfigInfo(id);
                if (configInfo == null) {
                    LOGGER.warn("[deleteConfigs] configInfo is null, id: {}", (Object)id);
                    continue;
                }
                this.configOperationService.deleteConfig(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), null, clientIp, srcUser, "http");
            }
            return Result.success((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("delete configs based on the IDs list error, IDs: {}", ids, (Object)e);
            return Result.failure((ErrorCode)ErrorCode.SERVER_ERROR);
        }
    }

    @GetMapping(value={"/listener"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<ConfigListenerInfo> getListeners(ConfigFormV3 configForm, AggregationForm aggregationForm) throws Exception {
        configForm.validate();
        aggregationForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        return Result.success((Object)this.configListenerStateDelegate.getListenerState(configForm.getDataId(), configForm.getGroupName(), namespaceId, aggregationForm.isAggregation()));
    }

    @GetMapping(value={"/list"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    public Result<Page<ConfigBasicInfo>> list(ConfigFormV3 configForm, PageForm pageForm, String configDetail, @RequestParam(defaultValue="blur") String search) throws NacosApiException {
        configForm.blurSearchValidate();
        pageForm.validate();
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((String)configForm.getAppName())) {
            configAdvanceInfo.put("appName", configForm.getAppName());
        }
        if (StringUtils.isNotBlank((String)configForm.getConfigTags())) {
            configAdvanceInfo.put("config_tags", configForm.getConfigTags());
        }
        if (StringUtils.isNotBlank((String)configForm.getType())) {
            configAdvanceInfo.put("types", configForm.getType());
        }
        if (StringUtils.isNotBlank((String)configDetail)) {
            configAdvanceInfo.put("content", configDetail);
        }
        int pageNo = pageForm.getPageNo();
        int pageSize = pageForm.getPageSize();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        Page<ConfigInfo> configInfoPage = this.configDetailService.findConfigInfoPage(search, pageNo, pageSize, dataId, groupName, namespaceId, configAdvanceInfo);
        Page result = new Page();
        result.setTotalCount(configInfoPage.getTotalCount());
        result.setPagesAvailable(configInfoPage.getPagesAvailable());
        result.setPageNumber(configInfoPage.getPageNumber());
        result.setPageItems(configInfoPage.getPageItems().stream().map(ResponseUtil::transferToConfigBasicInfo).collect(Collectors.toList()));
        return Result.success((Object)result);
    }

    @DeleteMapping(value={"/beta"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Boolean> stopBeta(HttpServletRequest httpServletRequest, ConfigFormV3 configForm) throws NacosApiException {
        configForm.validate();
        String remoteIp = RequestUtil.getRemoteIp(httpServletRequest);
        String requestIpApp = RequestUtil.getAppName(httpServletRequest);
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        try {
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, groupName, namespaceId, "beta", remoteIp, RequestUtil.getSrcUserName(httpServletRequest));
            this.configMigrateService.removeConfigInfoGrayMigrate(dataId, groupName, namespaceId, "beta", remoteIp, RequestUtil.getSrcUserName(httpServletRequest));
        }
        catch (Throwable e) {
            LOGGER.error("remove beta data error", e);
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)"remove beta data error", (Object)false);
        }
        ConfigTraceService.logPersistenceEvent(dataId, groupName, namespaceId, requestIpApp, System.currentTimeMillis(), remoteIp, "persist-beta", "remove", null);
        if (PropertyUtil.isGrayCompatibleModel()) {
            this.configInfoBetaPersistService.removeConfigInfo4Beta(dataId, groupName, namespaceId);
        }
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(dataId, groupName, namespaceId, "beta", System.currentTimeMillis()));
        return Result.success((Object)true);
    }

    @GetMapping(value={"/beta"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    public Result<ConfigGrayInfo> queryBeta(ConfigFormV3 configForm) throws NacosApiException {
        configForm.validate();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        ConfigInfoGrayWrapper beta4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, groupName, namespaceId, "beta");
        if (Objects.nonNull(beta4Gray)) {
            String encryptedDataKey = beta4Gray.getEncryptedDataKey();
            Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)beta4Gray.getContent());
            beta4Gray.setContent((String)pair.getSecond());
            ConfigGrayInfo result = ResponseUtil.transferToConfigGrayInfo(beta4Gray);
            return Result.success((Object)result);
        }
        throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, "Config is not in beta.");
    }

    @PostMapping(value={"/import"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Map<String, Object>> importAndPublishConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="namespaceId", required=false) String namespaceId, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy, MultipartFile file) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (Objects.isNull(file)) {
            return Result.failure((ErrorCode)ErrorCode.DATA_EMPTY, failedData);
        }
        if (StringUtils.isNotBlank((String)(namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId))) && !NamespaceUtil.isDefaultNamespaceId((String)namespaceId) && this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) <= 0) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.NAMESPACE_NOT_EXIST, failedData);
        }
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(request);
        }
        ArrayList<ConfigAllInfo> configInfoList = new ArrayList<ConfigAllInfo>();
        ArrayList<Map<String, String>> unrecognizedList = new ArrayList<Map<String, String>>();
        try {
            ZipUtils.UnZipResult unziped = ZipUtils.unzip(file.getBytes());
            Result<Map<String, Object>> errorResult = this.parseImportDataV2(srcUser, unziped, configInfoList, unrecognizedList, namespaceId);
            if (errorResult != null) {
                return errorResult;
            }
        }
        catch (IOException e) {
            failedData.put("succCount", 0);
            LOGGER.error("parsing data failed", (Throwable)e);
            return Result.failure((ErrorCode)ErrorCode.PARSING_DATA_FAILED, failedData);
        }
        if (CollectionUtils.isEmpty(configInfoList)) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.DATA_EMPTY, failedData);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.configInfoPersistService.batchInsertOrUpdate(configInfoList, srcUser, srcIp, null, policy);
        for (ConfigInfo configInfo : configInfoList) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), InetUtils.getSelfIP(), "persist", "pub", configInfo.getContent());
        }
        if (!unrecognizedList.isEmpty()) {
            saveResult.put("unrecognizedCount", unrecognizedList.size());
            saveResult.put("unrecognizedData", unrecognizedList);
        }
        return Result.success(saveResult);
    }

    private Result<Map<String, Object>> parseImportDataV2(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespaceId) {
        ZipUtils.ZipItem metaDataItem = unziped.getMetaDataItem();
        String metaData = metaDataItem.getItemData();
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        ConfigMetadata configMetadata = YamlParserUtil.loadObject(metaData, ConfigMetadata.class);
        if (configMetadata == null || CollectionUtils.isEmpty(configMetadata.getMetadata())) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.METADATA_ILLEGAL, failedData);
        }
        List<ConfigMetadata.ConfigExportItem> configExportItems = configMetadata.getMetadata();
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            if (!StringUtils.isBlank((CharSequence)configExportItem.getDataId()) && !StringUtils.isBlank((CharSequence)configExportItem.getGroup()) && !StringUtils.isBlank((CharSequence)configExportItem.getType())) continue;
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.METADATA_ILLEGAL, failedData);
        }
        List<ZipUtils.ZipItem> zipItemList = unziped.getZipItemList();
        Set metaDataKeys = configExportItems.stream().map(metaItem -> GroupKey.getKey(metaItem.getDataId(), metaItem.getGroup())).collect(Collectors.toSet());
        HashMap configContentMap = new HashMap(zipItemList.size());
        int itemNameLength = 2;
        zipItemList.forEach(item -> {
            String itemName = item.getItemName();
            String[] groupAdnDataId = itemName.split("/");
            if (groupAdnDataId.length != itemNameLength) {
                HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                unrecognizedItem.put("itemName", item.getItemName());
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String dataId = groupAdnDataId[1];
            String group = groupAdnDataId[0];
            String key = GroupKey.getKey(dataId, group);
            if (!metaDataKeys.contains(key)) {
                HashMap<String, CallSite> unrecognizedItem = new HashMap<String, CallSite>(2);
                unrecognizedItem.put("itemName", (CallSite)((Object)("Item not found in metadata: " + item.getItemName())));
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String itemData = item.getItemData();
            configContentMap.put(key, itemData);
        });
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            String group;
            String dataId = configExportItem.getDataId();
            String content = (String)configContentMap.get(GroupKey.getKey(dataId, group = configExportItem.getGroup()));
            if (content == null) {
                HashMap<String, CallSite> unrecognizedItem = new HashMap<String, CallSite>(2);
                unrecognizedItem.put("itemName", (CallSite)((Object)("Item not found in file: " + group + "/" + dataId)));
                unrecognizedList.add(unrecognizedItem);
                continue;
            }
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            content = (String)pair.getSecond();
            ConfigAllInfo ci = new ConfigAllInfo();
            ci.setGroup(group);
            ci.setDataId(dataId);
            ci.setContent(content);
            ci.setType(configExportItem.getType());
            ci.setDesc(configExportItem.getDesc());
            ci.setAppName(configExportItem.getAppName());
            ci.setTenant(namespaceId);
            ci.setEncryptedDataKey((String)pair.getFirst());
            ci.setCreateUser(srcUser);
            configInfoList.add(ci);
        }
        return null;
    }

    @GetMapping(value={"/export"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    public ResponseEntity<byte[]> exportConfig(ConfigFormV3 configForm, @RequestParam(value="ids", required=false) List<Long> ids) throws NacosApiException {
        configForm.blurSearchValidate();
        ids.removeAll(Collections.singleton(null));
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        List<ConfigAllInfo> dataList = this.configInfoPersistService.findAllConfigInfo4Export(configForm.getDataId(), configForm.getGroupName(), namespaceId, configForm.getAppName(), ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        ArrayList<ConfigMetadata.ConfigExportItem> configMetadataItems = new ArrayList<ConfigMetadata.ConfigExportItem>();
        for (ConfigAllInfo ci : dataList) {
            ConfigMetadata.ConfigExportItem configMetadataItem = new ConfigMetadata.ConfigExportItem();
            configMetadataItem.setAppName(ci.getAppName());
            configMetadataItem.setDataId(ci.getDataId());
            configMetadataItem.setDesc(ci.getDesc());
            configMetadataItem.setGroup(ci.getGroup());
            configMetadataItem.setType(ci.getType());
            configMetadataItems.add(configMetadataItem);
            Pair pair = EncryptionHandler.decryptHandler((String)ci.getDataId(), (String)ci.getEncryptedDataKey(), (String)ci.getContent());
            String itemName = ci.getGroup() + "/" + ci.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, (String)pair.getSecond()));
        }
        ConfigMetadata configMetadata = new ConfigMetadata();
        configMetadata.setMetadata(configMetadataItems);
        zipItemList.add(new ZipUtils.ZipItem(".metadata.yml", YamlParserUtil.dumpObject(configMetadata)));
        HttpHeaders headers = new HttpHeaders();
        String fileName = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/clone"})
    @Secured(resource="/v3/admin/cs/config", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Map<String, Object>> cloneConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="namespaceId") String namespaceId, @RequestBody List<ConfigCloneInfo> cloneInfos, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (CollectionUtils.isEmpty(cloneInfos)) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.NO_SELECTED_CONFIG, failedData);
        }
        cloneInfos.removeAll(Collections.singleton(null));
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        if (StringUtils.isNotBlank((String)namespaceId) && !NamespaceUtil.isDefaultNamespaceId((String)namespaceId) && this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) <= 0) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<Long> idList = new ArrayList<Long>(cloneInfos.size());
        Map<Long, ConfigCloneInfo> configBeansMap = cloneInfos.stream().collect(Collectors.toMap(ConfigCloneInfo::getConfigId, cfg -> {
            idList.add(cfg.getConfigId());
            return cfg;
        }, (k1, k2) -> k1));
        List<ConfigAllInfo> queryedDataList = this.configInfoPersistService.findAllConfigInfo4Export(null, null, null, null, idList);
        if (queryedDataList == null || queryedDataList.isEmpty()) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.DATA_EMPTY, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList4Clone = new ArrayList<ConfigAllInfo>(queryedDataList.size());
        for (ConfigAllInfo ci : queryedDataList) {
            ConfigCloneInfo paramBean = configBeansMap.get(ci.getId());
            ConfigAllInfo ci4save = new ConfigAllInfo();
            ci4save.setTenant(namespaceId);
            ci4save.setType(ci.getType());
            ci4save.setGroup(paramBean != null && StringUtils.isNotBlank((String)paramBean.getTargetGroupName()) ? paramBean.getTargetGroupName() : ci.getGroup());
            ci4save.setDataId(paramBean != null && StringUtils.isNotBlank((String)paramBean.getTargetDataId()) ? paramBean.getTargetDataId() : ci.getDataId());
            ci4save.setContent(ci.getContent());
            if (StringUtils.isNotBlank((String)ci.getAppName())) {
                ci4save.setAppName(ci.getAppName());
            }
            ci4save.setDesc(ci.getDesc());
            ci4save.setEncryptedDataKey(ci.getEncryptedDataKey() == null ? "" : ci.getEncryptedDataKey());
            configInfoList4Clone.add(ci4save);
        }
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(request);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.configInfoPersistService.batchInsertOrUpdate(configInfoList4Clone, srcUser, srcIp, null, policy);
        for (ConfigInfo configInfo : configInfoList4Clone) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), InetUtils.getSelfIP(), "persist", "pub", configInfo.getContent());
        }
        return Result.success(saveResult);
    }
}

