/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.model.core.IResultCode;
import com.alibaba.nacos.common.utils.DateFormatUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.enums.ApiVersionEnum;
import com.alibaba.nacos.config.server.exception.ConfigAlreadyExistsException;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigListenState;
import com.alibaba.nacos.config.server.model.ConfigMetadata;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.GroupkeyListenserStatus;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.gray.GrayRuleManager;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.paramcheck.ConfigBlurSearchHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigListenerHttpParamExtractor;
import com.alibaba.nacos.config.server.result.code.ResultCodeEnum;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.ConfigSubService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.YamlParserUtil;
import com.alibaba.nacos.config.server.utils.ZipUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Deprecated
@RestController
@RequestMapping(value={"/v1/cs/configs"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConfigController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigController.class);
    private static final String EXPORT_CONFIG_FILE_NAME = "nacos_config_export_";
    private static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";
    private static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyyMMddHHmmss";
    private final ConfigServletInner inner;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoGrayPersistService configInfoGrayPersistService;
    private NamespacePersistService namespacePersistService;
    private final ConfigOperationService configOperationService;
    private final ConfigSubService configSubService;

    public ConfigController(ConfigServletInner inner, ConfigOperationService configOperationService, ConfigSubService configSubService, ConfigInfoPersistService configInfoPersistService, NamespacePersistService namespacePersistService, ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.inner = inner;
        this.configOperationService = configOperationService;
        this.configSubService = configSubService;
        this.configInfoPersistService = configInfoPersistService;
        this.namespacePersistService = namespacePersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    @PostMapping
    @TpsControl(pointName="ConfigPublish")
    @Secured(action=ActionTypes.WRITE, signType="config")
    @Compatibility(apiType=ApiType.OPEN_API, alternatives="POST ${contextPath:nacos}/v3/admin/cs/config")
    public Boolean publishConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="content") String content, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="desc", required=false) String desc, @RequestParam(value="use", required=false) String use, @RequestParam(value="effect", required=false) String effect, @RequestParam(value="type", required=false) String type, @RequestParam(value="schema", required=false) String schema, @RequestParam(required=false) String encryptedDataKey) throws NacosException {
        String encryptedDataKeyFinal = null;
        if (StringUtils.isNotBlank((String)encryptedDataKey)) {
            encryptedDataKeyFinal = encryptedDataKey;
        } else {
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            content = (String)pair.getSecond();
            encryptedDataKeyFinal = (String)pair.getFirst();
        }
        boolean namespaceTransferred = NamespaceUtil.isNeedTransferNamespace((String)tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", content);
        ParamUtils.checkParam(tag);
        ConfigForm configForm = new ConfigForm();
        configForm.setDataId(dataId);
        configForm.setGroup(group);
        configForm.setNamespaceId(tenant);
        configForm.setContent(content);
        configForm.setTag(tag);
        configForm.setAppName(appName);
        configForm.setSrcUser(srcUser);
        configForm.setConfigTags(configTags);
        configForm.setDesc(desc);
        configForm.setUse(use);
        configForm.setEffect(effect);
        configForm.setType(type);
        configForm.setSchema(schema);
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            configForm.setSrcUser(RequestUtil.getSrcUserName(request));
        }
        if (!ConfigType.isValidType((String)type).booleanValue()) {
            configForm.setType(ConfigType.getDefaultType().getType());
        }
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp(request));
        configRequestInfo.setSrcType("http");
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName(request));
        configRequestInfo.setBetaIps(request.getHeader("betaIps"));
        configRequestInfo.setCasMd5(request.getHeader("casMd5"));
        configRequestInfo.setNamespaceTransferred(namespaceTransferred);
        return this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKeyFinal);
    }

    @GetMapping
    @TpsControl(pointName="ConfigQuery")
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.OPEN_API, alternatives="GET ${contextPath:nacos}/v3/client/cs/config")
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws IOException, ServletException, NacosException {
        ParamUtils.checkTenant(tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String isNotify = request.getHeader("notify");
        this.inner.doGetConfig(request, response, dataId, group, tenant, tag, isNotify, clientIp, ApiVersionEnum.V1);
    }

    @GetMapping(params={"show=all"})
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config")
    public ConfigAllInfo detailConfigInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) throws NacosException {
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ConfigAllInfo configAllInfo = this.configInfoPersistService.findConfigAllInfo(dataId, group, tenant);
        if (Objects.nonNull(configAllInfo)) {
            String encryptedDataKey = configAllInfo.getEncryptedDataKey();
            Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)configAllInfo.getContent());
            configAllInfo.setContent((String)pair.getSecond());
        }
        return configAllInfo;
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="config")
    @Compatibility(apiType=ApiType.OPEN_API, alternatives="DELETE ${contextPath:nacos}/v3/admin/cs/config")
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        return this.configOperationService.deleteConfig(dataId, group, tenant, tag, clientIp, srcUser, "http");
    }

    @DeleteMapping(params={"delType=ids"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/batchDelete")
    public RestResult<Boolean> deleteConfigs(HttpServletRequest request, @RequestParam(value="ids") List<Long> ids) {
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        try {
            for (Long id : ids) {
                ConfigInfo configInfo = this.configInfoPersistService.findConfigInfo(id);
                if (configInfo == null) {
                    LOGGER.warn("[deleteConfigs] configInfo is null, id: {}", (Object)id);
                    continue;
                }
                this.configOperationService.deleteConfig(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), null, clientIp, srcUser, "http");
            }
            return RestResultUtils.success((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("delete configs based on the IDs list error, IDs: {}", ids, (Object)e);
            return RestResultUtils.failed((String)e.getMessage());
        }
    }

    @GetMapping(value={"/catalog"})
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/cs/config")
    public RestResult<ConfigAdvanceInfo> getConfigAdvanceInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ConfigAdvanceInfo configInfo = this.configInfoPersistService.findConfigAdvanceInfo(dataId, group, tenant);
        return RestResultUtils.success((Object)configInfo);
    }

    @PostMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigListenerHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.OPEN_API)
    public void listener(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, ConfigListenState> clientMd5Map;
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        String probeModify = request.getParameter("Listening-Configs");
        if (StringUtils.isBlank((CharSequence)probeModify)) {
            LOGGER.warn("invalid probeModify is blank");
            throw new IllegalArgumentException("invalid probeModify");
        }
        probeModify = URLDecoder.decode(probeModify, "UTF-8");
        try {
            clientMd5Map = MD5Util.getClientMd5Map(probeModify);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        this.inner.doPollingConfig(request, response, clientMd5Map, probeModify.length());
    }

    @GetMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/listener")
    public GroupkeyListenserStatus getListeners(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, @RequestParam(value="sampleTime", required=false, defaultValue="1") int sampleTime) throws Exception {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        SampleResult collectSampleResult = this.configSubService.getCollectSampleResult(dataId, group, tenant, sampleTime);
        GroupkeyListenserStatus gls = new GroupkeyListenserStatus();
        gls.setCollectStatus(200);
        if (collectSampleResult.getLisentersGroupkeyStatus() != null) {
            gls.setLisentersGroupkeyStatus(collectSampleResult.getLisentersGroupkeyStatus());
        }
        return gls;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/list")
    public Page<ConfigInfo> searchConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((String)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        try {
            return this.configInfoPersistService.findConfigInfo4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @GetMapping(params={"search=blur"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/list")
    public Page<ConfigInfo> fuzzySearchConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="types", required=false) String types, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        MetricsMonitor.getFuzzySearchMonitor().incrementAndGet();
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(50);
        if (StringUtils.isNotBlank((String)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        if (StringUtils.isNotBlank((String)types)) {
            configAdvanceInfo.put("types", types);
        }
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        try {
            return this.configInfoPersistService.findConfigInfoLike4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @DeleteMapping(params={"beta=true"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="DELETE ${contextPath:nacos}/v3/console/cs/config/beta")
    public RestResult<Boolean> stopBeta(HttpServletRequest httpServletRequest, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="srcUser", required=false, defaultValue="") String srcUser) {
        String remoteIp = RequestUtil.getRemoteIp(httpServletRequest);
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(httpServletRequest);
        }
        String requestIpApp = RequestUtil.getAppName(httpServletRequest);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        try {
            this.configOperationService.deleteConfig(dataId, group, tenant, "beta", remoteIp, srcUser, "http");
        }
        catch (Throwable e) {
            LOGGER.error("remove beta data error", e);
            return RestResultUtils.failed((int)500, (Object)false, (String)"remove beta data error");
        }
        return RestResultUtils.success((String)"stop beta ok", (Object)true);
    }

    @GetMapping(params={"beta=true"})
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/beta")
    public RestResult<ConfigInfo4Beta> queryBeta(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        try {
            tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
            ConfigInfo4Beta configInfo4Beta = null;
            ConfigInfoGrayWrapper beta4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "beta");
            if (Objects.nonNull(beta4Gray)) {
                String encryptedDataKey = beta4Gray.getEncryptedDataKey();
                Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)beta4Gray.getContent());
                beta4Gray.setContent((String)pair.getSecond());
                configInfo4Beta = new ConfigInfo4Beta();
                BeanUtils.copyProperties((Object)beta4Gray, (Object)configInfo4Beta);
                configInfo4Beta.setBetaIps(GrayRuleManager.deserializeConfigGrayPersistInfo(beta4Gray.getGrayRule()).getExpr());
            }
            return RestResultUtils.success((String)"query beta ok", configInfo4Beta);
        }
        catch (Throwable e) {
            LOGGER.error("query beta data error", e);
            return RestResultUtils.failed((String)"query beta data error");
        }
    }

    @GetMapping(params={"export=true"})
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/export")
    public ResponseEntity<byte[]> exportConfig(@RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="ids", required=false) List<Long> ids) {
        ids.removeAll(Collections.singleton(null));
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        List<ConfigAllInfo> dataList = this.configInfoPersistService.findAllConfigInfo4Export(dataId, group, tenant, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        StringBuilder metaData = null;
        for (ConfigInfo configInfo : dataList) {
            if (StringUtils.isNotBlank((String)configInfo.getAppName())) {
                Object metaDataId;
                if (metaData == null) {
                    metaData = new StringBuilder();
                }
                if (((String)(metaDataId = configInfo.getDataId())).contains(".")) {
                    metaDataId = ((String)metaDataId).substring(0, ((String)metaDataId).lastIndexOf(".")) + "~" + ((String)metaDataId).substring(((String)metaDataId).lastIndexOf(".") + 1);
                }
                metaData.append(configInfo.getGroup()).append('.').append((String)metaDataId).append(".app=").append(configInfo.getAppName()).append("\r\n");
            }
            Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
            String itemName = configInfo.getGroup() + "/" + configInfo.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, (String)pair.getSecond()));
        }
        if (metaData != null) {
            zipItemList.add(new ZipUtils.ZipItem(".meta.yml", metaData.toString()));
        }
        HttpHeaders headers = new HttpHeaders();
        String string = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + string);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(params={"exportV2=true"})
    @Secured(action=ActionTypes.READ, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/export2")
    public ResponseEntity<byte[]> exportConfigV2(@RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="ids", required=false) List<Long> ids) {
        ids.removeAll(Collections.singleton(null));
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        List<ConfigAllInfo> dataList = this.configInfoPersistService.findAllConfigInfo4Export(dataId, group, tenant, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        ArrayList<ConfigMetadata.ConfigExportItem> configMetadataItems = new ArrayList<ConfigMetadata.ConfigExportItem>();
        for (ConfigAllInfo ci : dataList) {
            ConfigMetadata.ConfigExportItem configMetadataItem = new ConfigMetadata.ConfigExportItem();
            configMetadataItem.setAppName(ci.getAppName());
            configMetadataItem.setDataId(ci.getDataId());
            configMetadataItem.setDesc(ci.getDesc());
            configMetadataItem.setGroup(ci.getGroup());
            configMetadataItem.setType(ci.getType());
            configMetadataItem.setConfigTags(ci.getConfigTags());
            configMetadataItems.add(configMetadataItem);
            Pair pair = EncryptionHandler.decryptHandler((String)ci.getDataId(), (String)ci.getEncryptedDataKey(), (String)ci.getContent());
            String itemName = ci.getGroup() + "/" + ci.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, (String)pair.getSecond()));
        }
        ConfigMetadata configMetadata = new ConfigMetadata();
        configMetadata.setMetadata(configMetadataItems);
        zipItemList.add(new ZipUtils.ZipItem(".metadata.yml", YamlParserUtil.dumpObject(configMetadata)));
        HttpHeaders headers = new HttpHeaders();
        String fileName = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(params={"import=true"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/import")
    public RestResult<Map<String, Object>> importAndPublishConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="namespace", required=false) String namespace, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy, MultipartFile file) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (Objects.isNull(file)) {
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        boolean namespaceTransferred = NamespaceUtil.isNeedTransferNamespace((String)namespace);
        if (StringUtils.isNotBlank((String)(namespace = NamespaceUtil.processNamespaceParameter((String)namespace))) && this.namespacePersistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(request);
        }
        ArrayList<ConfigAllInfo> configInfoList = new ArrayList<ConfigAllInfo>();
        ArrayList<Map<String, String>> unrecognizedList = new ArrayList<Map<String, String>>();
        try {
            ZipUtils.UnZipResult unziped = ZipUtils.unzip(file.getBytes());
            ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
            RestResult<Map<String, Object>> errorResult = metaDataZipItem != null && ".metadata.yml".equals(metaDataZipItem.getItemName()) ? this.parseImportDataV2(srcUser, unziped, configInfoList, unrecognizedList, namespace) : this.parseImportData(srcUser, unziped, configInfoList, unrecognizedList, namespace);
            if (errorResult != null) {
                return errorResult;
            }
        }
        catch (IOException e) {
            failedData.put("succCount", 0);
            LOGGER.error("parsing data failed", (Throwable)e);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.PARSING_DATA_FAILED, failedData);
        }
        if (CollectionUtils.isEmpty(configInfoList)) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        Map<String, Object> saveResult = this.batchImportAndPublishConfigs(configInfoList, request, srcUser, namespace, namespaceTransferred, policy);
        if (!unrecognizedList.isEmpty()) {
            saveResult.put("unrecognizedCount", unrecognizedList.size());
            saveResult.put("unrecognizedData", unrecognizedList);
        }
        return RestResultUtils.success((String)"import success", saveResult);
    }

    private RestResult<Map<String, Object>> parseImportData(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespace) {
        List<ZipUtils.ZipItem> itemList;
        ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
        HashMap<String, String> metaDataMap = new HashMap<String, String>(16);
        if (metaDataZipItem != null) {
            String metaDataStr = metaDataZipItem.getItemData().replaceAll("[\r\n]+", "|");
            String[] metaDataArr = metaDataStr.split("\\|");
            HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
            for (String metaDataItem : metaDataArr) {
                String[] metaDataItemArr = metaDataItem.split("=");
                if (metaDataItemArr.length != 2) {
                    failedData.put("succCount", 0);
                    return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
                }
                metaDataMap.put(metaDataItemArr[0], metaDataItemArr[1]);
            }
        }
        if ((itemList = unziped.getZipItemList()) != null && !itemList.isEmpty()) {
            for (ZipUtils.ZipItem item : itemList) {
                String[] groupAdnDataId = item.getItemName().split("/");
                if (groupAdnDataId.length != 2) {
                    HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                    unrecognizedItem.put("itemName", item.getItemName());
                    unrecognizedList.add(unrecognizedItem);
                    continue;
                }
                String group = groupAdnDataId[0];
                String dataId = groupAdnDataId[1];
                Object tempDataId = dataId;
                if (((String)tempDataId).contains(".")) {
                    tempDataId = ((String)tempDataId).substring(0, ((String)tempDataId).lastIndexOf(".")) + "~" + ((String)tempDataId).substring(((String)tempDataId).lastIndexOf(".") + 1);
                }
                String metaDataId = group + "." + (String)tempDataId + ".app";
                String content = item.getItemData();
                Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
                content = (String)pair.getSecond();
                ConfigAllInfo ci = new ConfigAllInfo();
                ci.setGroup(group);
                ci.setDataId(dataId);
                ci.setContent(content);
                if (metaDataMap.get(metaDataId) != null) {
                    ci.setAppName((String)metaDataMap.get(metaDataId));
                }
                ci.setTenant(namespace);
                ci.setEncryptedDataKey((String)pair.getFirst());
                ci.setCreateUser(srcUser);
                configInfoList.add(ci);
            }
        }
        return null;
    }

    private RestResult<Map<String, Object>> parseImportDataV2(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespace) {
        ZipUtils.ZipItem metaDataItem = unziped.getMetaDataItem();
        String metaData = metaDataItem.getItemData();
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        ConfigMetadata configMetadata = YamlParserUtil.loadObject(metaData, ConfigMetadata.class);
        if (configMetadata == null || CollectionUtils.isEmpty(configMetadata.getMetadata())) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
        }
        List<ConfigMetadata.ConfigExportItem> configExportItems = configMetadata.getMetadata();
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            if (!StringUtils.isBlank((CharSequence)configExportItem.getDataId()) && !StringUtils.isBlank((CharSequence)configExportItem.getGroup()) && !StringUtils.isBlank((CharSequence)configExportItem.getType())) continue;
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
        }
        List<ZipUtils.ZipItem> zipItemList = unziped.getZipItemList();
        Set metaDataKeys = configExportItems.stream().map(metaItem -> GroupKey.getKey(metaItem.getDataId(), metaItem.getGroup())).collect(Collectors.toSet());
        HashMap configContentMap = new HashMap(zipItemList.size());
        int itemNameLength = 2;
        zipItemList.forEach(item -> {
            String itemName = item.getItemName();
            String[] groupAdnDataId = itemName.split("/");
            if (groupAdnDataId.length != itemNameLength) {
                HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                unrecognizedItem.put("itemName", item.getItemName());
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String dataId = groupAdnDataId[1];
            String group = groupAdnDataId[0];
            String key = GroupKey.getKey(dataId, group);
            if (!metaDataKeys.contains(key)) {
                HashMap<String, CallSite> unrecognizedItem = new HashMap<String, CallSite>(2);
                unrecognizedItem.put("itemName", (CallSite)((Object)("\u672a\u5728\u5143\u6570\u636e\u4e2d\u627e\u5230: " + item.getItemName())));
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String itemData = item.getItemData();
            configContentMap.put(key, itemData);
        });
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            String group;
            String dataId = configExportItem.getDataId();
            String content = (String)configContentMap.get(GroupKey.getKey(dataId, group = configExportItem.getGroup()));
            if (content == null) {
                HashMap<String, CallSite> unrecognizedItem = new HashMap<String, CallSite>(2);
                unrecognizedItem.put("itemName", (CallSite)((Object)("\u672a\u5728\u6587\u4ef6\u4e2d\u627e\u5230: " + group + "/" + dataId)));
                unrecognizedList.add(unrecognizedItem);
                continue;
            }
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            content = (String)pair.getSecond();
            ConfigAllInfo ci = new ConfigAllInfo();
            ci.setGroup(group);
            ci.setDataId(dataId);
            ci.setContent(content);
            ci.setType(configExportItem.getType());
            ci.setDesc(configExportItem.getDesc());
            ci.setAppName(configExportItem.getAppName());
            ci.setTenant(namespace);
            ci.setEncryptedDataKey((String)pair.getFirst());
            ci.setCreateUser(srcUser);
            ci.setConfigTags(configExportItem.getConfigTags());
            configInfoList.add(ci);
        }
        return null;
    }

    @PostMapping(params={"clone=true"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/cs/config/clone")
    public RestResult<Map<String, Object>> cloneConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="tenant") String namespace, @RequestBody List<SameNamespaceCloneConfigBean> configBeansList, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (CollectionUtils.isEmpty(configBeansList)) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NO_SELECTED_CONFIG, failedData);
        }
        configBeansList.removeAll(Collections.singleton(null));
        boolean namespaceTransferred = NamespaceUtil.isNeedTransferNamespace((String)namespace);
        namespace = NamespaceUtil.processNamespaceParameter((String)namespace);
        if (StringUtils.isNotBlank((String)namespace) && this.namespacePersistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<Long> idList = new ArrayList<Long>(configBeansList.size());
        Map<Long, SameNamespaceCloneConfigBean> configBeansMap = configBeansList.stream().collect(Collectors.toMap(SameNamespaceCloneConfigBean::getCfgId, cfg -> {
            idList.add(cfg.getCfgId());
            return cfg;
        }, (k1, k2) -> k1));
        List<ConfigAllInfo> queryedDataList = this.configInfoPersistService.findAllConfigInfo4Export(null, null, null, null, idList);
        if (queryedDataList == null || queryedDataList.isEmpty()) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList4Clone = new ArrayList<ConfigAllInfo>(queryedDataList.size());
        for (ConfigAllInfo ci : queryedDataList) {
            SameNamespaceCloneConfigBean paramBean = configBeansMap.get(ci.getId());
            ConfigAllInfo ci4save = new ConfigAllInfo();
            ci4save.setType(ci.getType());
            ci4save.setGroup(paramBean != null && StringUtils.isNotBlank((String)paramBean.getGroup()) ? paramBean.getGroup() : ci.getGroup());
            ci4save.setDataId(paramBean != null && StringUtils.isNotBlank((String)paramBean.getDataId()) ? paramBean.getDataId() : ci.getDataId());
            ci4save.setContent(ci.getContent());
            if (StringUtils.isNotBlank((String)ci.getAppName())) {
                ci4save.setAppName(ci.getAppName());
            }
            ci4save.setDesc(ci.getDesc());
            ci4save.setEncryptedDataKey(ci.getEncryptedDataKey() == null ? "" : ci.getEncryptedDataKey());
            ParamUtils.checkParam(ci4save.getDataId(), ci4save.getGroup(), "datumId", ci4save.getContent());
            configInfoList4Clone.add(ci4save);
        }
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(request);
        }
        Map<String, Object> saveResult = this.batchImportAndPublishConfigs(configInfoList4Clone, request, srcUser, namespace, namespaceTransferred, policy);
        return RestResultUtils.success((String)"Clone Completed Successfully", saveResult);
    }

    private Map<String, Object> batchImportAndPublishConfigs(List<ConfigAllInfo> configAllInfoList, HttpServletRequest request, String srcUser, String targetNamespaceId, boolean namespaceTransferred, SameConfigPolicy sameConfigPolicy) throws NacosException {
        HashMap<String, Object> saveResult = new HashMap<String, Object>(16);
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = new ArrayList();
        ArrayList skipData = new ArrayList();
        for (int i = 0; i < configAllInfoList.size(); ++i) {
            ConfigAllInfo configAllInfo = configAllInfoList.get(i);
            ConfigForm configForm = this.transferToConfigForm(configAllInfo, srcUser, targetNamespaceId);
            ConfigRequestInfo configRequestInfo = this.transferToConfigRequestInfo(request);
            configRequestInfo.setNamespaceTransferred(namespaceTransferred);
            if (sameConfigPolicy != SameConfigPolicy.OVERWRITE) {
                configRequestInfo.setUpdateForExist(false);
            }
            try {
                this.configOperationService.publishConfig(configForm, configRequestInfo, configAllInfo.getEncryptedDataKey());
                ++succCount;
                continue;
            }
            catch (ConfigAlreadyExistsException ex) {
                if (SameConfigPolicy.SKIP == sameConfigPolicy) {
                    ++skipCount;
                    HashMap<String, String> skipItem = new HashMap<String, String>(2);
                    skipItem.put("dataId", configAllInfo.getDataId());
                    skipItem.put("group", configAllInfo.getGroup());
                    skipData.add(skipItem);
                    continue;
                }
                if (SameConfigPolicy.ABORT != sameConfigPolicy) continue;
                HashMap<String, String> failedItem = new HashMap<String, String>(2);
                failedItem.put("dataId", configAllInfo.getDataId());
                failedItem.put("group", configAllInfo.getGroup());
                failData.add(failedItem);
                for (int j = i + 1; j < configAllInfoList.size(); ++j) {
                    ConfigAllInfo skipConfigInfo = configAllInfoList.get(j);
                    HashMap<String, String> skipitem = new HashMap<String, String>(2);
                    skipitem.put("dataId", skipConfigInfo.getDataId());
                    skipitem.put("group", skipConfigInfo.getGroup());
                    skipData.add(skipitem);
                    ++skipCount;
                }
                break;
            }
        }
        saveResult.put("succCount", succCount);
        saveResult.put("skipCount", skipCount);
        if (!failData.isEmpty()) {
            saveResult.put("failData", failData);
        }
        if (!skipData.isEmpty()) {
            saveResult.put("skipData", skipData);
        }
        return saveResult;
    }

    private ConfigForm transferToConfigForm(ConfigAllInfo configInfo, String srcUser, String targetNamespaceId) {
        ConfigForm configForm = new ConfigForm();
        configForm.setDataId(configInfo.getDataId());
        configForm.setGroup(configInfo.getGroup());
        configForm.setNamespaceId(targetNamespaceId);
        configForm.setContent(configInfo.getContent());
        configForm.setAppName(configInfo.getAppName());
        configForm.setConfigTags(configInfo.getConfigTags());
        configForm.setDesc(configInfo.getDesc());
        configForm.setUse(configInfo.getUse());
        configForm.setEffect(configInfo.getEffect());
        configForm.setType(configInfo.getType());
        configForm.setSchema(configInfo.getSchema());
        configForm.setEncryptedDataKey(configInfo.getEncryptedDataKey());
        configForm.setSrcUser(srcUser);
        return configForm;
    }

    private ConfigRequestInfo transferToConfigRequestInfo(HttpServletRequest request) {
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp(request));
        configRequestInfo.setSrcType("http");
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName(request));
        return configRequestInfo;
    }
}

