/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConfigChangeConfigs;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.plugin.config.ConfigChangePluginManager;
import com.alibaba.nacos.plugin.config.constants.ConfigChangeExecuteTypes;
import com.alibaba.nacos.plugin.config.constants.ConfigChangePointCutTypes;
import com.alibaba.nacos.plugin.config.model.ConfigChangeRequest;
import com.alibaba.nacos.plugin.config.model.ConfigChangeResponse;
import com.alibaba.nacos.plugin.config.spi.ConfigChangePluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ConfigChangeAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChangeAspect.class);
    private static final Integer DEFAULT_BEFORE_LIST_CAPACITY = 2;
    private static final Integer DEFAULT_AFTER_LIST_CAPACITY = 1;
    private static final String ENABLED = "enabled";
    private static final String PUBLISH_CONFIG = "execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.publishConfig(..))";
    private static final String DELETE_CONFIG = "execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.deleteConfig(..))";
    private final ConfigChangeConfigs configChangeConfigs;

    public ConfigChangeAspect(ConfigChangeConfigs configChangeConfigs) {
        this.configChangeConfigs = configChangeConfigs;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.publishConfig(..))")
    Object publishOrUpdateConfigAround(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        ConfigForm configForm = (ConfigForm)args[0];
        ConfigRequestInfo configRequestInfo = (ConfigRequestInfo)args[1];
        String dataId = configForm.getDataId();
        String group = configForm.getGroup();
        String namespaceId = configForm.getNamespaceId();
        String content = configForm.getContent();
        String desc = configForm.getDesc();
        String use = configForm.getUse();
        String effect = configForm.getEffect();
        String type = configForm.getType();
        String tag = configForm.getTag();
        String configTags = configForm.getConfigTags();
        String requestIpApp = configRequestInfo.getRequestIpApp();
        String scrIp = configRequestInfo.getSrcIp();
        String scrType = configRequestInfo.getSrcType();
        String betaIps = configRequestInfo.getBetaIps();
        Object grayName = null;
        String grayRuleExp = null;
        if (StringUtils.isNotBlank((String)betaIps)) {
            grayName = "beta";
            grayRuleExp = betaIps;
        } else if (StringUtils.isNotBlank((String)tag)) {
            grayName = "tag_" + configForm.getTag();
            grayRuleExp = tag;
        }
        ConfigChangePointCutTypes configChangePointCutType = null;
        configChangePointCutType = "http".equals(scrType) ? ConfigChangePointCutTypes.PUBLISH_BY_HTTP : ConfigChangePointCutTypes.PUBLISH_BY_RPC;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)dataId);
        configChangeRequest.setArg("group", (Object)group);
        configChangeRequest.setArg("namespaceId", (Object)namespaceId);
        configChangeRequest.setArg("content", (Object)content);
        configChangeRequest.setArg("tag", (Object)tag);
        configChangeRequest.setArg("requestIpApp", (Object)requestIpApp);
        configChangeRequest.setArg("srcIp", (Object)scrIp);
        configChangeRequest.setArg("configTags", (Object)configTags);
        configChangeRequest.setArg("desc", (Object)desc);
        configChangeRequest.setArg("use", (Object)use);
        configChangeRequest.setArg("effect", (Object)effect);
        configChangeRequest.setArg("type", (Object)type);
        configChangeRequest.setArg("grayName", grayName);
        configChangeRequest.setArg("grayRuleExp", (Object)grayRuleExp);
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.deleteConfig(..))")
    Object removeConfigByIdAround(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        String dataId = (String)args[0];
        String group = (String)args[1];
        String namespaceId = (String)args[2];
        String grayName = (String)args[3];
        String srcIp = (String)args[4];
        String srcUser = (String)args[5];
        String scrType = (String)args[6];
        ConfigChangePointCutTypes configChangePointCutType = null;
        configChangePointCutType = "http".equals(scrType) ? ConfigChangePointCutTypes.PUBLISH_BY_HTTP : ConfigChangePointCutTypes.PUBLISH_BY_RPC;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)dataId);
        configChangeRequest.setArg("group", (Object)group);
        configChangeRequest.setArg("namespaceId", (Object)namespaceId);
        configChangeRequest.setArg("srcIp", (Object)srcIp);
        configChangeRequest.setArg("srcUser", (Object)srcUser);
        configChangeRequest.setArg("grayName", (Object)grayName);
        configChangeRequest.setArg("modifyTime", (Object)TimeUtils.getCurrentTimeStr());
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    private Object configChangeServiceHandle(ProceedingJoinPoint pjp, List<ConfigChangePluginService> configChangePluginServiceList, ConfigChangeRequest configChangeRequest) {
        ConfigChangePointCutTypes handleType = configChangeRequest.getRequestType();
        ConfigChangeResponse configChangeResponse = new ConfigChangeResponse(handleType);
        configChangeResponse.setSuccess(true);
        ArrayList<ConfigChangePluginService> beforeExecutePluginServices = new ArrayList<ConfigChangePluginService>(DEFAULT_BEFORE_LIST_CAPACITY);
        ArrayList<ConfigChangePluginService> afterExecutePluginServices = new ArrayList<ConfigChangePluginService>(DEFAULT_AFTER_LIST_CAPACITY);
        Object retVal = null;
        Object[] args = pjp.getArgs();
        configChangeRequest.setArg("originalArgs", (Object)args);
        for (ConfigChangePluginService ccs : configChangePluginServiceList) {
            if (!this.isEnabled(ccs)) continue;
            if (ConfigChangeExecuteTypes.EXECUTE_BEFORE_TYPE.equals(ccs.executeType())) {
                beforeExecutePluginServices.add(ccs);
                continue;
            }
            afterExecutePluginServices.add(ccs);
        }
        for (ConfigChangePluginService ccs : beforeExecutePluginServices) {
            String serviceType = ccs.getServiceType().toLowerCase(Locale.ROOT);
            Properties properties = this.configChangeConfigs.getPluginProperties(serviceType);
            configChangeRequest.setArg("pluginProperties", (Object)properties);
            ccs.execute(configChangeRequest, configChangeResponse);
            if (null != configChangeResponse.getArgs()) {
                args = configChangeResponse.getArgs();
            }
            if (configChangeResponse.isSuccess()) continue;
            retVal = this.wrapErrorResp(configChangeResponse);
            break;
        }
        try {
            if (configChangeResponse.isSuccess()) {
                retVal = pjp.proceed(args);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("config change join point failed {}", (Object)e.getMessage());
            configChangeResponse.setMsg("config change join point fail" + e.getMessage());
            retVal = this.wrapErrorResp(configChangeResponse);
        }
        ConfigExecutor.executeAsyncConfigChangePluginTask(() -> {
            for (ConfigChangePluginService ccs : afterExecutePluginServices) {
                try {
                    String serviceType = ccs.getServiceType().toLowerCase(Locale.ROOT);
                    Properties properties = this.configChangeConfigs.getPluginProperties(serviceType);
                    configChangeRequest.setArg("pluginProperties", (Object)properties);
                    ccs.execute(configChangeRequest, configChangeResponse);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("execute async plugin services failed {}", (Object)throwable.getMessage());
                }
            }
        });
        return retVal;
    }

    private List<ConfigChangePluginService> getPluginServices(ConfigChangePointCutTypes configChangePointCutType) {
        List pluginServicePriorityList = ConfigChangePluginManager.findPluginServicesByPointcut((ConfigChangePointCutTypes)configChangePointCutType);
        if (pluginServicePriorityList == null) {
            return new ArrayList<ConfigChangePluginService>();
        }
        for (ConfigChangePluginService each : pluginServicePriorityList) {
            if (!this.isEnabled(each)) continue;
            return pluginServicePriorityList;
        }
        return new ArrayList<ConfigChangePluginService>();
    }

    private boolean isEnabled(ConfigChangePluginService configChangePluginService) {
        Properties serviceConfigProperties = this.configChangeConfigs.getPluginProperties(configChangePluginService.getServiceType());
        return Boolean.parseBoolean(serviceConfigProperties.getProperty(ENABLED));
    }

    private Object wrapErrorResp(ConfigChangeResponse configChangeResponse) {
        RestResult retVal = null;
        switch (configChangeResponse.getResponseType()) {
            case IMPORT_BY_HTTP: 
            case REMOVE_BATCH_HTTP: 
            case REMOVE_BY_HTTP: 
            case PUBLISH_BY_HTTP: {
                retVal = RestResultUtils.failed((String)configChangeResponse.getMsg());
                break;
            }
            case PUBLISH_BY_RPC: {
                retVal = ConfigPublishResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)configChangeResponse.getMsg());
                break;
            }
            case REMOVE_BY_RPC: {
                retVal = ConfigRemoveResponse.buildFailResponse((String)configChangeResponse.getMsg());
                break;
            }
        }
        return retVal;
    }
}

