/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.query;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainRequestExtractor;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChainRequestExtractorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChainRequestExtractorService.class);
    private static ConfigQueryChainRequestExtractor extractor;

    public static ConfigQueryChainRequestExtractor getExtractor() {
        return extractor;
    }

    static {
        String curExtractor = EnvUtil.getProperty((String)"nacos.config.query.chain.request.extractor", (String)"nacos");
        Optional<ConfigQueryChainRequestExtractor> optionalBuilder = NacosServiceLoader.load(ConfigQueryChainRequestExtractor.class).stream().filter(builder -> builder.getName().equals(curExtractor)).findFirst();
        if (!optionalBuilder.isPresent()) {
            String errorMessage = "No suitable ConfigQueryRequestExtractor found for name: " + curExtractor;
            LOGGER.error(errorMessage);
            throw new NacosConfigException(errorMessage);
        }
        extractor = optionalBuilder.get();
        LOGGER.info("ConfigQueryRequestExtractor has been initialized successfully with extractor: {}", (Object)curExtractor);
    }
}

