/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ListenerCheckResult;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.service.notify.HttpClientManager;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.stereotype.Service;

@Service
public class ConfigSubService {
    private ServerMemberManager memberManager;

    public ConfigSubService(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    private static String getUrl(String ip, String relativePath) {
        return "http://" + ip + EnvUtil.getContextPath() + relativePath;
    }

    private List<SampleResult> runConfigListenerCollectionJob(Map<String, String> params, CompletionService<SampleResult> completionService) {
        return new ClusterListenerJob(params, completionService, this.memberManager).runJobs();
    }

    private List<SampleResult> runConfigListenerByIpCollectionJob(Map<String, String> params, CompletionService<SampleResult> completionService) {
        return new ClusterListenerByIpJob(params, completionService, this.memberManager).runJobs();
    }

    private List<ListenerCheckResult> runHasCheckListenerCollectionJob(Map<String, String> params, CompletionService<ListenerCheckResult> completionService) {
        return new ClusterCheckHasListenerJob(params, completionService, this.memberManager).runJobs();
    }

    public static Object runSingleJob(String ip, Map<String, String> params, String url, Type type) {
        try {
            StringBuilder paramUrl = new StringBuilder();
            for (Map.Entry<String, String> param : params.entrySet()) {
                paramUrl.append("&").append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
            String urlAll = ConfigSubService.getUrl(ip, url) + "?" + paramUrl;
            RestResult<String> result = ConfigSubService.invokeUrl(urlAll, "UTF-8");
            if (result.ok()) {
                Object t = JacksonUtils.toObj((String)((String)result.getData()), (Type)type);
                return t;
            }
            LogUtil.DEFAULT_LOG.info("Can not get remote from {} with {}", (Object)ip, result.getData());
            return null;
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.warn("Get remote info from {} with exception: {}", (Object)ip, (Object)e.getMessage());
            return null;
        }
    }

    public ListenerCheckResult getCheckHasListenerResult(String dataId, String group, String tenant, int sampleTime) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("dataId", dataId);
        params.put("group", group);
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            params.put("tenant", tenant);
        }
        int size = this.memberManager.getServerList().size();
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.memberManager.getServerList().size());
        ExecutorCompletionService<ListenerCheckResult> completionService = new ExecutorCompletionService<ListenerCheckResult>(ConfigExecutor.getConfigSubServiceExecutor(), queue);
        ListenerCheckResult sampleCollectResult = new ListenerCheckResult();
        sampleCollectResult.setCode(201);
        for (int i = 0; i < sampleTime; ++i) {
            List<ListenerCheckResult> sampleResults = this.runHasCheckListenerCollectionJob(params, completionService);
            if (sampleResults != null) {
                sampleCollectResult = this.mergeListenerCheckResult(sampleCollectResult, sampleResults, size);
            }
            if (sampleCollectResult.isHasListener()) break;
        }
        return sampleCollectResult;
    }

    public ListenerCheckResult mergeListenerCheckResult(ListenerCheckResult listenerCheckResult, List<ListenerCheckResult> sampleResults, int expectSize) {
        for (ListenerCheckResult sampleResult : sampleResults) {
            if (sampleResult.getCode() != 200 || !sampleResult.isHasListener()) continue;
            listenerCheckResult.setHasListener(true);
            listenerCheckResult.setCode(200);
            break;
        }
        if (!listenerCheckResult.isHasListener() && sampleResults.size() != expectSize) {
            listenerCheckResult.setCode(201);
        }
        return listenerCheckResult;
    }

    public SampleResult mergeSampleResult(SampleResult sampleCollectResult, List<SampleResult> sampleResults) {
        SampleResult mergeResult = new SampleResult();
        Map<Object, Object> listenersGroupkeyStatus = sampleCollectResult.getLisentersGroupkeyStatus() == null || sampleCollectResult.getLisentersGroupkeyStatus().isEmpty() ? new HashMap(10) : sampleCollectResult.getLisentersGroupkeyStatus();
        for (SampleResult sampleResult : sampleResults) {
            Map<String, String> listenersGroupkeyStatusTmp = sampleResult.getLisentersGroupkeyStatus();
            listenersGroupkeyStatus.putAll(listenersGroupkeyStatusTmp);
        }
        mergeResult.setLisentersGroupkeyStatus(listenersGroupkeyStatus);
        return mergeResult;
    }

    public SampleResult getCollectSampleResult(String dataId, String group, String tenant, int sampleTime) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("dataId", dataId);
        params.put("group", group);
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            params.put("tenant", tenant);
        }
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.memberManager.getServerList().size());
        ExecutorCompletionService<SampleResult> completionService = new ExecutorCompletionService<SampleResult>(ConfigExecutor.getConfigSubServiceExecutor(), queue);
        SampleResult sampleCollectResult = new SampleResult();
        for (int i = 0; i < sampleTime; ++i) {
            List<SampleResult> sampleResults = this.runConfigListenerCollectionJob(params, completionService);
            if (sampleResults == null) continue;
            sampleCollectResult = this.mergeSampleResult(sampleCollectResult, sampleResults);
        }
        return sampleCollectResult;
    }

    public SampleResult getCollectSampleResultByIp(String ip, int sampleTime) {
        HashMap<String, String> params = new HashMap<String, String>(50);
        params.put("ip", ip);
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.memberManager.getServerList().size());
        ExecutorCompletionService<SampleResult> completionService = new ExecutorCompletionService<SampleResult>(ConfigExecutor.getConfigSubServiceExecutor(), queue);
        SampleResult sampleCollectResult = new SampleResult();
        for (int i = 0; i < sampleTime; ++i) {
            List<SampleResult> sampleResults = this.runConfigListenerByIpCollectionJob(params, completionService);
            if (sampleResults == null) continue;
            sampleCollectResult = this.mergeSampleResult(sampleCollectResult, sampleResults);
        }
        return sampleCollectResult;
    }

    public static RestResult<String> invokeUrl(String url, String encoding) throws Exception {
        Header header = Header.newInstance();
        header.addParam("Accept-Charset", encoding);
        return HttpClientManager.getNacosRestTemplate().get(url, header, Query.EMPTY, String.class);
    }

    static class ClusterListenerJob
    extends ClusterJob<SampleResult> {
        static final String URL = "/v1/cs/communication/configWatchers";

        ClusterListenerJob(Map<String, String> params, CompletionService<SampleResult> completionService, ServerMemberManager serverMemberManager) {
            super(URL, params, completionService, serverMemberManager);
        }
    }

    static class ClusterListenerByIpJob
    extends ClusterJob<SampleResult> {
        static final String URL = "/v1/cs/communication/watcherConfigs";

        ClusterListenerByIpJob(Map<String, String> params, CompletionService<SampleResult> completionService, ServerMemberManager serverMemberManager) {
            super(URL, params, completionService, serverMemberManager);
        }
    }

    class ClusterCheckHasListenerJob
    extends ClusterJob<ListenerCheckResult> {
        static final String URL = "/v1/cs/communication/checkConfigWatchers";

        ClusterCheckHasListenerJob(Map<String, String> params, CompletionService<ListenerCheckResult> completionService, ServerMemberManager serverMemberManager) {
            super(URL, params, completionService, serverMemberManager);
        }
    }

    static abstract class ClusterJob<T> {
        private String url;
        private Map<String, String> params;
        private CompletionService<T> completionService;
        private ServerMemberManager serverMemberManager;

        ClusterJob(String url, Map<String, String> params, CompletionService<T> completionService, ServerMemberManager serverMemberManager) {
            this.url = url;
            this.params = params;
            this.completionService = completionService;
            this.serverMemberManager = serverMemberManager;
        }

        List<T> runJobs() {
            Collection ipList = this.serverMemberManager.allMembers();
            ArrayList<T> collectionResult = new ArrayList<T>(ipList.size());
            for (Member ip : ipList) {
                try {
                    this.completionService.submit(new Job<T>(ip.getAddress()){});
                }
                catch (Throwable e) {
                    LogUtil.DEFAULT_LOG.warn("invoke to {} with exception: {} during submit job", (Object)ip, (Object)e.getMessage());
                }
            }
            for (Member member : ipList) {
                try {
                    Future<T> f = this.completionService.poll(1000L, TimeUnit.MILLISECONDS);
                    try {
                        if (f != null) {
                            T sampleResults = f.get(500L, TimeUnit.MILLISECONDS);
                            if (sampleResults == null) continue;
                            collectionResult.add(sampleResults);
                            continue;
                        }
                        LogUtil.DEFAULT_LOG.warn("The task in ip: {}  did not completed in 1000ms ", (Object)member);
                    }
                    catch (TimeoutException e) {
                        if (f != null) {
                            f.cancel(true);
                        }
                        LogUtil.DEFAULT_LOG.warn("get task result with TimeoutException: {} ", (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LogUtil.DEFAULT_LOG.warn("get task result with Exception: {} ", (Object)e.getMessage());
                }
            }
            return collectionResult;
        }

        class Job<T>
        implements Callable<T> {
            private String ip;

            public Job(String ip) {
                this.ip = ip;
            }

            @Override
            public T call() throws Exception {
                return (T)ConfigSubService.runSingleJob(this.ip, ClusterJob.this.params, ClusterJob.this.url, ((ParameterizedType)ClusterJob.this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
            }
        }
    }
}

