/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.gray.ConfigGrayPersistInfo;
import com.alibaba.nacos.config.server.model.gray.GrayRuleManager;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class ConfigGrayModelMigrateService {
    ConfigInfoBetaPersistService configInfoBetaPersistService;
    ConfigInfoTagPersistService configInfoTagPersistService;
    ConfigInfoGrayPersistService configInfoGrayPersistService;

    public ConfigGrayModelMigrateService(ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoTagPersistService configInfoTagPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
    }

    @PostConstruct
    public void migrate() throws Exception {
        if (PropertyUtil.isGrayCompatibleModel()) {
            this.doCheckMigrate();
        }
    }

    public void checkMigrateBeta(String dataId, String group, String tenant) {
        ConfigInfoBetaWrapper configInfo4Beta = this.configInfoBetaPersistService.findConfigInfo4Beta(dataId, group, tenant);
        if (configInfo4Beta == null) {
            ConfigInfoGrayWrapper configInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "beta");
            if (configInfoGrayWrapper == null) {
                return;
            }
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, tenant, "beta", NetUtils.localIP(), "nacos_auto_migrate");
            return;
        }
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "beta");
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < configInfo4Beta.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate beta to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{configInfo4Beta.getDataId(), configInfo4Beta.getGroup(), configInfo4Beta.getTenant(), configInfo4Beta.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("beta", "1.0.0", configInfo4Beta.getBetaIps(), Integer.MAX_VALUE);
            this.configInfoGrayPersistService.insertOrUpdateGray(configInfo4Beta, "beta", GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIP(), "nacos_auto_migrate");
        }
    }

    public void checkMigrateTag(String dataId, String group, String tenant, String tag) {
        ConfigInfoTagWrapper configInfo4Tag = this.configInfoTagPersistService.findConfigInfo4Tag(dataId, group, tenant, tag);
        if (configInfo4Tag == null) {
            ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "tag_" + tag);
            if (configInfo4Gray == null) {
                return;
            }
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, tenant, "tag_" + tag, NetUtils.localIP(), "nacos_auto_migrate");
            return;
        }
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "tag_" + tag);
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < configInfo4Tag.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate tag to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{configInfo4Tag.getDataId(), configInfo4Tag.getGroup(), configInfo4Tag.getTenant(), configInfo4Tag.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("tag", "1.0.0", configInfo4Tag.getTag(), 0x7FFFFFFE);
            this.configInfoGrayPersistService.insertOrUpdateGray(configInfo4Tag, "tag", GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIP(), "nacos_auto_migrate");
        }
    }

    private void doCheckMigrate() throws Exception {
        int unfinishedTaskCount;
        Object page;
        int pageNo;
        int migrateMulti = (Integer)EnvUtil.getProperty((String)"nacos.gray.migrate.executor.multi", Integer.class, (Object)4);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(ThreadUtils.getSuitableThreadCount((int)migrateMulti), ThreadUtils.getSuitableThreadCount((int)migrateMulti), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(PropertyUtil.getAllDumpPageSize() * migrateMulti), r -> new Thread(r, "gray-migrate-worker"), new ThreadPoolExecutor.CallerRunsPolicy());
        int pageSize = 100;
        int rowCount = this.configInfoBetaPersistService.configInfoBetaCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
        int actualRowCount = 0;
        for (pageNo = 1; pageNo <= pageCount; ++pageNo) {
            page = this.configInfoBetaPersistService.findAllConfigInfoBetaForDumpAll(pageNo, pageSize);
            if (page == null) continue;
            for (ConfigInfo cf : page.getPageItems()) {
                executorService.execute(() -> this.lambda$doCheckMigrate$1((ConfigInfoBetaWrapper)cf));
            }
            LogUtil.DEFAULT_LOG.info("[gray-migrate-beta] submit gray task {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        try {
            unfinishedTaskCount = 0;
            while ((unfinishedTaskCount = executorService.getQueue().size() + executorService.getActiveCount()) > 0) {
                LogUtil.DEFAULT_LOG.info("[gray-migrate-beta] wait {} migrate tasks to be finished", (Object)unfinishedTaskCount);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.error("[gray-migrate-beta] wait  dump tasks to be finished error", (Throwable)e);
            throw e;
        }
        rowCount = this.configInfoTagPersistService.configInfoTagCount();
        pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
        actualRowCount = 0;
        for (pageNo = 1; pageNo <= pageCount; ++pageNo) {
            page = this.configInfoTagPersistService.findAllConfigInfoTagForDumpAll(pageNo, pageSize);
            if (page == null) continue;
            for (ConfigInfo cf : page.getPageItems()) {
                executorService.execute(() -> this.lambda$doCheckMigrate$2((ConfigInfoTagWrapper)cf));
            }
            LogUtil.DEFAULT_LOG.info("[gray-migrate-tag]  submit gray task  {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        try {
            unfinishedTaskCount = 0;
            while ((unfinishedTaskCount = executorService.getQueue().size() + executorService.getActiveCount()) > 0) {
                LogUtil.DEFAULT_LOG.info("[gray-migrate-tag] wait {} migrate tasks to be finished", (Object)unfinishedTaskCount);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.error("[gray-migrate-tag] wait migrate tasks to be finished error", (Throwable)e);
            throw e;
        }
        executorService.shutdown();
    }

    private /* synthetic */ void lambda$doCheckMigrate$2(ConfigInfoTagWrapper cf) {
        PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(cf.getDataId(), cf.getGroup(), cf.getTenant(), "tag_" + cf.getTag());
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < cf.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate tag to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("tag", "1.0.0", cf.getTag(), 0x7FFFFFFE);
            this.configInfoGrayPersistService.insertOrUpdateGray(cf, "tag_" + cf.getTag(), GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIP(), "nacos_auto_migrate");
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    private /* synthetic */ void lambda$doCheckMigrate$1(ConfigInfoBetaWrapper cf) {
        PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(cf.getDataId(), cf.getGroup(), cf.getTenant(), "beta");
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < cf.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate beta to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("beta", "1.0.0", cf.getBetaIps(), Integer.MAX_VALUE);
            this.configInfoGrayPersistService.insertOrUpdateGray(cf, "beta", GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIP(), "nacos_auto_migrate");
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }
}

