/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.AclInfo;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.stereotype.Service;

@Service
public class ClientIpWhiteList {
    public static final String CLIENT_IP_WHITELIST_METADATA = "com.alibaba.nacos.metadata.clientIpWhitelist";
    private static final AtomicReference<List<String>> CLIENT_IP_WHITELIST = new AtomicReference(new ArrayList());
    private static Boolean isOpen = false;

    public static boolean isLegalClient(String clientIp) {
        if (StringUtils.isBlank((CharSequence)clientIp)) {
            throw new IllegalArgumentException("clientIp is empty");
        }
        clientIp = clientIp.trim();
        return CLIENT_IP_WHITELIST.get().contains(clientIp);
    }

    public static boolean isEnableWhitelist() {
        return isOpen;
    }

    public static void load(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LogUtil.DEFAULT_LOG.warn("clientIpWhiteList is blank.close whitelist.");
            isOpen = false;
            CLIENT_IP_WHITELIST.get().clear();
            return;
        }
        LogUtil.DEFAULT_LOG.warn("[clientIpWhiteList] {}", (Object)content);
        try {
            AclInfo acl = (AclInfo)JacksonUtils.toObj((String)content, AclInfo.class);
            isOpen = acl.getIsOpen();
            CLIENT_IP_WHITELIST.set(acl.getIps());
        }
        catch (Exception ioe) {
            LogUtil.DEFAULT_LOG.error("failed to load clientIpWhiteList, " + ioe.toString(), (Throwable)ioe);
        }
    }
}

