/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.cluster.ConfigChangeClusterSyncRequest;
import com.alibaba.nacos.api.config.remote.response.cluster.ConfigChangeClusterSyncResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.ConfigGrayModelMigrateService;
import com.alibaba.nacos.config.server.service.dump.DumpRequest;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.grpc.InvokeSource;
import org.springframework.stereotype.Component;

@Component
@InvokeSource(source={"cluster"})
public class ConfigChangeClusterSyncRequestHandler
extends RequestHandler<ConfigChangeClusterSyncRequest, ConfigChangeClusterSyncResponse> {
    private final DumpService dumpService;
    private ConfigGrayModelMigrateService configGrayModelMigrateService;

    public ConfigChangeClusterSyncRequestHandler(DumpService dumpService, ConfigGrayModelMigrateService configGrayModelMigrateService) {
        this.dumpService = dumpService;
        this.configGrayModelMigrateService = configGrayModelMigrateService;
    }

    @TpsControl(pointName="ClusterConfigChangeNotify")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigChangeClusterSyncResponse handle(ConfigChangeClusterSyncRequest configChangeSyncRequest, RequestMeta meta) throws NacosException {
        this.checkCompatity(configChangeSyncRequest);
        ParamUtils.checkParam(configChangeSyncRequest.getTag());
        DumpRequest dumpRequest = DumpRequest.create(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant(), configChangeSyncRequest.getLastModified(), meta.getClientIp());
        dumpRequest.setGrayName(configChangeSyncRequest.getGrayName());
        this.dumpService.dump(dumpRequest);
        return new ConfigChangeClusterSyncResponse();
    }

    private void checkCompatity(ConfigChangeClusterSyncRequest configChangeSyncRequest) {
        if (PropertyUtil.isGrayCompatibleModel() && StringUtils.isBlank((CharSequence)configChangeSyncRequest.getGrayName()) && (configChangeSyncRequest.isBeta() || StringUtils.isNotBlank((String)configChangeSyncRequest.getTag()))) {
            String grayName = null;
            if (configChangeSyncRequest.isBeta()) {
                this.configGrayModelMigrateService.checkMigrateBeta(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant());
                grayName = "beta";
            } else {
                this.configGrayModelMigrateService.checkMigrateTag(configChangeSyncRequest.getDataId(), configChangeSyncRequest.getGroup(), configChangeSyncRequest.getTenant(), configChangeSyncRequest.getTag());
                grayName = "tag_" + configChangeSyncRequest.getTag();
            }
            configChangeSyncRequest.setGrayName(grayName);
        }
    }
}

