/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.model.ConfigCacheFactoryDelegate;
import com.alibaba.nacos.config.server.model.ConfigCachePostProcessor;
import com.alibaba.nacos.config.server.model.NacosConfigCachePostProcessor;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCachePostProcessorDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCacheFactoryDelegate.class);
    private static final ConfigCachePostProcessorDelegate INSTANCE = new ConfigCachePostProcessorDelegate();
    private String configCacheMd5PostProcessorType = EnvUtil.getProperty((String)"nacos.config.cache.type", (String)"nacos");
    private ConfigCachePostProcessor configCachePostProcessor;

    private ConfigCachePostProcessorDelegate() {
        Collection processors = NacosServiceLoader.load(ConfigCachePostProcessor.class);
        for (ConfigCachePostProcessor processor : processors) {
            if (StringUtils.isEmpty((String)processor.getName())) {
                LOGGER.warn("[ConfigCachePostProcessorDelegate] Load ConfigCachePostProcessor({}) PostProcessorName(null/empty) fail. Please add PostProcessorName to resolve", (Object)processor.getClass().getName());
                continue;
            }
            LOGGER.info("[ConfigCachePostProcessorDelegate] Load ConfigCachePostProcessor({}) PostProcessorName({}) successfully. ", (Object)processor.getClass().getName(), (Object)processor.getName());
            if (!StringUtils.equals((String)this.configCacheMd5PostProcessorType, (String)processor.getName())) continue;
            LOGGER.info("[ConfigCachePostProcessorDelegate] Matched ConfigCachePostProcessor found,set configCacheFactory={}", (Object)processor.getClass().getName());
            this.configCachePostProcessor = processor;
        }
        if (this.configCachePostProcessor == null) {
            LOGGER.info("[ConfigCachePostProcessorDelegate] Matched ConfigCachePostProcessor not found, load Default NacosConfigCachePostProcessor successfully");
            this.configCachePostProcessor = new NacosConfigCachePostProcessor();
        }
    }

    public static ConfigCachePostProcessorDelegate getInstance() {
        return INSTANCE;
    }

    public void postProcess(ConfigCache configCache, String content) {
        this.configCachePostProcessor.postProcess(configCache, content);
    }
}

