/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model;

import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.model.ConfigCacheFactoryDelegate;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.utils.SimpleReadWriteLock;
import com.alibaba.nacos.core.utils.StringPool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CacheItem {
    final String groupKey;
    public String type;
    ConfigCache configCache = ConfigCacheFactoryDelegate.getInstance().createConfigCache();
    private volatile Map<String, ConfigCacheGray> configCacheGray = null;
    List<ConfigCacheGray> sortedConfigCacheGrayList = null;
    private final SimpleReadWriteLock rwLock = new SimpleReadWriteLock();

    public CacheItem(String groupKey, String encryptedDataKey) {
        this.groupKey = StringPool.get((String)groupKey);
        this.getConfigCache().setEncryptedDataKey(encryptedDataKey);
    }

    public CacheItem(String groupKey) {
        this.groupKey = StringPool.get((String)groupKey);
    }

    public ConfigCache getConfigCache() {
        return this.configCache;
    }

    public SimpleReadWriteLock getRwLock() {
        return this.rwLock;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void initConfigGrayIfEmpty() {
        if (this.configCacheGray == null) {
            this.configCacheGray = new HashMap<String, ConfigCacheGray>(4);
        }
    }

    public void initConfigGrayIfEmpty(String grayName) {
        this.initConfigGrayIfEmpty();
        if (!this.configCacheGray.containsKey(grayName)) {
            this.configCacheGray.put(grayName, ConfigCacheFactoryDelegate.getInstance().createConfigCacheGray(grayName));
        }
    }

    public List<ConfigCacheGray> getSortConfigGrays() {
        return this.sortedConfigCacheGrayList;
    }

    public void sortConfigGray() {
        if (this.configCacheGray == null || this.configCacheGray.isEmpty()) {
            this.sortedConfigCacheGrayList = null;
            return;
        }
        this.sortedConfigCacheGrayList = this.configCacheGray.values().stream().sorted((o1, o2) -> {
            if (o1.getPriority() != o2.getPriority()) {
                return Integer.compare(o1.getPriority(), o2.getPriority()) * -1;
            }
            return o1.getGrayName().compareTo(o2.getGrayName());
        }).collect(Collectors.toList());
    }

    public Map<String, ConfigCacheGray> getConfigCacheGray() {
        return this.configCacheGray;
    }

    public void clearConfigGrays() {
        this.configCacheGray = null;
        this.sortedConfigCacheGrayList = null;
    }
}

