/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfoDetail;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.HistoryService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/cs/history"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class HistoryControllerV2 {
    private final HistoryService historyService;

    public HistoryControllerV2(HistoryService historyService) {
        this.historyService = historyService;
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Result<Page<ConfigHistoryInfo>> listConfigHistory(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="pageNo", required=false, defaultValue="1") Integer pageNo, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        pageSize = Math.min(500, pageSize);
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        return Result.success(this.historyService.listConfigHistory(dataId, group, namespaceId, pageNo, pageSize));
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config")
    public Result<ConfigHistoryInfo> getConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="nid") Long nid) throws AccessException, NacosApiException {
        ConfigHistoryInfo configHistoryInfo;
        try {
            namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
            configHistoryInfo = this.historyService.getConfigHistoryInfo(dataId, group, namespaceId, nid);
        }
        catch (DataAccessException e) {
            throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.RESOURCE_NOT_FOUND, "certain config history for nid = " + nid + " not exist");
        }
        return Result.success((Object)configHistoryInfo);
    }

    @GetMapping(value={"/detail"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Result<ConfigHistoryInfoDetail> getConfigHistoryInfoDetail(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="nid") Long nid) throws AccessException {
        return Result.success((Object)this.historyService.getConfigHistoryInfoDetail(dataId, group, namespaceId, nid));
    }

    @GetMapping(value={"/previous"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Result<ConfigHistoryInfo> getPreviousConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="id") Long id) throws AccessException, NacosApiException {
        ConfigHistoryInfo configHistoryInfo;
        try {
            namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
            configHistoryInfo = this.historyService.getPreviousConfigHistoryInfo(dataId, group, namespaceId, id);
        }
        catch (DataAccessException e) {
            throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.RESOURCE_NOT_FOUND, "previous config history for id = " + id + " not exist");
        }
        return Result.success((Object)configHistoryInfo);
    }

    @GetMapping(value={"/configs"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Result<List<ConfigInfoWrapper>> getConfigsByTenant(@RequestParam(value="namespaceId") String namespaceId) throws NacosApiException {
        ParamUtils.checkTenantV2(namespaceId);
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        return Result.success(this.historyService.getConfigListByNamespace(namespaceId));
    }
}

