/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.enums.ApiVersionEnum;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.paramcheck.ConfigBlurSearchHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/cs/config"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConfigControllerV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigControllerV2.class);
    private final ConfigServletInner inner;
    private final ConfigOperationService configOperationService;
    private final ConfigDetailService configDetailService;

    public ConfigControllerV2(ConfigServletInner inner, ConfigOperationService configOperationService, ConfigDetailService configDetailService) {
        this.inner = inner;
        this.configOperationService = configOperationService;
        this.configDetailService = configDetailService;
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config")
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="tag", required=false) String tag) throws NacosException, IOException, ServletException {
        ParamUtils.checkTenantV2(namespaceId);
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParamV2(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String isNotify = request.getHeader("notify");
        this.inner.doGetConfig(request, response, dataId, group, namespaceId, tag, isNotify, clientIp, ApiVersionEnum.V2);
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Result<Boolean> publishConfig(ConfigForm configForm, HttpServletRequest request) throws NacosException {
        configForm.validate();
        String encryptedDataKeyFinal = configForm.getEncryptedDataKey();
        if (StringUtils.isBlank((CharSequence)encryptedDataKeyFinal)) {
            Pair pair = EncryptionHandler.encryptHandler((String)configForm.getDataId(), (String)configForm.getContent());
            configForm.setContent((String)pair.getSecond());
            encryptedDataKeyFinal = (String)pair.getFirst();
        }
        configForm.setNamespaceId(NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId()));
        ParamUtils.checkTenantV2(configForm.getNamespaceId());
        ParamUtils.checkParam(configForm.getDataId(), configForm.getGroup(), "datumId", configForm.getContent());
        ParamUtils.checkParamV2(configForm.getTag());
        if (StringUtils.isBlank((CharSequence)configForm.getSrcUser())) {
            configForm.setSrcUser(RequestUtil.getSrcUserName(request));
        }
        if (!ConfigType.isValidType((String)configForm.getType()).booleanValue()) {
            configForm.setType(ConfigType.getDefaultType().getType());
        }
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp(request));
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName(request));
        configRequestInfo.setBetaIps(request.getHeader("betaIps"));
        configRequestInfo.setCasMd5(request.getHeader("casMd5"));
        return Result.success((Object)this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKeyFinal));
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Result<Boolean> deleteConfig(HttpServletRequest request, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        ParamUtils.checkTenantV2(namespaceId);
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParamV2(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        return Result.success((Object)this.configOperationService.deleteConfig(dataId, group, namespaceId, tag, clientIp, srcUser));
    }

    @GetMapping(value={"/searchDetail"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    public Page<ConfigInfo> searchConfigByDetails(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="config_detail") String configDetail, @RequestParam(value="search", defaultValue="blur", required=false) String search, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) throws NacosException {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((String)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        if (StringUtils.isNotBlank((String)configDetail)) {
            configAdvanceInfo.put("content", configDetail);
        }
        try {
            return this.configDetailService.findConfigInfoPage(search, pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw e;
        }
    }
}

