/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.model.core.IResultCode;
import com.alibaba.nacos.common.utils.DateFormatUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.enums.ApiVersionEnum;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigMetadata;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.GroupkeyListenserStatus;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.gray.GrayRuleManager;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.paramcheck.ConfigBlurSearchHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.paramcheck.ConfigListenerHttpParamExtractor;
import com.alibaba.nacos.config.server.result.code.ResultCodeEnum;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.ConfigSubService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.config.server.utils.YamlParserUtil;
import com.alibaba.nacos.config.server.utils.ZipUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/cs/configs"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConfigController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigController.class);
    private static final String EXPORT_CONFIG_FILE_NAME = "nacos_config_export_";
    private static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";
    private static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyyMMddHHmmss";
    private final ConfigServletInner inner;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoBetaPersistService configInfoBetaPersistService;
    private ConfigInfoGrayPersistService configInfoGrayPersistService;
    private NamespacePersistService namespacePersistService;
    private final ConfigOperationService configOperationService;
    private final ConfigSubService configSubService;

    public ConfigController(ConfigServletInner inner, ConfigOperationService configOperationService, ConfigSubService configSubService, ConfigInfoPersistService configInfoPersistService, NamespacePersistService namespacePersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.inner = inner;
        this.configOperationService = configOperationService;
        this.configSubService = configSubService;
        this.configInfoPersistService = configInfoPersistService;
        this.namespacePersistService = namespacePersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    @PostMapping
    @TpsControl(pointName="ConfigPublish")
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Boolean publishConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="content") String content, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="desc", required=false) String desc, @RequestParam(value="use", required=false) String use, @RequestParam(value="effect", required=false) String effect, @RequestParam(value="type", required=false) String type, @RequestParam(value="schema", required=false) String schema, @RequestParam(required=false) String encryptedDataKey) throws NacosException {
        String encryptedDataKeyFinal = null;
        if (StringUtils.isNotBlank((String)encryptedDataKey)) {
            encryptedDataKeyFinal = encryptedDataKey;
        } else {
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            content = (String)pair.getSecond();
            encryptedDataKeyFinal = (String)pair.getFirst();
        }
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", content);
        ParamUtils.checkParam(tag);
        ConfigForm configForm = new ConfigForm();
        configForm.setDataId(dataId);
        configForm.setGroup(group);
        configForm.setNamespaceId(tenant);
        configForm.setContent(content);
        configForm.setTag(tag);
        configForm.setAppName(appName);
        configForm.setSrcUser(srcUser);
        configForm.setConfigTags(configTags);
        configForm.setDesc(desc);
        configForm.setUse(use);
        configForm.setEffect(effect);
        configForm.setType(type);
        configForm.setSchema(schema);
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            configForm.setSrcUser(RequestUtil.getSrcUserName(request));
        }
        if (!ConfigType.isValidType((String)type).booleanValue()) {
            configForm.setType(ConfigType.getDefaultType().getType());
        }
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp(request));
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName(request));
        configRequestInfo.setBetaIps(request.getHeader("betaIps"));
        configRequestInfo.setCasMd5(request.getHeader("casMd5"));
        return this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKeyFinal);
    }

    @GetMapping
    @TpsControl(pointName="ConfigQuery")
    @Secured(action=ActionTypes.READ, signType="config")
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws IOException, ServletException, NacosException {
        ParamUtils.checkTenant(tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String isNotify = request.getHeader("notify");
        this.inner.doGetConfig(request, response, dataId, group, tenant, tag, isNotify, clientIp, ApiVersionEnum.V1);
    }

    @GetMapping(params={"show=all"})
    @Secured(action=ActionTypes.READ, signType="config")
    public ConfigAllInfo detailConfigInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) throws NacosException {
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ConfigAllInfo configAllInfo = this.configInfoPersistService.findConfigAllInfo(dataId, group, tenant);
        if (Objects.nonNull(configAllInfo)) {
            String encryptedDataKey = configAllInfo.getEncryptedDataKey();
            Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)configAllInfo.getContent());
            configAllInfo.setContent((String)pair.getSecond());
        }
        return configAllInfo;
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        return this.configOperationService.deleteConfig(dataId, group, tenant, tag, clientIp, srcUser);
    }

    @DeleteMapping(params={"delType=ids"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    public RestResult<Boolean> deleteConfigs(HttpServletRequest request, @RequestParam(value="ids") List<Long> ids) {
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        List<ConfigAllInfo> configInfoList = this.configInfoPersistService.removeConfigInfoByIds(ids, clientIp, srcUser);
        if (CollectionUtils.isEmpty(configInfoList)) {
            return RestResultUtils.success((Object)true);
        }
        for (ConfigAllInfo configInfo : configInfoList) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), null, time.getTime(), clientIp, "persist", "remove", null);
        }
        return RestResultUtils.success((Object)true);
    }

    @GetMapping(value={"/catalog"})
    @Secured(action=ActionTypes.READ, signType="config")
    public RestResult<ConfigAdvanceInfo> getConfigAdvanceInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        ConfigAdvanceInfo configInfo = this.configInfoPersistService.findConfigAdvanceInfo(dataId, group, tenant);
        return RestResultUtils.success((Object)configInfo);
    }

    @PostMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigListenerHttpParamExtractor.class)
    public void listener(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, String> clientMd5Map;
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        String probeModify = request.getParameter("Listening-Configs");
        if (StringUtils.isBlank((CharSequence)probeModify)) {
            LOGGER.warn("invalid probeModify is blank");
            throw new IllegalArgumentException("invalid probeModify");
        }
        probeModify = URLDecoder.decode(probeModify, "UTF-8");
        try {
            clientMd5Map = MD5Util.getClientMd5Map(probeModify);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        this.inner.doPollingConfig(request, response, clientMd5Map, probeModify.length());
    }

    @GetMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, signType="config")
    public GroupkeyListenserStatus getListeners(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, @RequestParam(value="sampleTime", required=false, defaultValue="1") int sampleTime) throws Exception {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        SampleResult collectSampleResult = this.configSubService.getCollectSampleResult(dataId, group, tenant, sampleTime);
        GroupkeyListenserStatus gls = new GroupkeyListenserStatus();
        gls.setCollectStatus(200);
        if (collectSampleResult.getLisentersGroupkeyStatus() != null) {
            gls.setLisentersGroupkeyStatus(collectSampleResult.getLisentersGroupkeyStatus());
        }
        return gls;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    public Page<ConfigInfo> searchConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((String)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.configInfoPersistService.findConfigInfo4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @GetMapping(params={"search=blur"})
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(httpExtractor=ConfigBlurSearchHttpParamExtractor.class)
    public Page<ConfigInfo> fuzzySearchConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="types", required=false) String types, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        MetricsMonitor.getFuzzySearchMonitor().incrementAndGet();
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(50);
        if (StringUtils.isNotBlank((String)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        if (StringUtils.isNotBlank((String)types)) {
            configAdvanceInfo.put("types", types);
        }
        try {
            return this.configInfoPersistService.findConfigInfoLike4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @DeleteMapping(params={"beta=true"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    public RestResult<Boolean> stopBeta(HttpServletRequest httpServletRequest, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        String remoteIp = RequestUtil.getRemoteIp(httpServletRequest);
        String requestIpApp = RequestUtil.getAppName(httpServletRequest);
        try {
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, tenant, "beta", remoteIp, RequestUtil.getSrcUserName(httpServletRequest));
        }
        catch (Throwable e) {
            LOGGER.error("remove beta data error", e);
            return RestResultUtils.failed((int)500, (Object)false, (String)"remove beta data error");
        }
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, requestIpApp, System.currentTimeMillis(), remoteIp, "persist-beta", "remove", null);
        if (PropertyUtil.isGrayCompatibleModel()) {
            this.configInfoBetaPersistService.removeConfigInfo4Beta(dataId, group, tenant);
        }
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(dataId, group, tenant, "beta", System.currentTimeMillis()));
        return RestResultUtils.success((String)"stop beta ok", (Object)true);
    }

    @GetMapping(params={"beta=true"})
    @Secured(action=ActionTypes.READ, signType="config")
    public RestResult<ConfigInfo4Beta> queryBeta(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        try {
            ConfigInfo4Beta configInfo4Beta = null;
            ConfigInfoGrayWrapper beta4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "beta");
            if (Objects.nonNull(beta4Gray)) {
                String encryptedDataKey = beta4Gray.getEncryptedDataKey();
                Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)beta4Gray.getContent());
                beta4Gray.setContent((String)pair.getSecond());
                configInfo4Beta = new ConfigInfo4Beta();
                BeanUtils.copyProperties((Object)beta4Gray, (Object)configInfo4Beta);
                configInfo4Beta.setBetaIps(GrayRuleManager.deserializeConfigGrayPersistInfo(beta4Gray.getGrayRule()).getExpr());
            }
            return RestResultUtils.success((String)"query beta ok", configInfo4Beta);
        }
        catch (Throwable e) {
            LOGGER.error("query beta data error", e);
            return RestResultUtils.failed((String)"query beta data error");
        }
    }

    @GetMapping(params={"export=true"})
    @Secured(action=ActionTypes.READ, signType="config")
    public ResponseEntity<byte[]> exportConfig(@RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="ids", required=false) List<Long> ids) {
        ids.removeAll(Collections.singleton(null));
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        List<ConfigAllInfo> dataList = this.configInfoPersistService.findAllConfigInfo4Export(dataId, group, tenant, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        StringBuilder metaData = null;
        for (ConfigInfo configInfo : dataList) {
            if (StringUtils.isNotBlank((String)configInfo.getAppName())) {
                String metaDataId;
                if (metaData == null) {
                    metaData = new StringBuilder();
                }
                if ((metaDataId = configInfo.getDataId()).contains(".")) {
                    metaDataId = metaDataId.substring(0, metaDataId.lastIndexOf(".")) + "~" + metaDataId.substring(metaDataId.lastIndexOf(".") + 1);
                }
                metaData.append(configInfo.getGroup()).append('.').append(metaDataId).append(".app=").append(configInfo.getAppName()).append("\r\n");
            }
            Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
            String itemName = configInfo.getGroup() + "/" + configInfo.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, (String)pair.getSecond()));
        }
        if (metaData != null) {
            zipItemList.add(new ZipUtils.ZipItem(".meta.yml", metaData.toString()));
        }
        HttpHeaders headers = new HttpHeaders();
        String string = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + string);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(params={"exportV2=true"})
    @Secured(action=ActionTypes.READ, signType="config")
    public ResponseEntity<byte[]> exportConfigV2(@RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="ids", required=false) List<Long> ids) {
        ids.removeAll(Collections.singleton(null));
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        List<ConfigAllInfo> dataList = this.configInfoPersistService.findAllConfigInfo4Export(dataId, group, tenant, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        ArrayList<ConfigMetadata.ConfigExportItem> configMetadataItems = new ArrayList<ConfigMetadata.ConfigExportItem>();
        for (ConfigAllInfo ci : dataList) {
            ConfigMetadata.ConfigExportItem configMetadataItem = new ConfigMetadata.ConfigExportItem();
            configMetadataItem.setAppName(ci.getAppName());
            configMetadataItem.setDataId(ci.getDataId());
            configMetadataItem.setDesc(ci.getDesc());
            configMetadataItem.setGroup(ci.getGroup());
            configMetadataItem.setType(ci.getType());
            configMetadataItems.add(configMetadataItem);
            Pair pair = EncryptionHandler.decryptHandler((String)ci.getDataId(), (String)ci.getEncryptedDataKey(), (String)ci.getContent());
            String itemName = ci.getGroup() + "/" + ci.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, (String)pair.getSecond()));
        }
        ConfigMetadata configMetadata = new ConfigMetadata();
        configMetadata.setMetadata(configMetadataItems);
        zipItemList.add(new ZipUtils.ZipItem(".metadata.yml", YamlParserUtil.dumpObject(configMetadata)));
        HttpHeaders headers = new HttpHeaders();
        String fileName = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, HttpStatus.OK);
    }

    @PostMapping(params={"import=true"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    public RestResult<Map<String, Object>> importAndPublishConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="namespace", required=false) String namespace, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy, MultipartFile file) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (Objects.isNull(file)) {
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        if (StringUtils.isNotBlank((String)(namespace = NamespaceUtil.processNamespaceParameter((String)namespace))) && this.namespacePersistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(request);
        }
        ArrayList<ConfigAllInfo> configInfoList = new ArrayList<ConfigAllInfo>();
        ArrayList<Map<String, String>> unrecognizedList = new ArrayList<Map<String, String>>();
        try {
            ZipUtils.UnZipResult unziped = ZipUtils.unzip(file.getBytes());
            ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
            RestResult<Map<String, Object>> errorResult = metaDataZipItem != null && ".metadata.yml".equals(metaDataZipItem.getItemName()) ? this.parseImportDataV2(srcUser, unziped, configInfoList, unrecognizedList, namespace) : this.parseImportData(srcUser, unziped, configInfoList, unrecognizedList, namespace);
            if (errorResult != null) {
                return errorResult;
            }
        }
        catch (IOException e) {
            failedData.put("succCount", 0);
            LOGGER.error("parsing data failed", (Throwable)e);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.PARSING_DATA_FAILED, failedData);
        }
        if (CollectionUtils.isEmpty(configInfoList)) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.configInfoPersistService.batchInsertOrUpdate(configInfoList, srcUser, srcIp, null, policy);
        for (ConfigInfo configInfo : configInfoList) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), InetUtils.getSelfIP(), "persist", "pub", configInfo.getContent());
        }
        if (!unrecognizedList.isEmpty()) {
            saveResult.put("unrecognizedCount", unrecognizedList.size());
            saveResult.put("unrecognizedData", unrecognizedList);
        }
        return RestResultUtils.success((String)"\u5bfc\u5165\u6210\u529f", saveResult);
    }

    private RestResult<Map<String, Object>> parseImportData(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespace) {
        List<ZipUtils.ZipItem> itemList;
        ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
        HashMap<String, String> metaDataMap = new HashMap<String, String>(16);
        if (metaDataZipItem != null) {
            String metaDataStr = metaDataZipItem.getItemData().replaceAll("[\r\n]+", "|");
            String[] metaDataArr = metaDataStr.split("\\|");
            HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
            for (String metaDataItem : metaDataArr) {
                String[] metaDataItemArr = metaDataItem.split("=");
                if (metaDataItemArr.length != 2) {
                    failedData.put("succCount", 0);
                    return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
                }
                metaDataMap.put(metaDataItemArr[0], metaDataItemArr[1]);
            }
        }
        if ((itemList = unziped.getZipItemList()) != null && !itemList.isEmpty()) {
            for (ZipUtils.ZipItem item : itemList) {
                String[] groupAdnDataId = item.getItemName().split("/");
                if (groupAdnDataId.length != 2) {
                    HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                    unrecognizedItem.put("itemName", item.getItemName());
                    unrecognizedList.add(unrecognizedItem);
                    continue;
                }
                String group = groupAdnDataId[0];
                String dataId = groupAdnDataId[1];
                String tempDataId = dataId;
                if (tempDataId.contains(".")) {
                    tempDataId = tempDataId.substring(0, tempDataId.lastIndexOf(".")) + "~" + tempDataId.substring(tempDataId.lastIndexOf(".") + 1);
                }
                String metaDataId = group + "." + tempDataId + ".app";
                String content = item.getItemData();
                Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
                content = (String)pair.getSecond();
                ConfigAllInfo ci = new ConfigAllInfo();
                ci.setGroup(group);
                ci.setDataId(dataId);
                ci.setContent(content);
                if (metaDataMap.get(metaDataId) != null) {
                    ci.setAppName((String)metaDataMap.get(metaDataId));
                }
                ci.setTenant(namespace);
                ci.setEncryptedDataKey((String)pair.getFirst());
                ci.setCreateUser(srcUser);
                configInfoList.add(ci);
            }
        }
        return null;
    }

    private RestResult<Map<String, Object>> parseImportDataV2(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespace) {
        ZipUtils.ZipItem metaDataItem = unziped.getMetaDataItem();
        String metaData = metaDataItem.getItemData();
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        ConfigMetadata configMetadata = YamlParserUtil.loadObject(metaData, ConfigMetadata.class);
        if (configMetadata == null || CollectionUtils.isEmpty(configMetadata.getMetadata())) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
        }
        List<ConfigMetadata.ConfigExportItem> configExportItems = configMetadata.getMetadata();
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            if (!StringUtils.isBlank((CharSequence)configExportItem.getDataId()) && !StringUtils.isBlank((CharSequence)configExportItem.getGroup()) && !StringUtils.isBlank((CharSequence)configExportItem.getType())) continue;
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
        }
        List<ZipUtils.ZipItem> zipItemList = unziped.getZipItemList();
        Set metaDataKeys = configExportItems.stream().map(metaItem -> GroupKey.getKey(metaItem.getDataId(), metaItem.getGroup())).collect(Collectors.toSet());
        HashMap configContentMap = new HashMap(zipItemList.size());
        int itemNameLength = 2;
        zipItemList.forEach(item -> {
            String itemName = item.getItemName();
            String[] groupAdnDataId = itemName.split("/");
            if (groupAdnDataId.length != itemNameLength) {
                HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                unrecognizedItem.put("itemName", item.getItemName());
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String dataId = groupAdnDataId[1];
            String group = groupAdnDataId[0];
            String key = GroupKey.getKey(dataId, group);
            if (!metaDataKeys.contains(key)) {
                HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                unrecognizedItem.put("itemName", "\u672a\u5728\u5143\u6570\u636e\u4e2d\u627e\u5230: " + item.getItemName());
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String itemData = item.getItemData();
            configContentMap.put(key, itemData);
        });
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            String group;
            String dataId = configExportItem.getDataId();
            String content = (String)configContentMap.get(GroupKey.getKey(dataId, group = configExportItem.getGroup()));
            if (content == null) {
                HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                unrecognizedItem.put("itemName", "\u672a\u5728\u6587\u4ef6\u4e2d\u627e\u5230: " + group + "/" + dataId);
                unrecognizedList.add(unrecognizedItem);
                continue;
            }
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            content = (String)pair.getSecond();
            ConfigAllInfo ci = new ConfigAllInfo();
            ci.setGroup(group);
            ci.setDataId(dataId);
            ci.setContent(content);
            ci.setType(configExportItem.getType());
            ci.setDesc(configExportItem.getDesc());
            ci.setAppName(configExportItem.getAppName());
            ci.setTenant(namespace);
            ci.setEncryptedDataKey((String)pair.getFirst());
            ci.setCreateUser(srcUser);
            configInfoList.add(ci);
        }
        return null;
    }

    @PostMapping(params={"clone=true"})
    @Secured(action=ActionTypes.WRITE, signType="config")
    public RestResult<Map<String, Object>> cloneConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="tenant") String namespace, @RequestBody List<SameNamespaceCloneConfigBean> configBeansList, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (CollectionUtils.isEmpty(configBeansList)) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NO_SELECTED_CONFIG, failedData);
        }
        configBeansList.removeAll(Collections.singleton(null));
        namespace = NamespaceUtil.processNamespaceParameter((String)namespace);
        if (StringUtils.isNotBlank((String)namespace) && this.namespacePersistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<Long> idList = new ArrayList<Long>(configBeansList.size());
        Map<Long, SameNamespaceCloneConfigBean> configBeansMap = configBeansList.stream().collect(Collectors.toMap(SameNamespaceCloneConfigBean::getCfgId, cfg -> {
            idList.add(cfg.getCfgId());
            return cfg;
        }, (k1, k2) -> k1));
        List<ConfigAllInfo> queryedDataList = this.configInfoPersistService.findAllConfigInfo4Export(null, null, null, null, idList);
        if (queryedDataList == null || queryedDataList.isEmpty()) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList4Clone = new ArrayList<ConfigAllInfo>(queryedDataList.size());
        for (ConfigAllInfo ci : queryedDataList) {
            SameNamespaceCloneConfigBean paramBean = configBeansMap.get(ci.getId());
            ConfigAllInfo ci4save = new ConfigAllInfo();
            ci4save.setTenant(namespace);
            ci4save.setType(ci.getType());
            ci4save.setGroup(paramBean != null && StringUtils.isNotBlank((String)paramBean.getGroup()) ? paramBean.getGroup() : ci.getGroup());
            ci4save.setDataId(paramBean != null && StringUtils.isNotBlank((String)paramBean.getDataId()) ? paramBean.getDataId() : ci.getDataId());
            ci4save.setContent(ci.getContent());
            if (StringUtils.isNotBlank((String)ci.getAppName())) {
                ci4save.setAppName(ci.getAppName());
            }
            ci4save.setDesc(ci.getDesc());
            ci4save.setEncryptedDataKey(ci.getEncryptedDataKey() == null ? "" : ci.getEncryptedDataKey());
            configInfoList4Clone.add(ci4save);
        }
        if (StringUtils.isBlank((CharSequence)srcUser)) {
            srcUser = RequestUtil.getSrcUserName(request);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.configInfoPersistService.batchInsertOrUpdate(configInfoList4Clone, srcUser, srcIp, null, policy);
        for (ConfigInfo configInfo : configInfoList4Clone) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), InetUtils.getSelfIP(), "persist", "pub", configInfo.getContent());
        }
        return RestResultUtils.success((String)"Clone Completed Successfully", saveResult);
    }
}

