/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;

public class AppNameUtils {
    private static final String PARAM_MARKING_PROJECT = "project.name";
    private static final String PARAM_MARKING_JBOSS = "jboss.server.home.dir";
    private static final String PARAM_MARKING_JETTY = "jetty.home";
    private static final String PARAM_MARKING_TOMCAT = "catalina.base";
    private static final String LINUX_ADMIN_HOME = "/home/admin/";
    private static final String SERVER_JBOSS = "jboss";
    private static final String SERVER_JETTY = "jetty";
    private static final String SERVER_TOMCAT = "tomcat";
    private static final String SERVER_UNKNOWN = "unknown server";
    private static final String DEFAULT_APP_NAME = "unknown";

    public static String getAppName() {
        String appName = AppNameUtils.getAppNameByProjectName();
        if (appName != null) {
            return appName;
        }
        appName = AppNameUtils.getAppNameByServerHome();
        if (appName != null) {
            return appName;
        }
        return DEFAULT_APP_NAME;
    }

    private static String getAppNameByProjectName() {
        return System.getProperty(PARAM_MARKING_PROJECT);
    }

    private static String getAppNameByServerHome() {
        String serverHome = null;
        if (SERVER_JBOSS.equals(AppNameUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_JBOSS);
        } else if (SERVER_JETTY.equals(AppNameUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_JETTY);
        } else if (SERVER_TOMCAT.equals(AppNameUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_TOMCAT);
        }
        if (serverHome != null && serverHome.startsWith(LINUX_ADMIN_HOME)) {
            return StringUtils.substringBetween((String)serverHome, (String)LINUX_ADMIN_HOME, (String)File.separator);
        }
        return null;
    }

    private static String getServerType() {
        String serverType = System.getProperty(PARAM_MARKING_JBOSS) != null ? SERVER_JBOSS : (System.getProperty(PARAM_MARKING_JETTY) != null ? SERVER_JETTY : (System.getProperty(PARAM_MARKING_TOMCAT) != null ? SERVER_TOMCAT : SERVER_UNKNOWN));
        return serverType;
    }
}

