/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigQueryResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.net.URLEncoder;
import org.springframework.stereotype.Component;

@Component
public class ConfigQueryRequestHandler
extends RequestHandler<ConfigQueryRequest, ConfigQueryResponse> {
    @TpsControl(pointName="ConfigQuery")
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigQueryResponse handle(ConfigQueryRequest request, RequestMeta meta) throws NacosException {
        try {
            return this.getContext(request, meta, request.isNotify());
        }
        catch (Exception e) {
            return ConfigQueryResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigQueryResponse getContext(ConfigQueryRequest configQueryRequest, RequestMeta meta, boolean notify) throws Exception {
        String dataId = configQueryRequest.getDataId();
        String group = configQueryRequest.getGroup();
        String tenant = configQueryRequest.getTenant();
        String clientIp = meta.getClientIp();
        String tag = configQueryRequest.getTag();
        String groupKey = GroupKey2.getKey(configQueryRequest.getDataId(), configQueryRequest.getGroup(), configQueryRequest.getTenant());
        String autoTag = configQueryRequest.getHeader("Vipserver-Tag");
        String requestIpApp = (String)meta.getLabels().get("Client-AppName");
        String acceptCharset = "UTF-8";
        ParamUtils.checkParam(tag);
        ParamUtils.checkParam(autoTag);
        int lockResult = ConfigCacheService.tryConfigReadLock(groupKey);
        String pullEvent = "pull";
        String pullType = "ok";
        ConfigQueryResponse response = new ConfigQueryResponse();
        CacheItem cacheItem = ConfigCacheService.getContentCache(groupKey);
        if (lockResult > 0 && cacheItem != null) {
            try {
                String encryptedDataKey;
                String content;
                String md5;
                long lastModified = 0L;
                boolean isBeta = cacheItem.isBeta() && cacheItem.getIps4Beta() != null && cacheItem.getIps4Beta().contains(clientIp) && cacheItem.getConfigCacheBeta() != null;
                String configType = cacheItem.getType();
                response.setContentType(null != configType ? configType : "text");
                if (isBeta) {
                    md5 = cacheItem.getConfigCacheBeta().getMd5(acceptCharset);
                    lastModified = cacheItem.getConfigCacheBeta().getLastModifiedTs();
                    content = ConfigDiskServiceFactory.getInstance().getBetaContent(dataId, group, tenant);
                    pullEvent = "pull-beta";
                    encryptedDataKey = cacheItem.getConfigCacheBeta().getEncryptedDataKey();
                    response.setBeta(true);
                } else if (StringUtils.isBlank((CharSequence)tag)) {
                    if (ConfigQueryRequestHandler.isUseTag(cacheItem, autoTag)) {
                        md5 = cacheItem.getTagMd5(autoTag, acceptCharset);
                        lastModified = cacheItem.getTagLastModified(autoTag);
                        encryptedDataKey = cacheItem.getTagEncryptedDataKey(autoTag);
                        content = ConfigDiskServiceFactory.getInstance().getTagContent(dataId, group, tenant, autoTag);
                        pullEvent = "pull-tag-" + autoTag;
                        response.setTag(URLEncoder.encode(autoTag, "UTF-8"));
                    } else {
                        md5 = cacheItem.getConfigCache().getMd5(acceptCharset);
                        lastModified = cacheItem.getConfigCache().getLastModifiedTs();
                        encryptedDataKey = cacheItem.getConfigCache().getEncryptedDataKey();
                        content = ConfigDiskServiceFactory.getInstance().getContent(dataId, group, tenant);
                        pullEvent = "pull";
                    }
                } else {
                    md5 = cacheItem.getTagMd5(tag, acceptCharset);
                    lastModified = cacheItem.getTagLastModified(tag);
                    encryptedDataKey = cacheItem.getTagEncryptedDataKey(tag);
                    content = ConfigDiskServiceFactory.getInstance().getTagContent(dataId, group, tenant, tag);
                    response.setTag(tag);
                    pullEvent = "pull-tag-" + tag;
                }
                response.setMd5(md5);
                response.setEncryptedDataKey(encryptedDataKey);
                response.setContent(content);
                response.setLastModified(lastModified);
                if (content == null) {
                    pullType = "not-found";
                    response.setErrorInfo(300, "config data not exist");
                } else {
                    response.setResultCode(ResponseCode.SUCCESS.getCode());
                }
                LogUtil.PULL_CHECK_LOG.warn("{}|{}|{}|{}", new Object[]{groupKey, clientIp, md5, TimeUtils.getCurrentTimeStr()});
                long delayed = notify ? -1L : System.currentTimeMillis() - lastModified;
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, lastModified, pullEvent, pullType, delayed, clientIp, notify, "grpc");
            }
            finally {
                ConfigCacheService.releaseReadLock(groupKey);
            }
        } else if (lockResult == 0 || cacheItem == null) {
            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, pullEvent, "not-found", -1L, clientIp, notify, "grpc");
            response.setErrorInfo(300, "config data not exist");
        } else {
            LogUtil.PULL_LOG.info("[client-get] clientIp={}, {}, get data during dump", (Object)clientIp, (Object)groupKey);
            response.setErrorInfo(400, "requested file is being modified, please try later.");
        }
        return response;
    }

    private static boolean isUseTag(CacheItem cacheItem, String tag) {
        return StringUtils.isNotBlank((String)tag) && cacheItem.getConfigCacheTags() != null && cacheItem.getConfigCacheTags().containsKey(tag);
    }
}

