/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.request;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.handler.ResponseHandler;
import com.alibaba.nacos.common.http.client.request.AsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.request.DefaultHttpClientRequest;
import com.alibaba.nacos.common.http.client.response.DefaultClientHttpResponse;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncHttpClientRequest
implements AsyncHttpClientRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClientRequest.class);
    private final CloseableHttpAsyncClient asyncClient;
    private final RequestConfig defaultConfig;

    public DefaultAsyncHttpClientRequest(CloseableHttpAsyncClient asyncClient, DefaultConnectingIOReactor ioReactor, RequestConfig defaultConfig) {
        this.asyncClient = asyncClient;
        this.defaultConfig = defaultConfig;
        if (this.asyncClient.getStatus() != IOReactorStatus.ACTIVE) {
            this.asyncClient.start();
        }
    }

    @Override
    public <T> void execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity, final ResponseHandler<T> responseHandler, final Callback<T> callback) throws Exception {
        HttpUriRequestBase httpRequestBase = DefaultHttpClientRequest.build(uri, httpMethod, requestHttpEntity, this.defaultConfig);
        FutureCallback<SimpleHttpResponse> futureCallback = new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse result) {
                DefaultClientHttpResponse response = new DefaultClientHttpResponse(result);
                try {
                    HttpRestResult httpRestResult = responseHandler.handle(response);
                    callback.onReceive(httpRestResult);
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }

            public void failed(Exception ex) {
                callback.onError(ex);
            }

            public void cancelled() {
                callback.onCancel();
            }
        };
        this.asyncClient.execute(SimpleHttpRequest.copy((HttpRequest)httpRequestBase), (FutureCallback)futureCallback);
    }

    @Override
    public void close() throws IOException {
        this.asyncClient.close();
    }
}

