/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.ability;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.constant.AbilityMode;
import com.alibaba.nacos.api.ability.constant.AbilityStatus;
import com.alibaba.nacos.api.ability.initializer.AbilityPostProcessor;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAbilityControlManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAbilityControlManager.class);
    protected final Map<AbilityMode, Map<String, Boolean>> currentNodeAbilities = new ConcurrentHashMap<AbilityMode, Map<String, Boolean>>();

    protected AbstractAbilityControlManager() {
        NotifyCenter.registerToPublisher(AbilityUpdateEvent.class, 16384);
        this.initAbilityTable();
    }

    private void initAbilityTable() {
        LOGGER.info("Ready to get current node abilities...");
        Map<AbilityMode, Map<AbilityKey, Boolean>> abilities = this.initCurrentNodeAbilities();
        for (AbilityMode mode : AbilityMode.values()) {
            Map<AbilityKey, Boolean> abilitiesTable = abilities.get(mode);
            if (abilitiesTable == null) continue;
            for (AbilityKey abilityKey : abilitiesTable.keySet()) {
                if (mode.equals((Object)abilityKey.getMode())) continue;
                LOGGER.error("You should not contain a other mode: {} in a specify mode: {} abilities set, error key: {}, please check again.", new Object[]{abilityKey.getMode(), mode, abilityKey});
                throw new IllegalStateException("Except mode: " + mode + " but " + abilityKey + " mode: " + abilityKey.getMode() + ", please check again.");
            }
            Collection<AbilityPostProcessor> processors = NacosServiceLoader.load(AbilityPostProcessor.class);
            for (AbilityPostProcessor processor : processors) {
                processor.process(mode, abilitiesTable);
            }
        }
        Set<AbilityMode> abilityModes = abilities.keySet();
        LOGGER.info("Ready to initialize current node abilities, support modes: {}", abilityModes);
        for (AbilityMode abilityMode : abilityModes) {
            this.currentNodeAbilities.put(abilityMode, new ConcurrentHashMap(AbilityKey.mapStr(abilities.get(abilityMode))));
        }
        LOGGER.info("Initialize current abilities finish...");
    }

    public void enableCurrentNodeAbility(AbilityKey abilityKey) {
        Map<String, Boolean> abilities = this.currentNodeAbilities.get(abilityKey.getMode());
        if (abilities != null) {
            this.doTurn(abilities, abilityKey, true);
        }
    }

    protected void doTurn(Map<String, Boolean> abilities, AbilityKey key, boolean turn) {
        LOGGER.info("Turn current node ability: {}, turn: {}", (Object)key, (Object)turn);
        abilities.put(key.getName(), turn);
        AbilityUpdateEvent abilityUpdateEvent = new AbilityUpdateEvent();
        abilityUpdateEvent.setTable(Collections.unmodifiableMap(abilities));
        abilityUpdateEvent.setOn(turn);
        abilityUpdateEvent.setAbilityKey(key);
        NotifyCenter.publishEvent(abilityUpdateEvent);
    }

    public void disableCurrentNodeAbility(AbilityKey abilityKey) {
        Map<String, Boolean> abilities = this.currentNodeAbilities.get(abilityKey.getMode());
        if (abilities != null) {
            this.doTurn(abilities, abilityKey, false);
        }
    }

    public AbilityStatus isCurrentNodeAbilityRunning(AbilityKey abilityKey) {
        Boolean support;
        Map<String, Boolean> abilities = this.currentNodeAbilities.get(abilityKey.getMode());
        if (abilities != null && (support = abilities.get(abilityKey.getName())) != null) {
            return support != false ? AbilityStatus.SUPPORTED : AbilityStatus.NOT_SUPPORTED;
        }
        return AbilityStatus.UNKNOWN;
    }

    protected abstract Map<AbilityMode, Map<AbilityKey, Boolean>> initCurrentNodeAbilities();

    public Map<String, Boolean> getCurrentNodeAbilities(AbilityMode mode) {
        Map<String, Boolean> abilities = this.currentNodeAbilities.get(mode);
        if (abilities != null) {
            return Collections.unmodifiableMap(abilities);
        }
        return Collections.emptyMap();
    }

    public abstract int getPriority();

    public static class AbilityUpdateEvent
    extends Event {
        private static final long serialVersionUID = -1232411212311111L;
        private AbilityKey abilityKey;
        private boolean isOn;
        private Map<String, Boolean> table;

        private AbilityUpdateEvent() {
        }

        public Map<String, Boolean> getAbilityTable() {
            return this.table;
        }

        public void setTable(Map<String, Boolean> abilityTable) {
            this.table = abilityTable;
        }

        public AbilityKey getAbilityKey() {
            return this.abilityKey;
        }

        public void setAbilityKey(AbilityKey abilityKey) {
            this.abilityKey = abilityKey;
        }

        public boolean isOn() {
            return this.isOn;
        }

        public void setOn(boolean on) {
            this.isOn = on;
        }
    }
}

