/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.security;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.AbstractServerListManager;
import com.alibaba.nacos.client.address.ServerListChangeEvent;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthService;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityProxy
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityProxy.class);
    private ClientAuthPluginManager clientAuthPluginManager = new ClientAuthPluginManager();

    public SecurityProxy(final AbstractServerListManager serverListManager, NacosRestTemplate nacosRestTemplate) {
        this.clientAuthPluginManager.init(serverListManager.getServerList(), nacosRestTemplate);
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber<ServerListChangeEvent>(){

            public void onEvent(ServerListChangeEvent event) {
                SecurityProxy.this.clientAuthPluginManager.refreshServerList(serverListManager.getServerList());
            }

            public Class<? extends Event> subscribeType() {
                return ServerListChangeEvent.class;
            }
        });
    }

    public void login(Properties properties) {
        if (this.clientAuthPluginManager.getAuthServiceSpiImplSet().isEmpty()) {
            return;
        }
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            clientAuthService.login(properties);
        }
    }

    public Map<String, String> getIdentityContext(RequestResource resource) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            LoginIdentityContext loginIdentityContext = clientAuthService.getLoginIdentityContext(resource);
            for (String key : loginIdentityContext.getAllKey()) {
                header.put(key, loginIdentityContext.getParameter(key));
            }
        }
        return header;
    }

    public void shutdown() throws NacosException {
        this.clientAuthPluginManager.shutdown();
    }

    public void reLogin() {
        if (this.clientAuthPluginManager.getAuthServiceSpiImplSet().isEmpty()) {
            return;
        }
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            try {
                LoginIdentityContext loginIdentityContext = clientAuthService.getLoginIdentityContext(new RequestResource());
                if (loginIdentityContext == null) continue;
                loginIdentityContext.setParameter("reLoginFlag", "true");
            }
            catch (Exception e) {
                LOGGER.error("[SecurityProxy] set reLoginFlag failed.", (Throwable)e);
            }
        }
    }
}

