/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.redo.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.redo.service.AbstractRedoService;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import org.slf4j.Logger;

public abstract class AbstractRedoTask<S extends AbstractRedoService>
extends AbstractExecuteTask {
    private final Logger logger;
    private final S redoService;

    public AbstractRedoTask(Logger logger, S redoService) {
        this.logger = logger;
        this.redoService = redoService;
    }

    public void run() {
        if (!((AbstractRedoService)this.redoService).isConnected()) {
            this.logger.warn("Grpc Connection is disconnect, skip current redo task");
            return;
        }
        try {
            this.redoData();
        }
        catch (Exception e) {
            this.logger.warn("Redo task run with unexpected exception: ", (Throwable)e);
        }
    }

    protected abstract void redoData() throws NacosException;

    protected S getRedoService() {
        return this.redoService;
    }
}

