/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.redo.service;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.redo.data.RedoData;
import com.alibaba.nacos.client.redo.service.AbstractRedoTask;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbstractRedoService
implements ConnectionEventListener,
Closeable {
    private static final String REDO_THREAD_NAME_PATTERN = "com.alibaba.nacos.client.%s.redo";
    private final Logger logger;
    private final ScheduledExecutorService redoExecutor;
    private final Map<Class<?>, Map<String, RedoData<?>>> redoDataMap;
    private int redoThreadCount;
    private long redoDelayTime;
    private volatile boolean connected = false;

    protected AbstractRedoService(Logger logger, NacosClientProperties properties, String module) {
        this.logger = logger;
        this.setProperties(properties);
        this.redoExecutor = new ScheduledThreadPoolExecutor(this.redoThreadCount, (ThreadFactory)new NameThreadFactory(String.format(REDO_THREAD_NAME_PATTERN, module)));
        this.redoDataMap = new ConcurrentHashMap(2);
    }

    private void setProperties(NacosClientProperties properties) {
        this.redoDelayTime = properties.getLong("redoDelayTime", Long.valueOf(3000L));
        this.redoThreadCount = properties.getInteger("redoDelayThreadCount", Integer.valueOf(1));
    }

    protected void startRedoTask() {
        this.redoExecutor.scheduleWithFixedDelay((Runnable)((Object)this.buildRedoTask()), this.redoDelayTime, this.redoDelayTime, TimeUnit.MILLISECONDS);
    }

    protected abstract AbstractRedoTask buildRedoTask();

    public void onConnected(Connection connection) {
        this.connected = true;
        this.logger.info("Grpc connection connect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisConnect(Connection connection) {
        this.connected = false;
        this.logger.warn("Grpc connection disconnect, mark to redo");
        for (Class<?> each : this.redoDataMap.keySet()) {
            Map<String, RedoData<?>> actualRedoData;
            Map<String, RedoData<?>> map = actualRedoData = this.redoDataMap.get(each);
            synchronized (map) {
                actualRedoData.values().forEach(redoData -> redoData.setRegistered(false));
            }
        }
        this.logger.warn("mark to redo completed");
    }

    public void shutdown() {
        this.logger.info("Shutdown grpc redo service executor {}", (Object)this.redoExecutor);
        this.redoDataMap.clear();
        this.redoExecutor.shutdownNow();
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void cachedRedoData(String key, RedoData<T> redoData, Class<T> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            actualRedoData.put(key, redoData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeRedoData(String key, Class<T> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            RedoData redoData = (RedoData)actualRedoData.get(key);
            if (null != redoData && !redoData.isExpectedRegistered()) {
                actualRedoData.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void dataRegistered(String key, Class<T> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            RedoData redoData = (RedoData)actualRedoData.get(key);
            if (null != redoData) {
                redoData.registered();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void dataDeregister(String key, Class<T> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            RedoData redoData = (RedoData)actualRedoData.get(key);
            if (null != redoData) {
                redoData.setUnregistering(true);
                redoData.setExpectedRegistered(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void dataDeregistered(String key, Class<T> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            RedoData redoData = (RedoData)actualRedoData.get(key);
            if (null != redoData) {
                redoData.unregistered();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataRegistered(String key, Class<?> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            RedoData redoData = (RedoData)actualRedoData.get(key);
            return null != redoData && redoData.isRegistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<RedoData<T>> findRedoData(Class<T> clazz) {
        Map actualRedoData;
        HashSet<RedoData<T>> result = new HashSet<RedoData<T>>();
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            for (RedoData each : actualRedoData.values()) {
                if (!each.isNeedRedo()) continue;
                result.add(each);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> RedoData<T> getRedoData(String key, Class<?> clazz) {
        Map actualRedoData;
        Map map = actualRedoData = this.redoDataMap.computeIfAbsent(clazz, k -> new ConcurrentHashMap(2));
        synchronized (map) {
            return (RedoData)actualRedoData.get(key);
        }
    }
}

