/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.utils.Chooser;
import com.alibaba.nacos.client.naming.utils.Pair;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Balancer {
    protected static Instance getHostByRandomWeight(List<Instance> hosts) {
        LogUtils.NAMING_LOGGER.debug("entry randomWithWeight");
        if (hosts == null || hosts.size() == 0) {
            LogUtils.NAMING_LOGGER.debug("hosts == null || hosts.size() == 0");
            return null;
        }
        LogUtils.NAMING_LOGGER.debug("new Chooser");
        ArrayList hostsWithWeight = new ArrayList();
        for (Instance host : hosts) {
            if (!host.isHealthy()) continue;
            hostsWithWeight.add(new Pair<Instance>(host, host.getWeight()));
        }
        LogUtils.NAMING_LOGGER.debug("for (Host host : hosts)");
        Chooser vipChooser = new Chooser("www.taobao.com");
        vipChooser.refresh(hostsWithWeight);
        LogUtils.NAMING_LOGGER.debug("vipChooser.refresh");
        return (Instance)vipChooser.randomWithWeight();
    }

    public static class RandomByWeight {
        public static List<Instance> selectAll(ServiceInfo serviceInfo) {
            List hosts = serviceInfo.getHosts();
            if (CollectionUtils.isEmpty((Collection)hosts)) {
                throw new IllegalStateException("no host to srv for serviceInfo: " + serviceInfo.getName());
            }
            return hosts;
        }

        public static Instance selectHost(ServiceInfo dom) {
            return Balancer.getHostByRandomWeight(RandomByWeight.selectAll(dom));
        }
    }
}

