/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.listener.ConfigFuzzyWatchChangeEvent;
import com.alibaba.nacos.api.config.listener.FuzzyWatchEventWatcher;
import com.alibaba.nacos.api.config.listener.FuzzyWatchLoadWatcher;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.client.config.common.GroupKey;
import com.alibaba.nacos.client.config.impl.ConfigFuzzyWatcherWrapper;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class ConfigFuzzyWatchContext {
    private static final Logger LOGGER = LogUtils.logger(ConfigFuzzyWatchContext.class);
    private String envName;
    private int taskId;
    private String groupKeyPattern;
    private Set<String> receivedGroupKeys = new ConcurrentHashSet();
    long syncVersion = 0L;
    private final AtomicBoolean isConsistentWithServer = new AtomicBoolean();
    final AtomicBoolean initializationCompleted = new AtomicBoolean(false);
    private volatile boolean isDiscard = false;
    long patternLimitTs = 0L;
    private static final long SUPPRESSED_PERIOD = 60000L;
    private Set<ConfigFuzzyWatcherWrapper> configFuzzyWatcherWrappers = new HashSet<ConfigFuzzyWatcherWrapper>();

    boolean patternLimitSuppressed() {
        return this.patternLimitTs > 0L && System.currentTimeMillis() - this.patternLimitTs < 60000L;
    }

    public void clearOverLimitTs() {
        this.patternLimitTs = 0L;
    }

    public void refreshOverLimitTs() {
        this.patternLimitTs = System.currentTimeMillis();
    }

    public ConfigFuzzyWatchContext(String envName, String groupKeyPattern) {
        this.envName = envName;
        this.groupKeyPattern = groupKeyPattern;
    }

    public Set<ConfigFuzzyWatcherWrapper> calculateListenersToNotify(String uuid) {
        HashSet<ConfigFuzzyWatcherWrapper> listenersToNotify = new HashSet();
        if (StringUtils.isEmpty((String)uuid)) {
            listenersToNotify = this.configFuzzyWatcherWrappers;
        } else {
            for (ConfigFuzzyWatcherWrapper listener : this.configFuzzyWatcherWrappers) {
                if (!uuid.equals(listener.getUuid())) continue;
                listenersToNotify.add(listener);
            }
        }
        return listenersToNotify;
    }

    public void notifyWatcher(String groupKey, String changedType, String syncType, String uuid) {
        Set<ConfigFuzzyWatcherWrapper> listenersToNotify = this.calculateListenersToNotify(uuid);
        this.doNotifyWatchers(groupKey, changedType, syncType, listenersToNotify);
    }

    private void doNotifyWatchers(String groupKey, String changedType, String syncType, Set<ConfigFuzzyWatcherWrapper> listenersToNotify) {
        for (ConfigFuzzyWatcherWrapper watcher : listenersToNotify) {
            this.doNotifyWatcher(groupKey, changedType, syncType, watcher);
        }
    }

    public void notifyLoaderWatcher(int code) {
        if (this.patternLimitSuppressed()) {
            return;
        }
        boolean notify = false;
        for (ConfigFuzzyWatcherWrapper configFuzzyWatcherWrapper : this.calculateListenersToNotify(null)) {
            if (!(configFuzzyWatcherWrapper.fuzzyWatchEventWatcher instanceof FuzzyWatchLoadWatcher)) continue;
            if (ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getCode().equals(code)) {
                ((FuzzyWatchLoadWatcher)configFuzzyWatcherWrapper.fuzzyWatchEventWatcher).onConfigReachUpLimit();
                notify = true;
            }
            if (!ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getCode().equals(code)) continue;
            ((FuzzyWatchLoadWatcher)configFuzzyWatcherWrapper.fuzzyWatchEventWatcher).onPatternOverLimit();
            notify = true;
        }
        if (notify) {
            this.refreshOverLimitTs();
        }
    }

    private void doNotifyWatcher(String groupKey, final String changedType, String syncType, final ConfigFuzzyWatcherWrapper configFuzzyWatcher) {
        if ("ADD_CONFIG".equals(changedType) && configFuzzyWatcher.getSyncGroupKeys().contains(groupKey)) {
            return;
        }
        if ("DELETE_CONFIG".equals(changedType) && !configFuzzyWatcher.getSyncGroupKeys().contains(groupKey)) {
            return;
        }
        String[] parseKey = GroupKey.parseKey(groupKey);
        final String dataId = parseKey[0];
        final String group = parseKey[1];
        final String tenant = parseKey[2];
        final String resetSyncType = this.initializationCompleted.get() ? syncType : "FUZZY_WATCH_INIT_NOTIFY";
        AbstractFuzzyNotifyTask job = new AbstractFuzzyNotifyTask(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                ConfigFuzzyWatchChangeEvent event = ConfigFuzzyWatchChangeEvent.build((String)tenant, (String)group, (String)dataId, (String)changedType, (String)resetSyncType);
                if (configFuzzyWatcher != null) {
                    configFuzzyWatcher.fuzzyWatchEventWatcher.onEvent(event);
                }
                LOGGER.info("[{}] [notify-fuzzy-watcher-ok] dataId={}, group={}, tenant={}, watcher={}, job run cost={} millis.", new Object[]{ConfigFuzzyWatchContext.this.envName, dataId, group, tenant, configFuzzyWatcher, System.currentTimeMillis() - start});
                if (changedType.equals("DELETE_CONFIG")) {
                    configFuzzyWatcher.getSyncGroupKeys().remove(GroupKey.getKey(dataId, group, tenant));
                } else if (changedType.equals("ADD_CONFIG")) {
                    configFuzzyWatcher.getSyncGroupKeys().add(GroupKey.getKey(dataId, group, tenant));
                }
            }
        };
        try {
            if (null != configFuzzyWatcher.fuzzyWatchEventWatcher.getExecutor()) {
                LOGGER.info("[{}] [notify-fuzzy-watcher] task submitted to user executor, dataId={}, group={}, tenant={}, listener={}.", new Object[]{this.envName, dataId, group, tenant, configFuzzyWatcher});
                job.async = true;
                configFuzzyWatcher.fuzzyWatchEventWatcher.getExecutor().execute(job);
            } else {
                LOGGER.info("[{}] [notify-fuzzy-watcher] task execute in nacos thread, dataId={}, group={}, tenant={}, listener={}.", new Object[]{this.envName, dataId, group, tenant, configFuzzyWatcher});
                job.run();
            }
        }
        catch (Throwable t) {
            LOGGER.error("[{}] [notify-fuzzy-watcher-error] dataId={}, group={}, tenant={}, listener={}, throwable={}.", new Object[]{this.envName, dataId, group, tenant, configFuzzyWatcher, t.getCause()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markInitializationComplete() {
        this.initializationCompleted.set(true);
        ConfigFuzzyWatchContext configFuzzyWatchContext = this;
        synchronized (configFuzzyWatchContext) {
            this.notifyAll();
        }
    }

    public void removeWatcher(FuzzyWatchEventWatcher watcher) {
        Iterator<ConfigFuzzyWatcherWrapper> iterator = this.configFuzzyWatcherWrappers.iterator();
        while (iterator.hasNext()) {
            ConfigFuzzyWatcherWrapper next = iterator.next();
            if (!next.fuzzyWatchEventWatcher.equals((Object)watcher)) continue;
            iterator.remove();
            LOGGER.info("[{}] [remove-fuzzy-watcher-ok] groupKeyPattern={}, watcher={},uuid={} ", new Object[]{this.getEnvName(), this.groupKeyPattern, watcher, next.getUuid()});
        }
    }

    public boolean addWatcher(ConfigFuzzyWatcherWrapper configFuzzyWatcherWrapper) {
        boolean added = this.configFuzzyWatcherWrappers.add(configFuzzyWatcherWrapper);
        if (added) {
            LOGGER.info("[{}] [add-fuzzy-watcher-ok] groupKeyPattern={}, watcher={},uuid={} ", new Object[]{this.getEnvName(), this.groupKeyPattern, configFuzzyWatcherWrapper.fuzzyWatchEventWatcher, configFuzzyWatcherWrapper.getUuid()});
        }
        return added;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public String getGroupKeyPattern() {
        return this.groupKeyPattern;
    }

    public boolean isConsistentWithServer() {
        return this.isConsistentWithServer.get();
    }

    public void setConsistentWithServer(boolean isConsistentWithServer) {
        this.isConsistentWithServer.set(isConsistentWithServer);
    }

    public boolean isDiscard() {
        return this.isDiscard;
    }

    public void setDiscard(boolean discard) {
        this.isDiscard = discard;
    }

    public boolean isInitializing() {
        return !this.initializationCompleted.get();
    }

    public int getReceivedGroupKeysCount() {
        return this.receivedGroupKeys.size();
    }

    public Set<String> getReceivedGroupKeys() {
        return Collections.unmodifiableSet(this.receivedGroupKeys);
    }

    public void refreshSyncVersion() {
        this.syncVersion = System.currentTimeMillis();
    }

    public boolean addReceivedGroupKey(String groupKey) {
        boolean added = this.receivedGroupKeys.add(groupKey);
        if (added) {
            this.refreshSyncVersion();
        }
        return added;
    }

    public boolean removeReceivedGroupKey(String groupKey) {
        boolean removed = this.receivedGroupKeys.remove(groupKey);
        if (removed) {
            this.refreshSyncVersion();
        }
        return removed;
    }

    public Set<ConfigFuzzyWatcherWrapper> getConfigFuzzyWatcherWrappers() {
        return this.configFuzzyWatcherWrappers;
    }

    void syncFuzzyWatchers() {
        for (ConfigFuzzyWatcherWrapper configFuzzyWatcher : this.configFuzzyWatcherWrappers) {
            Set<String> syncGroupKeys;
            if (configFuzzyWatcher.syncVersion == this.syncVersion) continue;
            HashSet<String> receivedGroupKeysContext = new HashSet<String>(this.getReceivedGroupKeys());
            List groupKeyStates = FuzzyGroupKeyPattern.diffGroupKeys(receivedGroupKeysContext, syncGroupKeys = configFuzzyWatcher.getSyncGroupKeys());
            if (CollectionUtils.isEmpty((Collection)groupKeyStates)) {
                configFuzzyWatcher.syncVersion = this.syncVersion;
                continue;
            }
            for (FuzzyGroupKeyPattern.GroupKeyState groupKeyState : groupKeyStates) {
                String changedType = groupKeyState.isExist() ? "ADD_CONFIG" : "DELETE_CONFIG";
                this.doNotifyWatcher(groupKeyState.getGroupKey(), changedType, "FUZZY_WATCH_DIFF_SYNC_NOTIFY", configFuzzyWatcher);
            }
        }
    }

    public Future<Set<String>> createNewFuture() {
        Future<Set<String>> future = new Future<Set<String>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException("not support to cancel fuzzy watch");
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return ConfigFuzzyWatchContext.this.initializationCompleted.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<String> get() throws InterruptedException, ExecutionException {
                if (!ConfigFuzzyWatchContext.this.initializationCompleted.get()) {
                    ConfigFuzzyWatchContext configFuzzyWatchContext = ConfigFuzzyWatchContext.this;
                    synchronized (configFuzzyWatchContext) {
                        ConfigFuzzyWatchContext.this.wait();
                    }
                }
                return new HashSet<String>(ConfigFuzzyWatchContext.this.getReceivedGroupKeys());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<String> get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
                if (!ConfigFuzzyWatchContext.this.initializationCompleted.get()) {
                    ConfigFuzzyWatchContext configFuzzyWatchContext = ConfigFuzzyWatchContext.this;
                    synchronized (configFuzzyWatchContext) {
                        ConfigFuzzyWatchContext.this.wait(unit.toMillis(timeout));
                    }
                }
                if (!ConfigFuzzyWatchContext.this.initializationCompleted.get()) {
                    throw new TimeoutException("fuzzy watch result future timeout for " + unit.toMillis(timeout) + " millis");
                }
                return new HashSet<String>(ConfigFuzzyWatchContext.this.getReceivedGroupKeys());
            }
        };
        return future;
    }

    static abstract class AbstractFuzzyNotifyTask
    implements Runnable {
        boolean async = false;

        AbstractFuzzyNotifyTask() {
        }

        public boolean isAsync() {
            return this.async;
        }
    }
}

