/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.event;

import com.alibaba.nacos.api.ai.listener.NacosAgentCardEvent;
import com.alibaba.nacos.api.ai.listener.NacosMcpServerEvent;
import com.alibaba.nacos.client.ai.event.AbstractAiListenerInvoker;
import com.alibaba.nacos.client.ai.event.AgentCardChangedEvent;
import com.alibaba.nacos.client.ai.event.AgentCardListenerInvoker;
import com.alibaba.nacos.client.ai.event.McpServerChangedEvent;
import com.alibaba.nacos.client.ai.event.McpServerListenerInvoker;
import com.alibaba.nacos.client.ai.utils.CacheKeyUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AiChangeNotifier
extends SmartSubscriber {
    private final Map<String, Set<McpServerListenerInvoker>> mcpServerListenerInvokers = new ConcurrentHashMap<String, Set<McpServerListenerInvoker>>(2);
    private final Map<String, Set<AgentCardListenerInvoker>> agentCardListenerInvokers = new ConcurrentHashMap<String, Set<AgentCardListenerInvoker>>(2);

    public void onEvent(Event event) {
        if (event instanceof McpServerChangedEvent) {
            this.handleMcpServerChangedEvent((McpServerChangedEvent)event);
        } else if (event instanceof AgentCardChangedEvent) {
            this.handleAgentCardChangedEvent((AgentCardChangedEvent)event);
        }
    }

    private void handleMcpServerChangedEvent(McpServerChangedEvent event) {
        String mcpServerKey = CacheKeyUtils.buildMcpServerKey(event.getMcpName(), event.getVersion());
        if (!this.isSubscribed(mcpServerKey, this.mcpServerListenerInvokers)) {
            return;
        }
        NacosMcpServerEvent notifiedEvent = new NacosMcpServerEvent(event.getMcpServer());
        for (McpServerListenerInvoker each : this.mcpServerListenerInvokers.get(mcpServerKey)) {
            each.invoke(notifiedEvent);
        }
    }

    private void handleAgentCardChangedEvent(AgentCardChangedEvent event) {
        String agentCardKey = CacheKeyUtils.buildAgentCardKey(event.getAgentName(), event.getVersion());
        if (!this.isSubscribed(agentCardKey, this.agentCardListenerInvokers)) {
            return;
        }
        NacosAgentCardEvent notifiedEvent = new NacosAgentCardEvent(event.getAgentCard());
        for (AgentCardListenerInvoker each : this.agentCardListenerInvokers.get(agentCardKey)) {
            each.invoke(notifiedEvent);
        }
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> listenedEventTypes = new LinkedList<Class<? extends Event>>();
        listenedEventTypes.add(McpServerChangedEvent.class);
        listenedEventTypes.add(AgentCardChangedEvent.class);
        return listenedEventTypes;
    }

    public void registerListener(String mcpName, String version, McpServerListenerInvoker listenerInvoker) {
        if (listenerInvoker == null) {
            return;
        }
        String mcpServerKey = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        this.mcpServerListenerInvokers.compute(mcpServerKey, (key, mcpServerListenerInvokers) -> {
            if (null == mcpServerListenerInvokers) {
                mcpServerListenerInvokers = new ConcurrentHashSet();
            }
            mcpServerListenerInvokers.add(listenerInvoker);
            return mcpServerListenerInvokers;
        });
    }

    public void registerListener(String agentName, String version, AgentCardListenerInvoker listenerInvoker) {
        if (listenerInvoker == null) {
            return;
        }
        String agentCardKey = CacheKeyUtils.buildAgentCardKey(agentName, version);
        this.agentCardListenerInvokers.compute(agentCardKey, (key, agentCardListenerInvokers) -> {
            if (null == agentCardListenerInvokers) {
                agentCardListenerInvokers = new ConcurrentHashSet();
            }
            agentCardListenerInvokers.add(listenerInvoker);
            return agentCardListenerInvokers;
        });
    }

    public void deregisterListener(String mcpName, String version, McpServerListenerInvoker listenerInvoker) {
        if (listenerInvoker == null) {
            return;
        }
        String mcpServerKey = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        this.mcpServerListenerInvokers.compute(mcpServerKey, (key, mcpServerListenerInvokers) -> {
            if (null == mcpServerListenerInvokers) {
                return null;
            }
            mcpServerListenerInvokers.remove(listenerInvoker);
            return mcpServerListenerInvokers.isEmpty() ? null : mcpServerListenerInvokers;
        });
    }

    public void deregisterListener(String agentName, String version, AgentCardListenerInvoker listenerInvoker) {
        if (listenerInvoker == null) {
            return;
        }
        String agentCardKey = CacheKeyUtils.buildAgentCardKey(agentName, version);
        this.agentCardListenerInvokers.compute(agentCardKey, (key, agentCardListenerInvokers) -> {
            if (null == agentCardListenerInvokers) {
                return null;
            }
            agentCardListenerInvokers.remove(listenerInvoker);
            return agentCardListenerInvokers.isEmpty() ? null : agentCardListenerInvokers;
        });
    }

    public boolean isMcpServerSubscribed(String mcpName, String version) {
        String mcpServerKey = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        return this.isSubscribed(mcpServerKey, this.mcpServerListenerInvokers);
    }

    public boolean isAgentCardSubscribed(String agentName, String version) {
        String agentCardKey = CacheKeyUtils.buildAgentCardKey(agentName, version);
        return this.isSubscribed(agentCardKey, this.agentCardListenerInvokers);
    }

    private <T extends AbstractAiListenerInvoker> boolean isSubscribed(String key, Map<String, Set<T>> listenerInvokers) {
        return CollectionUtils.isNotEmpty((Collection)listenerInvokers.get(key));
    }
}

