/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.event;

import com.alibaba.nacos.api.ai.listener.NacosAiEvent;
import com.alibaba.nacos.api.ai.listener.NacosAiListener;
import com.alibaba.nacos.client.selector.ListenerInvoker;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAiListenerInvoker<E extends NacosAiEvent, L extends NacosAiListener<E>>
implements ListenerInvoker<E> {
    protected final L listener;
    private final AtomicBoolean invoked = new AtomicBoolean(false);

    public AbstractAiListenerInvoker(L listener) {
        this.listener = listener;
    }

    @Override
    public void invoke(E event) {
        this.invoked.set(true);
        this.logInvoke(event);
        if (this.listener.getExecutor() != null) {
            this.listener.getExecutor().execute(() -> this.listener.onEvent(event));
        } else {
            this.listener.onEvent(event);
        }
    }

    protected abstract void logInvoke(E var1);

    @Override
    public boolean isInvoked() {
        return this.invoked.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        AbstractAiListenerInvoker that = (AbstractAiListenerInvoker)o;
        return Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hashCode(this.listener);
    }
}

