/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.listener.FuzzyWatchEventWatcher;
import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchRequest;
import com.alibaba.nacos.api.naming.remote.response.NamingFuzzyWatchResponse;
import com.alibaba.nacos.client.naming.cache.FuzzyWatchEventWatcherWrapper;
import com.alibaba.nacos.client.naming.cache.NamingFuzzyWatchContext;
import com.alibaba.nacos.client.naming.event.NamingFuzzyWatchLoadEvent;
import com.alibaba.nacos.client.naming.event.NamingFuzzyWatchNotifyEvent;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class NamingFuzzyWatchServiceListHolder
extends SmartSubscriber {
    private static final Logger LOGGER = LogUtils.logger(NamingFuzzyWatchServiceListHolder.class);
    private String notifierEventScope;
    private NamingGrpcClientProxy namingGrpcClientProxy;
    private final BlockingQueue<Object> fuzzyWatchExecuteBell = new ArrayBlockingQueue<Object>(1);
    private final Object bellItem = new Object();
    private final AtomicLong fuzzyWatchLastAllSyncTime = new AtomicLong(System.currentTimeMillis());
    private static final long FUZZY_LISTEN_ALL_SYNC_INTERNAL = 180000L;
    ScheduledExecutorService executorService;
    private Map<String, NamingFuzzyWatchContext> fuzzyMatchContextMap = new ConcurrentHashMap<String, NamingFuzzyWatchContext>();

    public NamingFuzzyWatchServiceListHolder(String notifierEventScope) {
        this.notifierEventScope = notifierEventScope;
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void shutdown() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    public void start() {
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.naming.fuzzy.watch.Worker"));
        this.executorService.submit(() -> {
            while (!this.executorService.isShutdown() && !this.executorService.isTerminated()) {
                try {
                    this.fuzzyWatchExecuteBell.poll(5L, TimeUnit.SECONDS);
                    if (this.executorService.isShutdown() || this.executorService.isTerminated()) continue;
                    this.executeNamingFuzzyWatch();
                }
                catch (Throwable e) {
                    LOGGER.error("[rpc-fuzzy-watch-execute] rpc fuzzy watch exception", e);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyFuzzyWatchSync();
                }
            }
        });
    }

    public void registerNamingGrpcClientProxy(NamingGrpcClientProxy namingGrpcClientProxy) {
        this.namingGrpcClientProxy = namingGrpcClientProxy;
    }

    public NamingFuzzyWatchContext getFuzzyWatchContext(String groupKeyPattern) {
        return this.fuzzyMatchContextMap.get(groupKeyPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingFuzzyWatchContext registerFuzzyWatcher(String groupKeyPattern, FuzzyWatchEventWatcher watcher) {
        if (!this.namingGrpcClientProxy.isAbilitySupportedByServer(AbilityKey.SERVER_FUZZY_WATCH)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support fuzzy watch feature.");
        }
        NamingFuzzyWatchContext namingFuzzyWatchContext = this.initFuzzyWatchContextIfNeed(groupKeyPattern);
        namingFuzzyWatchContext.setDiscard(false);
        NamingFuzzyWatchContext namingFuzzyWatchContext2 = namingFuzzyWatchContext;
        synchronized (namingFuzzyWatchContext2) {
            FuzzyWatchEventWatcherWrapper fuzzyWatchEventWatcherWrapper = new FuzzyWatchEventWatcherWrapper(watcher);
            if (namingFuzzyWatchContext.getFuzzyWatchEventWatcherWrappers().add(fuzzyWatchEventWatcherWrapper)) {
                LOGGER.info(" [add-watcher-ok] groupKeyPattern={}, watcher={},uuid={} ", new Object[]{groupKeyPattern, watcher, fuzzyWatchEventWatcherWrapper.getUuid()});
                Set<String> receivedServiceKeys = namingFuzzyWatchContext.getReceivedServiceKeys();
                if (CollectionUtils.isNotEmpty(receivedServiceKeys)) {
                    for (String serviceKey : receivedServiceKeys) {
                        NamingFuzzyWatchNotifyEvent namingFuzzyWatchNotifyEvent = NamingFuzzyWatchNotifyEvent.build(this.notifierEventScope, groupKeyPattern, serviceKey, "ADD_SERVICE", "FUZZY_WATCH_INIT_NOTIFY", fuzzyWatchEventWatcherWrapper.getUuid());
                        NotifyCenter.publishEvent((Event)namingFuzzyWatchNotifyEvent);
                    }
                }
            }
        }
        return namingFuzzyWatchContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingFuzzyWatchContext initFuzzyWatchContextIfNeed(String groupKeyPattern) {
        if (!this.fuzzyMatchContextMap.containsKey(groupKeyPattern)) {
            Map<String, NamingFuzzyWatchContext> map = this.fuzzyMatchContextMap;
            synchronized (map) {
                if (this.fuzzyMatchContextMap.containsKey(groupKeyPattern)) {
                    return this.fuzzyMatchContextMap.get(groupKeyPattern);
                }
                LOGGER.info("[fuzzy-watch] init fuzzy watch context for pattern {}", (Object)groupKeyPattern);
                this.fuzzyMatchContextMap.putIfAbsent(groupKeyPattern, new NamingFuzzyWatchContext(this.notifierEventScope, groupKeyPattern));
                this.notifyFuzzyWatchSync();
            }
        }
        return this.fuzzyMatchContextMap.get(groupKeyPattern);
    }

    public synchronized void removePatternMatchCache(String groupKeyPattern) {
        NamingFuzzyWatchContext namingFuzzyWatchContext = this.fuzzyMatchContextMap.get(groupKeyPattern);
        if (namingFuzzyWatchContext == null) {
            return;
        }
        if (namingFuzzyWatchContext.isDiscard() && namingFuzzyWatchContext.getFuzzyWatchEventWatcherWrappers().isEmpty()) {
            LOGGER.info("[fuzzy-watch] remove fuzzy watch context for pattern {}", (Object)groupKeyPattern);
            this.fuzzyMatchContextMap.remove(groupKeyPattern);
        }
    }

    void notifyFuzzyWatchSync() {
        this.fuzzyWatchExecuteBell.offer(this.bellItem);
    }

    public void executeNamingFuzzyWatch() throws NacosException {
        long now = System.currentTimeMillis();
        boolean needAllSync = now - this.fuzzyWatchLastAllSyncTime.get() >= 180000L;
        ArrayList<NamingFuzzyWatchContext> needSyncContexts = new ArrayList<NamingFuzzyWatchContext>();
        for (NamingFuzzyWatchContext context : this.fuzzyMatchContextMap.values()) {
            if (context.isConsistentWithServer()) {
                context.syncFuzzyWatchers();
                if (!needAllSync) continue;
            }
            needSyncContexts.add(context);
        }
        this.doExecuteNamingFuzzyWatch(needSyncContexts);
        if (needAllSync) {
            this.fuzzyWatchLastAllSyncTime.set(now);
        }
    }

    public void resetConsistenceStatus() {
        this.fuzzyMatchContextMap.values().forEach(fuzzyWatcherContext -> fuzzyWatcherContext.setConsistentWithServer(false));
    }

    private void doExecuteNamingFuzzyWatch(List<NamingFuzzyWatchContext> contextLists) throws NacosException {
        if (CollectionUtils.isEmpty(contextLists)) {
            return;
        }
        for (NamingFuzzyWatchContext entry : contextLists) {
            NamingFuzzyWatchRequest configFuzzyWatchRequest = this.buildFuzzyWatchNamingRequest(entry);
            try {
                NamingFuzzyWatchResponse listenResponse = this.namingGrpcClientProxy.fuzzyWatchRequest(configFuzzyWatchRequest);
                if (listenResponse == null || !listenResponse.isSuccess()) continue;
                if (configFuzzyWatchRequest.getWatchType().equals("CANCEL_WATCH")) {
                    this.removePatternMatchCache(entry.getGroupKeyPattern());
                } else {
                    entry.setConsistentWithServer(true);
                }
                entry.clearOverLimitTs();
            }
            catch (NacosException e) {
                if (ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getCode().intValue() == e.getErrCode() || ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getCode().intValue() == e.getErrCode()) {
                    LOGGER.error(" fuzzy watch pattern over limit,pattern ->{} ,fuzzy watch will be suppressed,msg={}", (Object)entry.getGroupKeyPattern(), (Object)e.getErrMsg());
                    NamingFuzzyWatchLoadEvent namingFuzzyWatchLoadEvent = NamingFuzzyWatchLoadEvent.buildEvent(e.getErrCode(), entry.getGroupKeyPattern(), this.notifierEventScope);
                    NotifyCenter.publishEvent((Event)namingFuzzyWatchLoadEvent);
                    continue;
                }
                LOGGER.error(" fuzzy watch request fail.", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.notifyFuzzyWatchSync();
            }
        }
    }

    private NamingFuzzyWatchRequest buildFuzzyWatchNamingRequest(NamingFuzzyWatchContext namingFuzzyWatchContext) {
        NamingFuzzyWatchRequest namingFuzzyWatchRequest = new NamingFuzzyWatchRequest();
        namingFuzzyWatchRequest.setInitializing(namingFuzzyWatchContext.isInitializing());
        namingFuzzyWatchRequest.setNamespace(this.namingGrpcClientProxy.getNamespaceId());
        namingFuzzyWatchRequest.setReceivedGroupKeys(namingFuzzyWatchContext.getReceivedServiceKeys());
        namingFuzzyWatchRequest.setGroupKeyPattern(namingFuzzyWatchContext.getGroupKeyPattern());
        if (namingFuzzyWatchContext.isDiscard() && namingFuzzyWatchContext.getFuzzyWatchEventWatcherWrappers().isEmpty()) {
            namingFuzzyWatchRequest.setWatchType("CANCEL_WATCH");
        } else {
            namingFuzzyWatchRequest.setWatchType("WATCH");
        }
        return namingFuzzyWatchRequest;
    }

    public Map<String, NamingFuzzyWatchContext> getFuzzyMatchContextMap() {
        return this.fuzzyMatchContextMap;
    }

    public void onEvent(Event event) {
        if (event instanceof NamingFuzzyWatchNotifyEvent) {
            if (!event.scope().equals(this.notifierEventScope)) {
                return;
            }
            NamingFuzzyWatchNotifyEvent watchNotifyEvent = (NamingFuzzyWatchNotifyEvent)event;
            String changedType = watchNotifyEvent.getChangedType();
            String syncType = watchNotifyEvent.getSyncType();
            String serviceKey = watchNotifyEvent.getServiceKey();
            String pattern = watchNotifyEvent.getPattern();
            String watchUuid = watchNotifyEvent.getWatcherUuid();
            NamingFuzzyWatchContext namingFuzzyWatchContext = this.fuzzyMatchContextMap.get(pattern);
            if (namingFuzzyWatchContext == null) {
                return;
            }
            namingFuzzyWatchContext.notifyFuzzyWatchers(serviceKey, changedType, syncType, watchUuid);
        }
        if (event instanceof NamingFuzzyWatchLoadEvent) {
            if (!event.scope().equals(this.notifierEventScope)) {
                return;
            }
            NamingFuzzyWatchLoadEvent overLimitEvent = (NamingFuzzyWatchLoadEvent)event;
            NamingFuzzyWatchContext namingFuzzyWatchContext = this.fuzzyMatchContextMap.get(overLimitEvent.getGroupKeyPattern());
            if (namingFuzzyWatchContext == null) {
                return;
            }
            namingFuzzyWatchContext.notifyOverLimitWatchers(overLimitEvent.getCode());
        }
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(NamingFuzzyWatchNotifyEvent.class);
        result.add(NamingFuzzyWatchLoadEvent.class);
        return result;
    }

    public String getNotifierEventScope() {
        return this.notifierEventScope;
    }
}

