/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.utils;

import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.env.SourceType;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;

public class InitUtils {
    public static String initNamespaceForNaming(NacosClientProperties properties) {
        String tmpNamespace = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", properties.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            tmpNamespace = TenantUtil.getUserTenantForAns();
            LogUtils.NAMING_LOGGER.info("initializer namespace from ans.namespace attribute : {}", (Object)tmpNamespace);
            tmpNamespace = TemplateUtils.stringEmptyAndThenExecute((String)tmpNamespace, () -> {
                String namespace = properties.getProperty("ALIBABA_ALIWARE_NAMESPACE");
                LogUtils.NAMING_LOGGER.info("initializer namespace from ALIBABA_ALIWARE_NAMESPACE attribute :" + namespace);
                return namespace;
            });
        }
        if (StringUtils.isEmpty((String)(tmpNamespace = TemplateUtils.stringEmptyAndThenExecute((String)tmpNamespace, () -> {
            String namespace = properties.getPropertyFrom(SourceType.JVM, "namespace");
            LogUtils.NAMING_LOGGER.info("initializer namespace from namespace attribute :" + namespace);
            return namespace;
        })))) {
            tmpNamespace = properties.getProperty("namespace");
        }
        tmpNamespace = TemplateUtils.stringEmptyAndThenExecute((String)tmpNamespace, () -> "public");
        return tmpNamespace;
    }

    public static void initWebRootContext(NacosClientProperties properties) {
        String webContext = properties.getProperty("contextPath");
        TemplateUtils.stringNotEmptyAndThenExecute((String)webContext, () -> {
            UtilAndComs.webContext = ContextPathUtil.normalizeContextPath((String)webContext);
            UtilAndComs.nacosUrlBase = UtilAndComs.webContext + "/v1/ns";
            UtilAndComs.nacosUrlInstance = UtilAndComs.nacosUrlBase + "/instance";
        });
    }

    public static void initSerialization() {
        JacksonUtils.registerSubtype(NoneSelector.class, (String)SelectorType.none.name());
        JacksonUtils.registerSubtype(ExpressionSelector.class, (String)SelectorType.label.name());
    }
}

