/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class Limiter {
    private static final Logger LOGGER = LogUtils.logger(Limiter.class);
    private static final int CAPACITY_SIZE = 1000;
    private static final int LIMIT_TIME = 1000;
    private static final Cache<String, RateLimiter> CACHE = CacheBuilder.newBuilder().initialCapacity(1000).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final String LIMIT_TIME_PROPERTY = "limitTime";
    private static double limit = 5.0;

    public static boolean isLimit(String accessKeyId) {
        RateLimiter rateLimiter = null;
        try {
            rateLimiter = (RateLimiter)CACHE.get((Object)accessKeyId, () -> RateLimiter.create((double)limit));
        }
        catch (Exception e) {
            LOGGER.error("create limit fail", (Throwable)e);
        }
        if (rateLimiter != null && !rateLimiter.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
            LOGGER.error("access_key_id:{} limited", (Object)accessKeyId);
            return true;
        }
        return false;
    }

    static {
        try {
            String limitTimeStr = NacosClientProperties.PROTOTYPE.getProperty(LIMIT_TIME_PROPERTY, String.valueOf(limit));
            limit = Double.parseDouble(limitTimeStr);
            LOGGER.info("limitTime:{}", (Object)limit);
        }
        catch (Exception e) {
            LOGGER.error("init limitTime fail", (Throwable)e);
        }
    }
}

